<?php
/*
Template Name: Login Page
*/
?>
<?php
    $et_ptemplate_settings = array();
    $et_ptemplate_settings = maybe_unserialize( get_post_meta(get_the_ID(),'et_ptemplate_settings',true) );

    $fullwidth = isset( $et_ptemplate_settings['et_fullwidthpage'] ) ? (bool) $et_ptemplate_settings['et_fullwidthpage'] : false;
?>

<?php get_header(); ?>
    <div id="content"<?php if ( $fullwidth ) echo ' class="full"'; ?>>
        <div class="content_wrap<?php if ( $fullwidth ) echo ' full'; ?>">
            <div class="content_wrap<?php if ( $fullwidth ) echo ' full'; ?>">
                <div id="posts"<?php if ( $fullwidth ) echo ' class="post_full"'; ?>>
                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                    <?php if (get_option('simplepress_integration_single_top') <> '' && get_option('simplepress_integrate_singletop_enable') == 'on') echo(get_option('simplepress_integration_single_top')); ?>
                    <?php $thumb = '';
                    $width = 182;
                    $height = 182;
                    $classtext = '';
                    $titletext = get_the_title();
                    $thumbnail = get_thumbnail($width,$height,$classtext,$titletext,$titletext);
                    $thumb = $thumbnail["thumb"]; ?>
                    <h1 class="title"><?php the_title(); ?></h1>
                    <br class="clear" />
                    <div class="post<?php if($fullwidth) echo(' post_full');?>">
                        <?php if ($thumb <> '' && get_option('simplepress_page_thumbnails') == 'on') { ?>
                        <div class="thumb">
                            <div>
                                <span class="image" style="background-image: url(<?php print_thumbnail($thumb, $thumbnail["use_timthumb"], $titletext, $width, $height, $classtext, true, true); ?>);">
                                    <img src="<?php echo get_template_directory_uri(); ?>/images/thumb-overlay.png" alt="" />
                                </span>
                            </div>
                            <span class="shadow"></span>
                        </div>
                        <?php }; ?>
                                <?php the_content(''); ?>
                            <br class="clear" />

                            <div id="et-login">
                                <div class='et-protected'>
                                    <div class='et-protected-form'>
                                        <?php $scheme = apply_filters( 'et_forms_scheme', null ); ?>

                                        <form action='<?php echo esc_url( home_url( '', $scheme ) ); ?>/wp-login.php' method='post'>
                                            <p><label><span><?php esc_html_e('Username','SimplePress'); ?>: </span><input type='text' name='log' id='log' value='<?php echo esc_attr($user_login); ?>' size='20' /><span class='et_protected_icon'></span></label></p>
                                            <p><label><span><?php esc_html_e('Password','SimplePress'); ?>: </span><input type='password' name='pwd' id='pwd' size='20' /><span class='et_protected_icon et_protected_password'></span></label></p>
                                            <input type='submit' name='submit' value='Login' class='etlogin-button' />
                                        </form>
                                    </div> <!-- .et-protected-form -->
                                </div> <!-- .et-protected -->
                            </div> <!-- end #et-login -->

                            <div class="clear"></div>

                            <?php edit_post_link(esc_html__('Edit this page','SimplePress')); ?>
                    <?php if (get_option('simplepress_integration_single_bottom') <> '' && get_option('simplepress_integrate_singlebottom_enable') == 'on') echo(get_option('simplepress_integration_single_bottom')); ?>
                    <?php if (get_option('simplepress_468_enable') == 'on') { ?>
                        <?php if(get_option('simplepress_468_adsense') <> '') echo(get_option('simplepress_468_adsense'));
                        else { ?>
                            <a href="<?php echo esc_url(get_option('simplepress_468_url')); ?>"><img src="<?php echo esc_url(get_option('simplepress_468_image')); ?>" alt="468 ad" class="foursixeight" /></a>
                        <?php } ?>
                    <?php } ?>
                    </div><!-- .post -->
                <?php endwhile; endif; ?>
                </div><!-- #posts -->
                <?php if (!$fullwidth) get_sidebar(); ?>
            </div><!-- .content_wrap -->
        </div><!-- .content_wrap -->
    </div><!-- #content -->
</div><!-- .wrapper -->
<?php get_footer(); ?>