<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Miniva
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'miniva_body_start' ); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'miniva' ); ?></a>

	<?php do_action( 'miniva_header_before' ); ?>

    <div class="wrap clearfix">
			        
                    <div id="navbar">
                            <div id="logo"><?php the_custom_logo(); ?></div>
                            <div id="navmenu"><?wp_nav_menu( array( 'theme_location' => 'menu-2', 'container_class' => 'top-menu' ) ); ?></div>
                    </div>
                
                </div>

	<header id="masthead" class="site-header" role="banner">

		<?php do_action( 'miniva_header_start' ); ?>

<div id="header">





		<?php do_action( 'miniva_header_middle' ); ?>

		

		<?php do_action( 'miniva_header_end' ); ?>

	</header><!-- #masthead -->
    <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_html_e( 'Primary', 'miniva' ); ?>">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Menu', 'miniva' ); ?></button>
			<?php
			wp_nav_menu( array(
				'theme_location' => 'menu-1',
				'menu_id'        => 'primary-menu',
				'menu_class'     => 'primary-menu',
				'container'      => 'ul',
			) );
			?>
		</nav><!-- #site-navigation -->
	<?php do_action( 'miniva_header_after' ); ?>

	<div id="content" class="site-content<?php miniva_content_class(); ?>">

		<?php do_action( 'miniva_content_start' ); ?>
