<?php

class N2SS3 {

    public static $version = '3.3.26';

    public static $revision = '5661';

    public static $completeVersion;

    public static $plan = 'pro';

    public static $product = 'smartslider3';

    public static $campaign = 'smartslider3';

    public static $source = '';

    public static $forceDesktop = false;

    public static function shouldSkipLicenseModal() {
        return true;
    
    }

    public static function applySource(&$params) {
        static $isSourceSet = false;
        if (!$isSourceSet) {
            if (defined('SMARTSLIDER3AFFILIATE')) {
                N2SS3::$source = SMARTSLIDER3AFFILIATE;
            }
            N2SS3::$source = apply_filters('smartslider3_hoplink', N2SS3::$source);
        

            $isSourceSet = true;
        }

        if (!empty(self::$source)) {
            $params['source'] = self::$source;
        }
    }

    public static function getProUrlHome($params = array()) {
        self::applySource($params);

        return 'https://smartslider3.com/?' . http_build_query($params);
    }

    public static function getProUrlPricing($params = array()) {
        self::applySource($params);

        return 'https://smartslider3.com/pricing/?' . http_build_query($params);
    }

    public static function getWhyProUrl($params = array()) {
        self::applySource($params);

        $params['utm_campaign'] = N2SS3::$campaign;
        $params['utm_medium']   = 'smartslider-' . N2Platform::getPlatform() . '-' . N2SS3::$plan;


        return 'https://smartslider3.com/pro-features/?' . http_build_query($params);
    }

    public static function getSampleSlidesUrl($params = array()) {
        self::applySource($params);
        return 'https://smartslider3.com/slides/' . self::$version . '/free/?' . http_build_query($params);
    
    }

    public static function getActivationUrl($params = array()) {
        self::applySource($params);

        return 'https://secure.nextendweb.com/activate/?' . http_build_query($params);
    }

    public static function getUpdateInfo() {
        return array(
            'name'   => 'smartslider3',
            'plugin' => 'nextend-smart-slider3-pro/nextend-smart-slider3-pro.php'
        );
    }

    public static function getDomain() {
        $domain = parse_url(N2Uri::getSiteUri(), PHP_URL_HOST);
        if (empty($domain)) {
            if (isset($_SERVER['HTTP_HOST'])) {

                $domain = $_SERVER['HTTP_HOST'];
            }
            if (empty($domain) && isset($_SERVER['SERVER_NAME'])) {

                $domain = $_SERVER['SERVER_NAME'];
            }
        }

        return $domain;
    }

    public static function api($_posts, $returnUrl = false) {
        $isPro = 0;
    
        $posts = array(
            'product' => self::$product,
            'pro'     => $isPro
        );

        return N2::api($_posts + $posts, $returnUrl);
    }

    public static function hasApiError($status, $data = array()) {
        extract($data);
        switch ($status) {
            case 'OK':
                return false;
            case 'PRODUCT_ASSET_NOT_AVAILABLE':
                N2Message::error(sprintf(n2_('Demo slider is not available with the following ID: %s'), $key));
                break;
            case 'ASSET_PREMIUM':
                N2Message::error('Premium sliders are available in PRO version only!');
                break;
            case 'ASSET_VERSION':
                N2Message::error('Please <a href="https://smartslider3.helpscoutdocs.com/article/414-update" target="_blank">update</a> your Smart Slider to the latest version to be able to import the selected sample slider!');
                break;
            case 'LICENSE_EXPIRED':
                N2Message::error('Your license has <a href="https://smartslider3.helpscoutdocs.com/article/1101-activation#nokey" target="_blank">expired</a>! Get new one: <a href="https://smartslider3.com/pricing" target="_blank">smartslider3.com</a>.');
                break;
            case 'DOMAIN_REGISTER_FAILED':
                N2Message::error('Smart Slider 3 PRO license is not registered on the current domain. Please activate this domain by following <a href="https://smartslider3.helpscoutdocs.com/article/1101-activation" target="_blank">the license activation documentation</a>.');
                break;
            case 'LICENSE_INVALID':
                N2Message::error('Smart Slider 3 PRO license is not registered on the current domain. Please activate this domain by following <a href="https://smartslider3.helpscoutdocs.com/article/1101-activation" target="_blank">the license activation documentation</a>.');
                N2SmartsliderLicenseModel::getInstance()
                                         ->setKey('');

                return array(
                    "sliders/index"
                );
                break;
            case 'UPDATE_ERROR':
                N2Message::error('Update error, please update manually!');
                break;
            case 'PLATFORM_NOT_ALLOWED':
                N2Message::error(sprintf('Your license is not valid for Smart Slider3 - %s!', N2Platform::getPlatformName()));
                break;
            case 'ERROR_HANDLED':
                break;
            case '503':
                N2Message::error('Licensing server is down. Try: Global Settings -> Framework settings -> Secondary server -> On');
                break;
            case null:
                N2Message::error('Licensing server not reachable. Try: Global Settings -> Framework settings -> Secondary server -> On');
                break;
            default:
                N2Message::error('Debug: ' . $status);
                N2Message::error('Licensing server not reachable. Try: Global Settings -> Framework settings -> Secondary server -> On');
                break;
        }

        return true;
    }

    public static function initLicense() {
    }

    public static function sliderChanged() {
        do_action('smartslider3_slider_changed');
    
    }
}

N2SS3::$completeVersion = N2SS3::$version . 'r' . N2SS3::$revision;
N2SS3::$plan = 'free';