<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Miniva
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="<?php bloginfo('description'); ?>" />
	<meta name="keywords" content="technology, internet, website, programming, security, industry leader, development, content management systems, cms, api, network security, cloud, san antonio, tech tip tuesday" />
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/favicon.ico" />
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css" integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-NRG6NGR');</script>

<?php do_action( 'miniva_body_start' ); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'miniva' ); ?></a>

	<?php do_action( 'miniva_header_before' ); ?>

    <div class="wrap clearfix">
			        
                    <div id="navbar">
							<div id="logo"><?php the_custom_logo(); ?></div>
                            <div id="navmenu" aria-label="secondary">
							<div class="social-media">
								<ul>
									<li><a href="https://www.facebook.com/webheadtech" target="_blank"><img src="/wp-content/themes/miniva/images/fb.png" alt="Webhead Facebook (Opens New Window)"></a></li>
									<li><a href="https://www.instagram.com/webheadtech/" target="_blank"><img src="/wp-content/themes/miniva/images/instagram.png" alt="Webhead Instagram (Opens New Window)"></a></li>
									<li><a href="https://twitter.com/webheadsa" target="_blank"><img src="/wp-content/themes/miniva/images/twitter.png" alt="Webhead Twitter (Opens New Window)"></a></li>
									<li><a href="https://www.linkedin.com/company/webhead" target="_blank"><img src="/wp-content/themes/miniva/images/linkedin.png" alt="Webhead LinkedIN (Opens New Window)"></a></li>
									<li><a href="https://medium.com/@webheadgroup" target="_blank"><img src="/wp-content/themes/miniva/images/medium.png" alt="Webhead Medium (Opens New Window)"></a></li>
									<li><a href="https://www.snapchat.com/add/webheadtech" target="_blank"><img src="/wp-content/themes/miniva/images/snapchat.png" alt="Webhead Snapchat (Opens New Window)"></a></li>
								</ul>
							</div>
							<div class="business-phone">(210) 354-1661</div>
								<div class="top-menu" aria-label="Primary site navigation"><?wp_nav_menu( array( 'theme_location' => 'menu-2', 'container_class' => 'top-menu' ) ); ?></div>
							</div>
                    </div>
                
                </div>

	<header role="banner">

		

<div>


		<?php if(is_front_page() == true){echo do_shortcode('[metaslider id="2092"]');} ?>




		<?php do_action( 'miniva_header_middle' ); ?>
		<?php do_action( 'miniva_header_end' ); ?>




	</header><!-- #masthead -->
    
	<?php do_action( 'miniva_header_after' ); ?>

	<div id="content" class="site-content<?php miniva_content_class(); ?>">

		<?php do_action( 'miniva_content_start' ); ?>
