<?php
/**
 * Do not edit this file. It's generated by `jetpack/tools/build-module-headings-translations.php`.
 *
 * @package automattic/jetpack
 */

/**
 * For a given module, return an array with translated name and description.
 *
 * @param string $key Module file name without `.php`.
 *
 * @return array
 */
function jetpack_get_module_i18n( $key ) {
	static $modules;
	if ( ! isset( $modules ) ) {
		$modules = array(
			'account-protection' => array(
				'name' => _x( 'Account protection', 'Module Name', 'jetpack' ),
				'description' => _x( 'Shield your login page with rate‑limiting and secure authentication safeguards.', 'Module Description', 'jetpack' ),
			),

			'blaze' => array(
				'name' => _x( 'Blaze', 'Module Name', 'jetpack' ),
				'description' => _x( 'Promote your posts and pages across millions of sites in the WordPress.com and Tumblr ad network.', 'Module Description', 'jetpack' ),
			),

			'blocks' => array(
				'name' => _x( 'Blocks', 'Module Name', 'jetpack' ),
				'description' => _x( 'Expand your editor with custom Jetpack blocks for rich content and layout options.', 'Module Description', 'jetpack' ),
			),

			'carousel' => array(
				'name' => _x( 'Carousel', 'Module Name', 'jetpack' ),
				'description' => _x( 'Turn your image galleries into immersive, full‑screen slideshows.', 'Module Description', 'jetpack' ),
			),

			'comment-likes' => array(
				'name' => _x( 'Comment Likes', 'Module Name', 'jetpack' ),
				'description' => _x( 'Enable visitors to like individual comments and boost engagement.', 'Module Description', 'jetpack' ),
			),

			'comments' => array(
				'name' => _x( 'Comments', 'Module Name', 'jetpack' ),
				'description' => _x( 'Replace the default comment form with a modern, feature‑rich alternative.', 'Module Description', 'jetpack' ),
			),

			'contact-form' => array(
				'name' => _x( 'Forms', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add contact, registration, and feedback forms directly from the block editor.', 'Module Description', 'jetpack' ),
			),

			'copy-post' => array(
				'name' => _x( 'Copy Post', 'Module Name', 'jetpack' ),
				'description' => _x( 'Duplicate any post or page in one click to speed up content creation.', 'Module Description', 'jetpack' ),
			),

			'custom-content-types' => array(
				'name' => _x( 'Custom content types', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display different types of content on your site with custom content types.', 'Module Description', 'jetpack' ),
			),

			'google-fonts' => array(
				'name' => _x( 'Google Fonts (Beta)', 'Module Name', 'jetpack' ),
				'description' => _x( 'Customize your site\'s typography with a selection of Google Fonts.', 'Module Description', 'jetpack' ),
			),

			'gravatar-hovercards' => array(
				'name' => _x( 'Gravatar Hovercards', 'Module Name', 'jetpack' ),
				'description' => _x( 'Show a user’s Gravatar profile when visitors hover over their name or image.', 'Module Description', 'jetpack' ),
			),

			'infinite-scroll' => array(
				'name' => _x( 'Infinite Scroll', 'Module Name', 'jetpack' ),
				'description' => _x( 'Automatically load new posts as visitors scroll down your site.', 'Module Description', 'jetpack' ),
			),

			'json-api' => array(
				'name' => _x( 'JSON API', 'Module Name', 'jetpack' ),
				'description' => _x( 'Access your site’s data remotely through the WordPress.com REST API.', 'Module Description', 'jetpack' ),
			),

			'latex' => array(
				'name' => _x( 'Beautiful Math', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add beautifully formatted math equations to your posts and pages using LaTeX.', 'Module Description', 'jetpack' ),
			),

			'likes' => array(
				'name' => _x( 'Likes', 'Module Name', 'jetpack' ),
				'description' => _x( 'Let readers like your posts to show appreciation and encourage interaction.', 'Module Description', 'jetpack' ),
			),

			'markdown' => array(
				'name' => _x( 'Markdown', 'Module Name', 'jetpack' ),
				'description' => _x( 'Write and format posts using clean, readable Markdown syntax.', 'Module Description', 'jetpack' ),
			),

			'monitor' => array(
				'name' => _x( 'Downtime Monitor', 'Module Name', 'jetpack' ),
				'description' => _x( 'Get instant alerts if your site goes down and know when it’s back online.', 'Module Description', 'jetpack' ),
			),

			'notes' => array(
				'name' => _x( 'Notifications', 'Module Name', 'jetpack' ),
				'description' => _x( 'Receive real‑time notifications about site activity across your devices.', 'Module Description', 'jetpack' ),
			),

			'photon-cdn' => array(
				'name' => _x( 'Asset CDN', 'Module Name', 'jetpack' ),
				'description' => _x( 'Serve static files like CSS and JS from Jetpack’s global CDN for faster load times.', 'Module Description', 'jetpack' ),
			),

			'photon' => array(
				'name' => _x( 'Image CDN', 'Module Name', 'jetpack' ),
				'description' => _x( 'Deliver images quickly with automatic resizing from Jetpack’s global image CDN.', 'Module Description', 'jetpack' ),
			),

			'post-by-email' => array(
				'name' => _x( 'Post by email', 'Module Name', 'jetpack' ),
				'description' => _x( 'Publish blog posts simply by sending an email to a custom address.', 'Module Description', 'jetpack' ),
			),

			'post-list' => array(
				'name' => _x( 'Post List', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display a customizable list of your latest posts anywhere on your site.', 'Module Description', 'jetpack' ),
			),

			'protect' => array(
				'name' => _x( 'Brute force protection', 'Module Name', 'jetpack' ),
				'description' => _x( 'Block malicious login attempts automatically and keep hackers out.', 'Module Description', 'jetpack' ),
			),

			'publicize' => array(
				'name' => _x( 'Jetpack Social', 'Module Name', 'jetpack' ),
				'description' => _x( 'Auto‑share your posts to social networks and track engagement in one place.', 'Module Description', 'jetpack' ),
			),

			'related-posts' => array(
				'name' => _x( 'Related posts', 'Module Name', 'jetpack' ),
				'description' => _x( 'Automatically display related articles to keep visitors reading longer.', 'Module Description', 'jetpack' ),
			),

			'search' => array(
				'name' => _x( 'Search', 'Module Name', 'jetpack' ),
				'description' => _x( 'Instantly deliver the most relevant results to your visitors.', 'Module Description', 'jetpack' ),
			),

			'seo-tools' => array(
				'name' => _x( 'SEO Tools', 'Module Name', 'jetpack' ),
				'description' => _x( 'Optimize titles, meta descriptions, and social previews for better search results.', 'Module Description', 'jetpack' ),
			),

			'sharedaddy' => array(
				'name' => _x( 'Sharing', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add customizable share buttons so visitors can spread your content.', 'Module Description', 'jetpack' ),
			),

			'shortcodes' => array(
				'name' => _x( 'Shortcode Embeds', 'Module Name', 'jetpack' ),
				'description' => _x( 'Easily embed rich media like YouTube videos and tweets using simple shortcodes.', 'Module Description', 'jetpack' ),
			),

			'shortlinks' => array(
				'name' => _x( 'WP.me Shortlinks', 'Module Name', 'jetpack' ),
				'description' => _x( 'Share short, easy-to-remember links to your posts and pages.', 'Module Description', 'jetpack' ),
			),

			'sitemaps' => array(
				'name' => _x( 'Sitemaps', 'Module Name', 'jetpack' ),
				'description' => _x( 'Generate XML sitemaps so search engines can index your site efficiently.', 'Module Description', 'jetpack' ),
			),

			'sso' => array(
				'name' => _x( 'Secure Sign On', 'Module Name', 'jetpack' ),
				'description' => _x( 'Let users log in with their WordPress.com account for quick, secure access.', 'Module Description', 'jetpack' ),
			),

			'stats' => array(
				'name' => _x( 'Jetpack Stats', 'Module Name', 'jetpack' ),
				'description' => _x( 'Clear, concise traffic insights right in your WordPress dashboard.', 'Module Description', 'jetpack' ),
			),

			'subscriptions' => array(
				'name' => _x( 'Newsletter', 'Module Name', 'jetpack' ),
				'description' => _x( 'Grow your subscriber list and deliver your content directly to their email inbox.', 'Module Description', 'jetpack' ),
			),

			'tiled-gallery' => array(
				'name' => _x( 'Tiled Galleries', 'Module Name', 'jetpack' ),
				'description' => _x( 'Create visually engaging tiled image galleries with multiple layout options.', 'Module Description', 'jetpack' ),
			),

			'vaultpress' => array(
				'name' => _x( 'VaultPress Backup', 'Module Name', 'jetpack' ),
				'description' => _x( 'Real-time backups save every change, and one-click restores get you back online quickly.', 'Module Description', 'jetpack' ),
			),

			'verification-tools' => array(
				'name' => _x( 'Site verification', 'Module Name', 'jetpack' ),
				'description' => _x( 'Verify your site with search engines and social platforms in a couple of clicks.', 'Module Description', 'jetpack' ),
			),

			'videopress' => array(
				'name' => _x( 'VideoPress', 'Module Name', 'jetpack' ),
				'description' => _x( 'Powerful and flexible video hosting.', 'Module Description', 'jetpack' ),
			),

			'waf' => array(
				'name' => _x( 'Firewall', 'Module Name', 'jetpack' ),
				'description' => _x( 'Filter malicious traffic in real time with Jetpack’s site firewall.', 'Module Description', 'jetpack' ),
			),

			'widget-visibility' => array(
				'name' => _x( 'Widget Visibility', 'Module Name', 'jetpack' ),
				'description' => _x( 'Choose which widgets appear on specific pages or posts with advanced controls.', 'Module Description', 'jetpack' ),
			),

			'widgets' => array(
				'name' => _x( 'Extra Sidebar Widgets', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add more widget options to your site, like social feeds, subscriptions, and more.', 'Module Description', 'jetpack' ),
			),

			'woocommerce-analytics' => array(
				'name' => _x( 'WooCommerce Analytics', 'Module Name', 'jetpack' ),
				'description' => _x( 'Get actionable insights on your store’s orders, revenue, and customers.', 'Module Description', 'jetpack' ),
			),

			'wordads' => array(
				'name' => _x( 'Ads', 'Module Name', 'jetpack' ),
				'description' => _x( 'Earn revenue by displaying high‑quality ads on your site.', 'Module Description', 'jetpack' ),
			),
		);
	}
	return isset( $modules[ $key ] ) ? $modules[ $key ] : null;
}

/**
 * For a given module tag, return its translated version.
 *
 * @param string $key Module tag as is in each module heading.
 *
 * @return string
 */
function jetpack_get_module_i18n_tag( $key ) {
	static $module_tags;
	if ( ! isset( $module_tags ) ) {
		$module_tags = array(
			// Modules with `Other` tag:
			// - modules/contact-form.php
			// - modules/notes.php
			// - modules/woocommerce-analytics.php
			'Other' => _x( 'Other', 'Module Tag', 'jetpack' ),

			// Modules with `Account Protection` tag:
			// - modules/account-protection.php
			'Account Protection' => _x( 'Account Protection', 'Module Tag', 'jetpack' ),

			// Modules with `Traffic` tag:
			// - modules/blaze.php
			// - modules/sitemaps.php
			// - modules/wordads.php
			'Traffic' => _x( 'Traffic', 'Module Tag', 'jetpack' ),

			// Modules with `Social` tag:
			// - modules/blaze.php
			// - modules/comment-likes.php
			// - modules/comments.php
			// - modules/gravatar-hovercards.php
			// - modules/likes.php
			// - modules/publicize.php
			// - modules/seo-tools.php
			// - modules/sharedaddy.php
			// - modules/shortcodes.php
			// - modules/shortlinks.php
			// - modules/subscriptions.php
			// - modules/widgets.php
			'Social' => _x( 'Social', 'Module Tag', 'jetpack' ),

			// Modules with `blocks` tag:
			// - modules/blocks.php
			'blocks' => _x( 'blocks', 'Module Tag', 'jetpack' ),

			// Modules with `Photos and Videos` tag:
			// - modules/carousel.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/shortcodes.php
			// - modules/tiled-gallery.php
			// - modules/videopress.php
			'Photos and Videos' => _x( 'Photos and Videos', 'Module Tag', 'jetpack' ),

			// Modules with `Writing` tag:
			// - modules/copy-post.php
			// - modules/custom-content-types.php
			// - modules/json-api.php
			// - modules/latex.php
			// - modules/markdown.php
			// - modules/post-by-email.php
			// - modules/shortcodes.php
			'Writing' => _x( 'Writing', 'Module Tag', 'jetpack' ),

			// Modules with `Fonts` tag:
			// - modules/google-fonts.php
			'Fonts' => _x( 'Fonts', 'Module Tag', 'jetpack' ),

			// Modules with `Recommended` tag:
			// - modules/google-fonts.php
			// - modules/monitor.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/protect.php
			// - modules/publicize.php
			// - modules/related-posts.php
			// - modules/sharedaddy.php
			// - modules/sitemaps.php
			// - modules/stats.php
			// - modules/woocommerce-analytics.php
			'Recommended' => _x( 'Recommended', 'Module Tag', 'jetpack' ),

			// Modules with `Appearance` tag:
			// - modules/gravatar-hovercards.php
			// - modules/infinite-scroll.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/seo-tools.php
			// - modules/shortcodes.php
			// - modules/widget-visibility.php
			// - modules/widgets.php
			// - modules/wordads.php
			'Appearance' => _x( 'Appearance', 'Module Tag', 'jetpack' ),

			// Modules with `Developers` tag:
			// - modules/json-api.php
			// - modules/sso.php
			'Developers' => _x( 'Developers', 'Module Tag', 'jetpack' ),

			// Modules with `Admin` tag:
			// - modules/post-list.php
			'Admin' => _x( 'Admin', 'Module Tag', 'jetpack' ),

			// Modules with `Jetpack Stats` tag:
			// - modules/stats.php
			'Jetpack Stats' => _x( 'Jetpack Stats', 'Module Tag', 'jetpack' ),

			// Modules with `Site Stats` tag:
			// - modules/stats.php
			'Site Stats' => _x( 'Site Stats', 'Module Tag', 'jetpack' ),

			// Modules with `Firewall` tag:
			// - modules/waf.php
			'Firewall' => _x( 'Firewall', 'Module Tag', 'jetpack' ),

			// Modules with `WAF` tag:
			// - modules/waf.php
			'WAF' => _x( 'WAF', 'Module Tag', 'jetpack' ),
		);
	}
	return ! empty( $module_tags[ $key ] ) ? $module_tags[ $key ] : '';
}

/**
 * For a given module, return an array with the module info.
 *
 * @param string $key Module file name without `.php`.
 *
 * return array|string An array containing the module info or an empty string if the given module isn't known.
 */
function jetpack_get_module_info( $key ) {
	static $module_info = array (
	  'account-protection' => 
	  array (
	    'name' => 'Account protection',
	    'description' => 'Shield your login page with rate‑limiting and secure authentication safeguards.',
	    'sort' => '4',
	    'recommendation_order' => '',
	    'introduced' => '14.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'No',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Account Protection',
	    'feature' => 'Security',
	    'additional_search_queries' => '',
	    'plan_classes' => '',
	  ),
	  'blaze' => 
	  array (
	    'name' => 'Blaze',
	    'description' => 'Promote your posts and pages across millions of sites in the WordPress.com and Tumblr ad network.',
	    'sort' => '22',
	    'recommendation_order' => '12',
	    'introduced' => '12.3',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Traffic, Social',
	    'feature' => '',
	    'additional_search_queries' => 'advertising, ads',
	    'plan_classes' => '',
	  ),
	  'blocks' => 
	  array (
	    'name' => 'Blocks',
	    'description' => 'Expand your editor with custom Jetpack blocks for rich content and layout options.',
	    'sort' => '5',
	    'recommendation_order' => '',
	    'introduced' => '13.9-a.8',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'blocks',
	    'feature' => 'Writing',
	    'additional_search_queries' => '',
	    'plan_classes' => '',
	  ),
	  'carousel' => 
	  array (
	    'name' => 'Carousel',
	    'description' => 'Turn your image galleries into immersive, full‑screen slideshows.',
	    'sort' => '22',
	    'recommendation_order' => '12',
	    'introduced' => '1.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image, creator',
	    'plan_classes' => '',
	  ),
	  'comment-likes' => 
	  array (
	    'name' => 'Comment Likes',
	    'description' => 'Enable visitors to like individual comments and boost engagement.',
	    'sort' => '39',
	    'recommendation_order' => '17',
	    'introduced' => '5.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => '',
	    'additional_search_queries' => 'like widget, like button, like, likes',
	    'plan_classes' => '',
	  ),
	  'comments' => 
	  array (
	    'name' => 'Comments',
	    'description' => 'Replace the default comment form with a modern, feature‑rich alternative.',
	    'sort' => '20',
	    'recommendation_order' => '',
	    'introduced' => '1.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'comments, comment, facebook, social',
	    'plan_classes' => '',
	  ),
	  'contact-form' => 
	  array (
	    'name' => 'Forms',
	    'description' => 'Add contact, registration, and feedback forms directly from the block editor.',
	    'sort' => '15',
	    'recommendation_order' => '14',
	    'introduced' => '1.3',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'contact, form, grunion, feedback, submission, contact form, email, feedback, contact form plugin, custom form, custom form plugin, form builder, forms, form maker, survey, contact by jetpack, contact us, forms free, creator',
	    'plan_classes' => '',
	  ),
	  'copy-post' => 
	  array (
	    'name' => 'Copy Post',
	    'description' => 'Duplicate any post or page in one click to speed up content creation.',
	    'sort' => '15',
	    'recommendation_order' => '',
	    'introduced' => '7.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'copy, duplicate',
	    'plan_classes' => '',
	  ),
	  'custom-content-types' => 
	  array (
	    'name' => 'Custom content types',
	    'description' => 'Display different types of content on your site with custom content types.',
	    'sort' => '34',
	    'recommendation_order' => '',
	    'introduced' => '3.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'cpt, custom post types, portfolio, portfolios, testimonial, testimonials',
	    'plan_classes' => '',
	  ),
	  'google-fonts' => 
	  array (
	    'name' => 'Google Fonts (Beta)',
	    'description' => 'Customize your site\'s typography with a selection of Google Fonts.',
	    'sort' => '1',
	    'recommendation_order' => '2',
	    'introduced' => '10.8.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Fonts, Recommended',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'fonts, webfonts, typography, creator',
	    'plan_classes' => '',
	  ),
	  'gravatar-hovercards' => 
	  array (
	    'name' => 'Gravatar Hovercards',
	    'description' => 'Show a user’s Gravatar profile when visitors hover over their name or image.',
	    'sort' => '11',
	    'recommendation_order' => '13',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gravatar, hovercards',
	    'plan_classes' => '',
	  ),
	  'infinite-scroll' => 
	  array (
	    'name' => 'Infinite Scroll',
	    'description' => 'Automatically load new posts as visitors scroll down your site.',
	    'sort' => '26',
	    'recommendation_order' => '',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'scroll, infinite, infinite scroll',
	    'plan_classes' => '',
	  ),
	  'json-api' => 
	  array (
	    'name' => 'JSON API',
	    'description' => 'Access your site’s data remotely through the WordPress.com REST API.',
	    'sort' => '19',
	    'recommendation_order' => '',
	    'introduced' => '1.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Public',
	    'module_tags' => 'Writing, Developers',
	    'feature' => 'General',
	    'additional_search_queries' => 'api, rest, develop, developers, json, klout, oauth',
	    'plan_classes' => '',
	  ),
	  'latex' => 
	  array (
	    'name' => 'Beautiful Math',
	    'description' => 'Add beautifully formatted math equations to your posts and pages using LaTeX.',
	    'sort' => '12',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'latex, math, equation, equations, formula, code',
	    'plan_classes' => '',
	  ),
	  'likes' => 
	  array (
	    'name' => 'Likes',
	    'description' => 'Let readers like your posts to show appreciation and encourage interaction.',
	    'sort' => '23',
	    'recommendation_order' => '',
	    'introduced' => '2.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'like, likes, wordpress.com',
	    'plan_classes' => '',
	  ),
	  'markdown' => 
	  array (
	    'name' => 'Markdown',
	    'description' => 'Write and format posts using clean, readable Markdown syntax.',
	    'sort' => '31',
	    'recommendation_order' => '',
	    'introduced' => '2.8',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'md, markdown',
	    'plan_classes' => '',
	  ),
	  'monitor' => 
	  array (
	    'name' => 'Downtime Monitor',
	    'description' => 'Get instant alerts if your site goes down and know when it’s back online.',
	    'sort' => '28',
	    'recommendation_order' => '10',
	    'introduced' => '2.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended',
	    'feature' => 'Security',
	    'additional_search_queries' => 'monitor, uptime, downtime, monitoring, maintenance, maintenance mode, offline, site is down, site down, down, repair, error',
	    'plan_classes' => '',
	  ),
	  'notes' => 
	  array (
	    'name' => 'Notifications',
	    'description' => 'Receive real‑time notifications about site activity across your devices.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '1.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other',
	    'feature' => 'General',
	    'additional_search_queries' => 'notification, notifications, toolbar, adminbar, push, comments',
	    'plan_classes' => '',
	  ),
	  'photon-cdn' => 
	  array (
	    'name' => 'Asset CDN',
	    'description' => 'Serve static files like CSS and JS from Jetpack’s global CDN for faster load times.',
	    'sort' => '26',
	    'recommendation_order' => '1',
	    'introduced' => '6.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Appearance, Recommended',
	    'feature' => 'Recommended, Appearance',
	    'additional_search_queries' => 'site accelerator, accelerate, static, assets, javascript, css, files, performance, cdn, bandwidth, content delivery network, pagespeed, combine js, optimize css',
	    'plan_classes' => '',
	  ),
	  'photon' => 
	  array (
	    'name' => 'Image CDN',
	    'description' => 'Deliver images quickly with automatic resizing from Jetpack’s global image CDN.',
	    'sort' => '25',
	    'recommendation_order' => '1',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Appearance, Recommended',
	    'feature' => 'Recommended, Appearance',
	    'additional_search_queries' => 'photon, photo cdn, image cdn, speed, compression, resize, responsive images, responsive, content distribution network, optimize, page speed, image optimize, photon jetpack',
	    'plan_classes' => '',
	  ),
	  'post-by-email' => 
	  array (
	    'name' => 'Post by email',
	    'description' => 'Publish blog posts simply by sending an email to a custom address.',
	    'sort' => '14',
	    'recommendation_order' => '',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'post by email, email',
	    'plan_classes' => '',
	  ),
	  'post-list' => 
	  array (
	    'name' => 'Post List',
	    'description' => 'Display a customizable list of your latest posts anywhere on your site.',
	    'sort' => '31',
	    'recommendation_order' => '12',
	    'introduced' => '11.3',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Admin',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'post, admin, list',
	    'plan_classes' => '',
	  ),
	  'protect' => 
	  array (
	    'name' => 'Brute force protection',
	    'description' => 'Block malicious login attempts automatically and keep hackers out.',
	    'sort' => '1',
	    'recommendation_order' => '4',
	    'introduced' => '3.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'No',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Recommended',
	    'feature' => 'Security',
	    'additional_search_queries' => 'security, jetpack protect, secure, protection, botnet, brute force, protect, login, bot, password, passwords, strong passwords, strong password, wp-login.php,  protect admin',
	    'plan_classes' => '',
	  ),
	  'publicize' => 
	  array (
	    'name' => 'Jetpack Social',
	    'description' => 'Auto‑share your posts to social networks and track engagement in one place.',
	    'sort' => '10',
	    'recommendation_order' => '7',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'facebook, bluesky, threads, mastodon, instagram, jetpack publicize, tumblr, linkedin, social, tweet, connections, sharing, social media, automated, automated sharing, auto publish, auto tweet and like, auto tweet, facebook auto post, facebook posting',
	    'plan_classes' => '',
	  ),
	  'related-posts' => 
	  array (
	    'name' => 'Related posts',
	    'description' => 'Automatically display related articles to keep visitors reading longer.',
	    'sort' => '29',
	    'recommendation_order' => '9',
	    'introduced' => '2.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'related, jetpack related posts, related posts for wordpress, related posts, popular posts, popular, related content, related post, contextual, context, contextual related posts, related articles, similar posts, easy related posts, related page, simple related posts, free related posts, related thumbnails, similar, engagement, yet another related posts plugin, creator',
	    'plan_classes' => '',
	  ),
	  'search' => 
	  array (
	    'name' => 'Search',
	    'description' => 'Instantly deliver the most relevant results to your visitors.',
	    'sort' => '34',
	    'recommendation_order' => '',
	    'introduced' => '5.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => 'false',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => '',
	    'feature' => 'Search',
	    'additional_search_queries' => 'search, elastic, elastic search, elasticsearch, fast search, search results, search performance, google search',
	    'plan_classes' => 'business, complete',
	  ),
	  'seo-tools' => 
	  array (
	    'name' => 'SEO Tools',
	    'description' => 'Optimize titles, meta descriptions, and social previews for better search results.',
	    'sort' => '35',
	    'recommendation_order' => '15',
	    'introduced' => '4.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => 'No',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Traffic',
	    'additional_search_queries' => 'search engine optimization, social preview, meta description, custom title format',
	    'plan_classes' => '',
	  ),
	  'sharedaddy' => 
	  array (
	    'name' => 'Sharing',
	    'description' => 'Add customizable share buttons so visitors can spread your content.',
	    'sort' => '7',
	    'recommendation_order' => '6',
	    'introduced' => '1.1',
	    'changed' => '1.2',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'share, sharing, sharedaddy, social buttons, buttons, share facebook, share twitter, social media sharing, social media share, social share, icons, email, facebook, twitter, linkedin, pinterest, pocket, social widget, social media',
	    'plan_classes' => '',
	  ),
	  'shortcodes' => 
	  array (
	    'name' => 'Shortcode Embeds',
	    'description' => 'Easily embed rich media like YouTube videos and tweets using simple shortcodes.',
	    'sort' => '3',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '1.2',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Social, Writing, Appearance',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube',
	    'plan_classes' => '',
	  ),
	  'shortlinks' => 
	  array (
	    'name' => 'WP.me Shortlinks',
	    'description' => 'Share short, easy-to-remember links to your posts and pages.',
	    'sort' => '8',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'shortlinks, wp.me',
	    'plan_classes' => '',
	  ),
	  'sitemaps' => 
	  array (
	    'name' => 'Sitemaps',
	    'description' => 'Generate XML sitemaps so search engines can index your site efficiently.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '3.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended, Traffic',
	    'feature' => 'Recommended',
	    'additional_search_queries' => 'sitemap, traffic, search, site map, seo',
	    'plan_classes' => '',
	  ),
	  'sso' => 
	  array (
	    'name' => 'Secure Sign On',
	    'description' => 'Let users log in with their WordPress.com account for quick, secure access.',
	    'sort' => '30',
	    'recommendation_order' => '5',
	    'introduced' => '2.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Developers',
	    'feature' => 'Security',
	    'additional_search_queries' => 'sso, single sign on, login, log in, 2fa, two-factor',
	    'plan_classes' => '',
	  ),
	  'stats' => 
	  array (
	    'name' => 'Jetpack Stats',
	    'description' => 'Clear, concise traffic insights right in your WordPress dashboard.',
	    'sort' => '1',
	    'recommendation_order' => '2',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Jetpack Stats, Site Stats, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'statistics, tracking, analytics, views, traffic, stats',
	    'plan_classes' => '',
	  ),
	  'subscriptions' => 
	  array (
	    'name' => 'Newsletter',
	    'description' => 'Grow your subscriber list and deliver your content directly to their email inbox.',
	    'sort' => '9',
	    'recommendation_order' => '8',
	    'introduced' => '1.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'subscriptions, subscription, email, follow, followers, subscribers, signup, newsletter, creator',
	    'plan_classes' => '',
	  ),
	  'tiled-gallery' => 
	  array (
	    'name' => 'Tiled Galleries',
	    'description' => 'Create visually engaging tiled image galleries with multiple layout options.',
	    'sort' => '24',
	    'recommendation_order' => '',
	    'introduced' => '2.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gallery, tiles, tiled, grid, mosaic, images',
	    'plan_classes' => '',
	  ),
	  'vaultpress' => 
	  array (
	    'name' => 'VaultPress Backup',
	    'description' => 'Real-time backups save every change, and one-click restores get you back online quickly.',
	    'sort' => '32',
	    'recommendation_order' => '',
	    'introduced' => '0:1.2',
	    'changed' => '',
	    'deactivate' => 'false',
	    'free' => 'false',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => '',
	    'feature' => 'Security, Health',
	    'additional_search_queries' => 'backup, cloud backup, database backup, restore, wordpress backup, backup plugin, wordpress backup plugin, back up, backup wordpress, backwpup, vaultpress, backups, off-site backups, offsite backup, offsite, off-site, antivirus, malware scanner, security, virus, viruses, prevent viruses, scan, anti-virus, antimalware, protection, safe browsing, malware, wp security, wordpress security',
	    'plan_classes' => 'personal, business, premium, security, complete',
	  ),
	  'verification-tools' => 
	  array (
	    'name' => 'Site verification',
	    'description' => 'Verify your site with search engines and social platforms in a couple of clicks.',
	    'sort' => '33',
	    'recommendation_order' => '',
	    'introduced' => '3.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => '',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'webmaster, seo, google, bing, pinterest, search, console',
	    'plan_classes' => '',
	  ),
	  'videopress' => 
	  array (
	    'name' => 'VideoPress',
	    'description' => 'Powerful and flexible video hosting.',
	    'sort' => '27',
	    'recommendation_order' => '',
	    'introduced' => '2.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => '',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'video, videos, videopress, video gallery, video player, videoplayer, mobile video, vimeo, youtube, html5 video, stream',
	    'plan_classes' => '',
	  ),
	  'waf' => 
	  array (
	    'name' => 'Firewall',
	    'description' => 'Filter malicious traffic in real time with Jetpack’s site firewall.',
	    'sort' => '5',
	    'recommendation_order' => '',
	    'introduced' => '10.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Firewall, WAF',
	    'feature' => 'Security',
	    'additional_search_queries' => '',
	    'plan_classes' => '',
	  ),
	  'widget-visibility' => 
	  array (
	    'name' => 'Widget Visibility',
	    'description' => 'Choose which widgets appear on specific pages or posts with advanced controls.',
	    'sort' => '17',
	    'recommendation_order' => '',
	    'introduced' => '2.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'widget visibility, logic, conditional, widgets, widget',
	    'plan_classes' => '',
	  ),
	  'widgets' => 
	  array (
	    'name' => 'Extra Sidebar Widgets',
	    'description' => 'Add more widget options to your site, like social feeds, subscriptions, and more.',
	    'sort' => '4',
	    'recommendation_order' => '',
	    'introduced' => '1.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'widget, widgets, facebook, gallery, twitter, gravatar, image, rss',
	    'plan_classes' => '',
	  ),
	  'woocommerce-analytics' => 
	  array (
	    'name' => 'WooCommerce Analytics',
	    'description' => 'Get actionable insights on your store’s orders, revenue, and customers.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '8.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'woocommerce, analytics, stats, statistics, tracking, analytics, views',
	    'plan_classes' => '',
	  ),
	  'wordads' => 
	  array (
	    'name' => 'Ads',
	    'description' => 'Earn revenue by displaying high‑quality ads on your site.',
	    'sort' => '1',
	    'recommendation_order' => '',
	    'introduced' => '4.5.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Traffic, Appearance',
	    'feature' => '',
	    'additional_search_queries' => 'advertising, ad codes, ads, creator',
	    'plan_classes' => 'premium, business, security, complete',
	  ),
	);
	return isset( $module_info[ $key ] ) ? $module_info[ $key ] : null;
}

/**
 * Return an array containing all module header names.
 *
 * @return array
 */
function jetpack_get_all_module_header_names() {
	return array (
	  'name' => 'Module Name',
	  'description' => 'Module Description',
	  'sort' => 'Sort Order',
	  'recommendation_order' => 'Recommendation Order',
	  'introduced' => 'First Introduced',
	  'changed' => 'Major Changes In',
	  'deactivate' => 'Deactivate',
	  'free' => 'Free',
	  'requires_connection' => 'Requires Connection',
	  'requires_user_connection' => 'Requires User Connection',
	  'auto_activate' => 'Auto Activate',
	  'module_tags' => 'Module Tags',
	  'feature' => 'Feature',
	  'additional_search_queries' => 'Additional Search Queries',
	  'plan_classes' => 'Plans',
	);
}

/**
 * Returns whether the file associated with the given slug has no module info.
 *
 * @param string $slug The slug name.
 *
 * @return bool Whether the file has no module info.
 */
function jetpack_has_no_module_info( $slug ) {
	$no_info_slugs = array (
	  0 => 'module-extras',
	  1 => 'module-info',
	  2 => 'plugin-search',
	  3 => 'theme-tools',
	);

	return in_array( $slug, $no_info_slugs, true );
}
