<?php

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;


defined('ABSPATH') || die();

class RS_Exten_Sec_Column_Sticky_Setting
{

	public function __construct()
	{
		
		add_action('elementor/element/container/section_layout/after_section_end', [$this, 'rs_section_column_sticky'], 2);
		add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'rs_section_column_sticky'], 2);
		
		add_action('elementor/frontend/before_render', [$this, 'rs_column_sticky_before_section_render'], 2);
		
	}

	public function rs_section_column_sticky(Element_Base $section)
	{
		$tabs_field = Controls_Manager::TAB_CONTENT;

		if ('section' === $section->get_name()  || 'container' === $section->get_name()) {
			$tabs_field = Controls_Manager::TAB_LAYOUT;
		}

		$section->start_controls_section(
			'_section_column_sticky_setting',
			[
				'label' => __('RS Column Sticky', 'rsaddon'),
				'tab'   => $tabs_field,
			]
		);
		$section->add_control(
            'section_column_sticky_panal_notice',
            [
                'type'            => Controls_Manager::RAW_HTML,
                'raw'             => __('<strong>Column Sticky</strong> Does not work in Editor page.', 'rsaddon'),
                'content_classes' => 'rs-panel-notice',
            ]
        );
		$section->add_control(
			'section_column_sticky',
			[
				'label'     => __('Choose', 'rsaddon'),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'' => __('Default', 'rsaddon'),
					'contents-sticky' 	=> __('Theia Column Sticky', 'rsaddon')
				],
				'default'   => '',
			]
		);

		$section->end_controls_section();
	}

	public function rs_column_sticky_before_section_render(Element_Base $section)
	{
		$section_column_sticky = $section->get_settings_for_display('section_column_sticky');

		if (
			($section_column_sticky && !empty($section_column_sticky))
		) {
			$section->add_render_attribute(
				'_wrapper',
				[
					'class' => [$section_column_sticky],
				]
			);
		}
	}

}

new RS_Exten_Sec_Column_Sticky_Setting();
?>