<?php



use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;


defined('ABSPATH') || die();

class RS_Exten_Custom_CSS_Setting
{

	public function __construct()
    {
        add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/column/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/common/_section_style/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/container/section_layout/after_section_end', [$this, 'register_controls'], 3);

        add_action('elementor/frontend/before_render', [$this, 'render_custom_css'], 10, 1);

    }


    public function register_controls(Element_Base $section)
    {
        $section->start_controls_section(
            'rs_exten_custom_css_section',
            [
                'label' => 'RS Custom CSS',
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );

        $section->add_control(
			'rs_exten_custom_css',
			[
				'label' => esc_html__( 'Custom CSS', 'rsaddon' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'css',
				'rows' => 20,
                'description' => 'Use "selector" to target this element. Example: selector .child { opacity: 0; }',
			]
		);

        $section->add_control(
            'rs_exten_custom_css_panel_notice',
            [
                'type'            => Controls_Manager::RAW_HTML,
                'raw'             => __('<strong>Custom CSS</strong> Does not work in Editor page.', 'rsaddon'),
                'content_classes' => 'rs-panel-notice',
            ]
        );

        $section->end_controls_section();
    }

    public function render_custom_css($element)
    {
        $settings = $element->get_settings_for_display();
        
        if (isset($settings['rs_exten_custom_css']) && !empty($settings['rs_exten_custom_css'])) {
            $unique_selector = $element->get_unique_selector();
            $custom_css = str_replace('selector', $unique_selector, $settings['rs_exten_custom_css']);
            ?>

            <style>
                <?php
                    echo esc_html($custom_css);
                ?>
            </style>

        <?php }
    }

}

new RS_Exten_Custom_CSS_Setting();