<?php



use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;


defined('ABSPATH') || die();

class RS_Exten_Link_Anything_Setting
{

    public function __construct()
    {
        add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/column/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/common/_section_style/after_section_end', [$this, 'register_controls'], 10, 1);

        add_action('elementor/frontend/before_render', [$this, 'render_rs_link_anything'], 10, 1);
    }


    public function register_controls(Element_Base $section)
    {
        $section->start_controls_section(
            'rs_exten_link_anything_section',
            [
                'label' => 'RS Link Anything',
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $section->add_control(
                'rs_exten_link_anything_panal_notice',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => __('<strong>Link Anything</strong> will work out side of editor page.', 'rsaddon'),
                    'content_classes' => 'rs-panel-notice',
                ]
            );
            $section->add_control(
                'rs_exten_container_link',
                [
                    'label'       => __( 'URL', 'rsaddon' ),
                    'type'        => Controls_Manager::URL,
                    'dynamic'     => [
                        'active' => true,
                    ],
                    'placeholder' => 'https://example.com',
                ]
            );

            $section->start_controls_tabs( 'rs_exten_container_link_wrapper_tabs' );
                $section->start_controls_tab('rs_exten_container_link_wrapper_normal', [ 'label' => esc_html__( 'Normal', 'rsaddon' ) ] );
                    $section->add_control(
                        'rs_exten_container_link_opacity',
                        [
                            'label' => __( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'max' => 1,
                                    'min' => 0.10,
                                    'step' => 0.01,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.rs-link-anything-wrapper' => 'opacity: {{SIZE}}; transition: all .3s ease;',
                            ],
                        ]
                    );
                $section->end_controls_tab();
            
                $section->start_controls_tab( 'rs_exten_container_link_wrapper_hover', [ 'label' => esc_html__( 'Hover', 'rsaddon' ) ] );
                    $section->add_control(
                        'rs_exten_container_link_opacity_hover',
                        [
                            'label' => __( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'max' => 1,
                                    'min' => 0.10,
                                    'step' => 0.01,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.rs-link-anything-wrapper:hover' => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );
                $section->end_controls_tab();
            $section->end_controls_tabs();
        $section->end_controls_section();
    }

    public function render_rs_link_anything($element)
    {
        $settings = $element->get_settings_for_display();
        $theLink = $settings['rs_exten_container_link'];
        
        if ( $theLink && ! empty( $theLink['url'] ) ) {
            
            $theLink['url'] = esc_url( $theLink['url'] );
            
            $element->add_render_attribute(
                '_wrapper',
                [
                    'class' => "rs-link-anything-wrapper",
                    'data-rs-element-link' => json_encode( $theLink ),
                    'style' => 'cursor: pointer'
                ]
            );
        }
    }

}

new RS_Exten_Link_Anything_Setting();