<?php

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;


defined('ABSPATH') || die();

class RS_Exten_Sec_Style_Setting
{

	public function __construct()
	{
		
		add_action('elementor/element/container/section_layout/after_section_end', [$this, 'rs_sec_style_control'], 3);
		add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'rs_sec_style_control'], 3);
		
	}

	public function rs_sec_style_control(Element_Base $section)
	{
		$tabs_field = Controls_Manager::TAB_CONTENT;

		if ('section' === $section->get_name()  || 'container' === $section->get_name()) {
			$tabs_field = Controls_Manager::TAB_LAYOUT;
		}

		$section->start_controls_section(
			'_section_rs_sec_style_control',
			[
				'label' => __('RS Section Style', 'rsaddon'),
				'tab'   => $tabs_field,
			]
		);

		$section->add_control(
			'rs_sec_position',
			[
				'label'     => __('Position', 'rsaddon'),
				'type'      => Controls_Manager::SELECT,
				'label_block' => true,
				'prefix_class' => 'rs-posi-',
				'options'   => [
					''			 	=> __('Default', 'rsaddon'),
					'relative' 	=> __('Relative', 'rsaddon'),
					'unset' 	=> __('Unset', 'rsaddon')
				],
				'default'   => '',
				'render_type' => 'template'
			]
		);

		$section->add_responsive_control(
			'rs_sec_blur',
			[
				'label' => esc_html__( 'Backdrop Blur', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'backdrop-filter: blur({{SIZE}}px) !important;',
				]
			]
		);

		$section->end_controls_section();
	}

}

new RS_Exten_Sec_Style_Setting();
?>