<?php
/**
 * Feature List
 *
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;

defined( 'ABSPATH' ) || die();

class Rsaddon_Elementor_Pro_Button_Rotating_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'rs-button-rotating';
    }   


    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'RS Button Rotating', 'rsaddon' );
    }
    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'rs-badge';
    }


    public function get_categories() {
        return [ 'rsaddon_category' ];
    }

    public function get_keywords() {
        return [ 'button', 'company', 'button', 'animate', 'rotating' ];
    }

    // Register Controlls
    protected function register_controls() {
        $this->register_content_controls();
        $this->register_content_style_controls();
    }

    // Content Start
    protected function register_content_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Content', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'rotate_degree',
                [
                    'label'       => esc_html__( 'Latter Space', 'rsaddon' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'description' => esc_html__( 'Count all letters & divide with 360 (Space also a letter).', 'rsaddon' ),
                    'placeholder' => esc_html__( '20', 'rsaddon' ),
                ]
            );
            $this->add_control(
                'button_logo_icon_heading',
                [
                    'label' => esc_html__( 'Inner Icon / Logo', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );

            $this->add_control(
                'show_inner_logo_icon',
                [
                    'label' => esc_html__( 'Show / Hide', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'inner_icon_logo_type',
                [
                    'label' => esc_html__( 'Select Type', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'image',
                    'options' => [
                        'image' => esc_html__( 'Image', 'rsaddon' ),
                        'icon' => esc_html__( 'Icon', 'rsaddon' ),
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'inner_icon',
                [
                    'label' => __('Icon', 'rsaddon'),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'ri-arrow-right-line',
                        'library' => 'reguler',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'icon'
                    ]
                ]
            );
            $this->add_control(
                'inner_icon_hover_rotate',
                [
                    'label' => esc_html__( 'Icon Hover Rotate', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo:hover i,
                        {{WRAPPER}} .rs-button-rotating .button-logo:hover svg' => 'transform: rotate({{SIZE}}deg);',
                    ],
                    'default' => [
                        'size' => 45,
                    ],
                    'condition' => [
                        'inner_icon_logo_type' => 'icon',
                        'show_inner_logo_icon' => 'yes'
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'logo_image',
                [
                    'label' => esc_html__( 'Choose Image', 'rsaddon' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'image'
                    ]
                ]
            );
            $this->add_control(
                'inner_image_animation',
                [
                    'label' => esc_html__( 'Logo Aniamtion', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'separator' => 'before',
                    'default' => 'yes',
                    'condition' => [
                        'inner_icon_logo_type' => 'image',
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'inner_image_animation_duration',
                [
                    'label' => esc_html__( 'Animation Duration', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'size' => 1,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating.image-anim-yes .button-logo img' => 'animation-duration: {{SIZE}}s;',
                    ],
                    'condition' => [
                        'inner_image_animation' => 'yes',
                        'inner_icon_logo_type' => 'image',
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );

            // Button Link
            $this->add_control(
                'button_link_heading',
                [
                    'label' => esc_html__( 'Button Link', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );

            $this->add_control(
                'btn_link_enable',
                [
                    'label' => esc_html__( 'Button Link Enable?', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'no', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'btn_link',
                [
                    'label' => esc_html__( 'Link', 'elementor' ),
                    'type' => Controls_Manager::URL,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'btn_link_enable' => 'yes',
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            
            $this->add_control(
                'video_btn_moode',
                [
                    'label' => esc_html__( 'Video Button Mood', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'no', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'btn_link_enable' => 'yes'
                    ]
                ]
            );

            // Content Text
            $this->add_control(
                'button_text_heading',
                [
                    'label' => esc_html__( 'Button Text', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'button_text',
                [
                    'label'       => esc_html__( 'button Text', 'rsaddon' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => 'CompanybuttonHere.',
                    'placeholder' => esc_html__( 'Company button (No Space)', 'rsaddon' ),
                ]
            );
            $this->add_control(
                'text_animation',
                [
                    'label' => esc_html__( 'Text Aniamtion', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'text_animation_duration',
                [
                    'label' => esc_html__( 'Animation Duration', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'size' => 30,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating.text-anim-yes .text-wrapper' => 'animation-duration: {{SIZE}}s;',
                    ],
                    'condition' => [
                        'text_animation' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'text_animation_pause_on_hover',
                [
                    'label' => esc_html__( 'Mouse Enter Pause', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' => [
                        'text_animation' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'text_scroll_animation',
                [
                    'label' => esc_html__( 'Scroll Rotate Aniamtion', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'separator' => 'before',
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'wrapper_overlay',
                [
                    'label' => esc_html__( 'Overlay', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'separator' => 'before',
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
        $this->end_controls_section();
    }

    protected function register_content_style_controls()
    {   
        
        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__( 'Content Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            // Wrapper Style Start
            $this->add_control(
                'wrapper_style_heading',
                [
                    'label' => esc_html__( 'Wrapper Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'wrapper_size',
                [
                    'label' => esc_html__( 'Wrapper Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 150,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'wrapper_background',
					'label' => esc_html__( 'Background', 'rsaddon' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-button-rotating',
				]
			);
            $this->add_responsive_control(
                'wrapper_filter_blur',
                [
                    'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                    ]
                ]
            );
            $this->add_responsive_control(
                'wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'wrapper_border',
                    'selector' => '{{WRAPPER}} .rs-button-rotating',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'wrapper_shadow',
                    'selector' => '{{WRAPPER}} .rs-button-rotating',
                ]
            );

            // Logo Style Start
            $this->add_control(
                'logo_style_heading',
                [
                    'label' => esc_html__( 'Inner Icon / Logo Area Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'logo_wrapper_size',
                [
                    'label' => esc_html__( 'Wrapper Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 90,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'inner_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-button-rotating .button-logo i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'icon'
                    ]
                ]
            );

            $this->add_control(
                'inner_icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo svg path' => 'fill: {{VALUE}}',
                        '{{WRAPPER}} .rs-button-rotating .button-logo i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'icon'
                    ]
                ]
            );
            $this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'logo_wrapper_background',
					'label' => esc_html__( 'Background', 'rsaddon' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-button-rotating .button-logo',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
				]
			);
            $this->add_control(
                'inner_logo_width',
                [
                    'label' => esc_html__( 'Logo Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'image'
                    ]
                ]
            );

            $this->add_control(
                'inner_logo_height',
                [
                    'label' => esc_html__( 'Logo Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo img' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'image'
                    ]
                ]
            );
            $this->add_control(
                'inner_logo_line_height',
                [
                    'label' => esc_html__( 'Logo LIne Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo' => 'line-height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes',
                        'inner_icon_logo_type' => 'image'
                    ]
                ]
            );
            $this->add_responsive_control(
                'logo_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'logo_wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .button-logo' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'logo_wrapper_border',
                    'selector' => '{{WRAPPER}} .rs-button-rotating .button-logo',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'logo_hover_border',
                [
                    'label' => esc_html__( 'Icon / Logo Area Hover Border', 'rsaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'logo_wrapper_hover_border',
                    'selector' => '{{WRAPPER}} .rs-button-rotating .button-logo:hover',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'logo_wrapper_shadow',
                    'selector' => '{{WRAPPER}} .rs-button-rotating .button-logo',
                    'condition' => [
                        'show_inner_logo_icon' => 'yes'
                    ]
                ]
            );
            // Logo Style End

            // Text Style Start
            $this->add_control(
                'text_style_heading',
                [
                    'label' => esc_html__( 'Text Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .rs-button-rotating .text-wrapper span',
                ]
            );
            $this->add_control(
                'text_color',
                [
                    'label' => esc_html__( 'Text Color', 'textdomain' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating .text-wrapper span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            // Text Style End
        $this->end_controls_section();

        $this->start_controls_section(
            'section_overlay_style',
            [
                'label' => esc_html__( 'Overlay', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'wrapper_overlay' => 'yes',
                ]
            ]
        );
            $this->add_responsive_control(
                'wrapper_before_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating::before' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'wrapper_before_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-button-rotating::before' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'wrapper_before_background',
					'label' => esc_html__( 'Background', 'rsaddon' ),
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-button-rotating::before',
				]
			);
            // Overlay Style End
            $this->add_control(
                'count_number_position_popover_toggle',
                [
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Position', 'rsaddon' ),
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'return_value' => 'yes',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'overlay_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'unset' => esc_html__( 'Unset', 'rsaddon' ),
                            'relative' => esc_html__( 'Relative', 'rsaddon' ),
                            'absolute'  => esc_html__( 'Absolute', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-button-rotating::before' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'overlay_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'overlay_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-button-rotating::before' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'overlay_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'overlay_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-button-rotating::before' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'overlay_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'overlay_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-button-rotating::before' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'overlay_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'overlay_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-button-rotating::before' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();

        // Overlay Style End
        $this->end_controls_section();
    }

    /**
     * Render counter widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     * @access protected
     */
    /**
     * Render counter widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */

	protected function render() {        
        $settings = $this->get_settings_for_display(); 
        if ( 'yes' === $settings['show_inner_logo_icon']) {
            if ( 'image' === $settings['inner_icon_logo_type']) {
                $image = $settings['logo_image']['url'];
                if ( ! $image ) {
                    $image = Utils::get_placeholder_image_src();
                }
            }
        } 

        $link_enable = $settings['btn_link_enable'];
        $unique = rand(2012, 3554120);
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        
        ?> 
            <div class="rs-button-rotating text-anim-<?php echo esc_attr($settings['text_animation']) ?> text-anim-pause-<?php echo esc_attr($settings['text_animation_pause_on_hover']) ?> image-anim-<?php echo esc_attr($settings['inner_image_animation']) ?> button-anim-<?php echo $unique ?> <?php echo esc_attr($settings['wrapper_overlay']); ?>">
                <?php if ( 'yes' === $settings['show_inner_logo_icon']) { ?>
                    <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?>
                    <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?> <?php if ($settings['video_btn_moode'] == 'yes') { ?> class="popup-videos" title="Play" <?php } ?>>
                    <?php } ?>
                        <div class="button-logo">
                            <?php if ( 'image' === $settings['inner_icon_logo_type']) { ?>
                                <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr(Control_Media::get_image_alt($settings['logo_image']));?>"/>
                            <?php } else {
                                \Elementor\Icons_Manager::render_icon($settings['inner_icon'], ['aria-hidden' => 'true']);
                            } ?>
                        </div>
                    <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?>
                    </a>
                    <?php } ?>

                <?php } ?>
                
                <div class="text-wrapper-parent <?php if ( 'yes' === $settings['text_scroll_animation']){?>gsap-rotate<?php } ?>">
                    <div class="text-wrapper">
                        <?php echo esc_html($settings['button_text']);?>
                    </div>
                </div>
            </div>

            <style>
                <?php                
                    $rotate_degree = ($settings['rotate_degree']) ? $settings['rotate_degree'] : '20' ;
                    for ($i = 1; $i <= 100; $i++) {
                        echo ".button-anim-$unique .text-wrapper .char{$i} {
                            transform: rotate(" . ($i * (int)$rotate_degree) . "deg);
                        }\n";
                    }
                ?>
            </style>
            
            <script>
                jQuery(function() {
                    jQuery(".button-anim-<?php echo $unique ?> .text-wrapper").lettering();
                });
            </script>
        <?php
    }
}
