<?php
/**
 * Elementor RS Iconbox Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */



use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;


defined( 'ABSPATH' ) || die();
class Rsaddon_Elementor_pro_RSIcon_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'rs-iconbox';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'RS Icon Box', 'rsaddon' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'rs-badge';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories() {
        return [ 'rsaddon_category' ];
    }
	/**
	 * Register services widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
		protected function register_controls() {

		$this->start_controls_section(
			'section_services',
			[
				'label' => esc_html__( 'Icon Box Global', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_responsive_control(
				'align',
				[
					'label' => esc_html__( 'Alignment', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'rsaddon' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'rsaddon' ),
							'icon' => 'eicon-text-align-right',
						],
						'justify' => [
							'title' => esc_html__( 'Justify', 'rsaddon' ),
							'icon' => 'eicon-text-align-justify',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'text-align: {{VALUE}}'
					],
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'markup_box_vertical_align',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'align-items: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'markup_flex_box_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'markup_box_column_align',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'flex-direction: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'markup_box_flex_wrap',
				[
					'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'nowrap' => [
							'title' => esc_html__( 'No Wrap', 'rsaddon' ),
							'icon' => 'eicon-nowrap',
						],
						'wrap' => [
							'title' => esc_html__( 'Wrap', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'flex-wrap: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'markup_box_gap_between',
				[
					'label' => esc_html__( 'Space Between', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'gap: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'link_enable',
				[
					'label' => esc_html__( 'Link Enable?', 'rsaddon' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'rsaddon' ),
					'label_off' => esc_html__( 'no', 'rsaddon' ),
					'return_value' => 'yes',
					'default' => 'no',
					'separator' => 'before'
				]
			);
			$this->add_control(
				'card_link',
				[
					'label' => esc_html__( 'Link', 'rsaddon' ),
					'type' => Controls_Manager::URL,
					'dynamic' => [
						'active' => true,
					],
					'condition' => [
						'link_enable' => 'yes'
					]
				]
			);
		$this->end_controls_section();

		// Icon Content Start
		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Icon / Image', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'icon_type',
				[
					'label'   => esc_html__( 'Select Icon Type', 'rsaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'icon',			
					'options' => [					
						'icon' => esc_html__( 'Icon', 'rsaddon'),
						'image' => esc_html__( 'Image', 'rsaddon'),
									
					],
					'separator' => 'before',
				]
			);
			$this->add_control(
				'selected_icon',
				[
					'label' => esc_html__( 'Icon', 'rsaddon' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-circle',
						'library' => 'fa-solid',
					],
					'condition' => [
						'icon_type' => 'icon',
					],	
				]
			);
			$this->add_control(
				'selected_image',
				[
					'label' => esc_html__( 'Choose Image', 'rsaddon' ),
					'type'  => Controls_Manager::MEDIA,				
					
					'condition' => [
						'icon_type' => 'image',
					],
					'separator' => 'before',
				]
			);
		$this->end_controls_section();
		// Icon Content End

		// Title Desc Content Start
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title & Description', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'title',
				[
					'label'       => esc_html__( 'Box Title', 'rsaddon' ),
					'type'        => Controls_Manager::TEXT,
					'label_block' => true,
					'default'     => 'Box Title',
					'placeholder' => esc_html__( 'Box Title', 'rsaddon' ),
					'separator'   => 'before',
				]
			);
			$this->add_control(
				'title_tag',
				[
					'label' => esc_html__( 'Title HTML Tag', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'h1'  => [
							'title' => esc_html__( 'H1', 'rsaddon' ),
							'icon' => 'eicon-editor-h1'
						],
						'h2'  => [
							'title' => esc_html__( 'H2', 'rsaddon' ),
							'icon' => 'eicon-editor-h2'
						],
						'h3'  => [
							'title' => esc_html__( 'H3', 'rsaddon' ),
							'icon' => 'eicon-editor-h3'
						],
						'h4'  => [
							'title' => esc_html__( 'H4', 'rsaddon' ),
							'icon' => 'eicon-editor-h4'
						],
						'h5'  => [
							'title' => esc_html__( 'H5', 'rsaddon' ),
							'icon' => 'eicon-editor-h5'
						],
						'h6'  => [
							'title' => esc_html__( 'H6', 'rsaddon' ),
							'icon' => 'eicon-editor-h6'
						]
					],
					'default' => 'h2',
					'toggle' => false,
				]
			);
			$this->add_control(
				'text',
				[
					'label' => esc_html__( 'Box Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => 'Box Text',
					'separator' => 'before',
				]			
			);
		$this->end_controls_section();
		// Title Desc Content End

		// Global Style Start
		$this->start_controls_section(
		    '_section_g_style',
		    [
		        'label' => esc_html__( 'Global Style', 'rsaddon' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);
			$this->add_responsive_control(
				'g_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_max_width',
				[
					'label' => esc_html__( 'Max-Width', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_height',
				[
					'label' => esc_html__( 'Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_min_height',
				[
					'label' => esc_html__( 'Min Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'min-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->start_controls_tabs(
				'g_style_tabs'
			);
				$this->start_controls_tab(
					'g_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_bg_color',
							'label' => esc_html__( 'Background', 'rsaddon' ),
							'types' => [ 'classic', 'gradient' ],                
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'g_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_bg_color_hover',
							'label' => esc_html__( 'Background', 'rsaddon' ),
							'types' => [ 'classic', 'gradient' ],                
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner:hover',
						]
					);
					$this->add_control(
						'g_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-iconbox-area .box-inner:hover' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow_hover',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner:hover',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Global Style End

		//Icon/Image Style Start
		$this->start_controls_section(
		    '_section_media_style',
		    [
		        'label' => esc_html__( 'Icon / Image', 'rsaddon' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);
			$this->add_responsive_control(
				'icon_wrapper_width',
				[
					'label' => esc_html__( 'Wrapper width', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_height',
				[
					'label' => esc_html__( 'Wrapper Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 300,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'icon_type' => 'icon'
					]
				]
			);
			$this->add_responsive_control(
				'icon_image_width',
				[
					'label' => esc_html__( 'Image Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area img' => 'width: {{SIZE}}{{UNIT}};',                   
					],
					'condition' => [
						'icon_type' => 'image',
					]
				]
			);
			$this->add_responsive_control(
				'icon_image_height',
				[
					'label' => esc_html__( 'Image Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area img' => 'height: {{SIZE}}{{UNIT}};',                   
					],
					'condition' => [
						'icon_type' => 'image',
						
					]
				]
			);
			
			$this->start_controls_tabs(
				'icon_style_tabs'
			);
				$this->start_controls_tab(
					'icon_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area i' => 'color: {{VALUE}};',
							],
							'condition' => [
								'icon_type' => 'icon'
							]
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_wrapper_bg_color',
							'label' => esc_html__( 'Background', 'rsaddon' ),
							'types' => [ 'classic', 'gradient' ],                
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'icon_wrapper_border',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'icon_wrapper_box_shadow',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner .icon-area',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'icon_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_control(
						'icon_hover_color',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-iconbox-area .box-inner:hover .icon-area svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-iconbox-area .box-inner:hover .icon-area i' => 'color: {{VALUE}};',
							],
							'condition' => [
								'icon_type' => 'icon'
							]
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_wrapper_bg_color_hover',
							'label' => esc_html__( 'Background', 'rsaddon' ),
							'types' => [ 'classic', 'gradient' ],                
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner:hover .icon-area',
						]
					);
					$this->add_control(
						'icon_wrapper_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-iconbox-area .box-inner:hover .icon-area' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'icon_wrapper_box_shadow_hover',
							'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner:hover .icon-area',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		//Icon/Image Style End
		

		$this->start_controls_section(
		    '_section_title_style',
		    [
		        'label' => esc_html__( 'Title & Description', 'rsaddon' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);
			$this->add_control(
				'title_heading',
				[
					'type' => Controls_Manager::HEADING,
					'label' => esc_html__( 'Title', 'rsaddon' ),
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => esc_html__( 'Typography', 'rsaddon' ),
					'selector' => '{{WRAPPER}}  .rs-iconbox-area .box-inner .text-area .title',
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .text-area .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_hover_color',
				[
					'label' => esc_html__( 'Hover Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner:hover .text-area .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .text-area .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			// Desc
			$this->add_control(
				'description_heading',
				[
					'type' => Controls_Manager::HEADING,
					'label' => esc_html__( 'Description', 'rsaddon' ),
					'separator' => 'before'
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'description_typography',
					'label' => esc_html__( 'Typography', 'rsaddon' ),
					'selector' => '{{WRAPPER}} .rs-iconbox-area .box-inner .text-area .desc',
				]
			);
			$this->add_control(
				'description_color',
				[
					'label' => esc_html__( 'Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .text-area .desc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'description_color_hover',
				[
					'label' => esc_html__( 'Hover Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner:hover .text-area .desc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'description_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-iconbox-area .box-inner .text-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		
	}

	/**
	 * Render counter widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	/**
	 * Render counter widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$link = ('yes' === $settings['link_enable'] && !empty($settings['card_link']['url'])) ? $settings['card_link']['url'] : '#';
        $target = ($link !== '#' && $settings['card_link']['is_external']) ? 'target=_blank' : '';
        $pointer = ($link === '#') ? 'pointer-none' : '';
		?>
		<div class="rs-iconbox-area">
		    <a class="box-inner <?php echo esc_attr($pointer); ?>" href="<?php echo esc_url($link); ?>" <?php echo esc_attr($target); ?>>
    	    	<?php if( !empty($settings['selected_icon']['value']) || !empty($settings['selected_image']['url'])){?>
    	    		<div class="icon-area">
    		    		<?php if(!empty($settings['selected_icon']['value'])) {
							\Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
						}
    		    		if(!empty($settings['selected_image']['url'])) { ?>
							<img src="<?php echo esc_url($settings['selected_image']['url']);?>" alt="image" />
    		    		<?php } ?>
    	    		</div>
    	    	<?php }?>      
			    <div class="text-area">
			    	<?php if(!empty($settings['title'])){ ?>		
				    	<<?php echo esc_html($settings['title_tag']); ?> class="title">
							<?php echo esc_html($settings['title']); ?>
						</<?php echo esc_html($settings['title_tag']); ?>>
			    	<?php }
					if(!empty($settings['text'])) { ?>
			    		<p class="desc">  <?php echo wp_kses_post($settings['text']);?></p>	
			    	<?php } ?>	
			    </div>
			</a>
		</div>	
	<?php
	}
}
