<?php   
use Elementor\Icons_Manager;
$cat = $settings['category'];
$select = $settings['select_posts'];

global  $paged;
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

if(empty($cat)){
    $prelements_query = new wp_Query(array(
        'post_type'         => 'post',                                
        'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
        'posts_per_page'    => $settings['per_page'],
        'offset'            => $settings['pre_blog_posts_offset'],
        'paged'             => $paged,
        'post__in'          => $select,                  
    ));   
} else {
    $prelements_query = new wp_Query(array(
        'post_type'         => 'post',
        'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
        'posts_per_page'    => $settings['per_page'],
        'offset'            => $settings['pre_blog_posts_offset'],
        'paged'             => $paged,
        'post__in'          => $select,
        'tax_query'      => array(
            array(
                'taxonomy' => 'category',
                'field'    => 'slug', 
                'terms'    => $cat 
            ),
        )
    ));   
}                      


while($prelements_query->have_posts()): $prelements_query->the_post();
    $full_date       = get_the_date('M j, Y');
    $short_date       = get_the_date('j M');
    $blog_only_date = sprintf('%02d', get_the_date('j'));
    $blog_only_month = get_the_date('M');
    $post_admin      = get_the_author();
    $author_sub_text = $settings['author_sub_text'];

    if(!empty($settings['blog_word_show'])){
        $limit = $settings['blog_word_show'];
    } else{
        $limit = 20;
    }
    
    if(!empty($settings['blog_title_word_show'])) {
        $limits = $settings['blog_title_word_show'];
    } else {
        $limits = 200;
    }

    if ('author_p_bottom' == $settings['blog_meta_author_position']) {
        $author_bottom = 'btn_author_with';
    } else {
        $author_bottom = '';
    }
?>

<div class="pre-blog-item <?php echo esc_attr($columns_grid); ?>">
    <div class="blog-inner-wrap ">
        <div class="pre-image-wrap">
            <?php if ( 'yes' === $settings['blog_image_show_hide'] ){ ?>
                <a href="<?php the_permalink();?>" class="rs--thum">
                    <?php  the_post_thumbnail($settings['thumbnail_size']);?>
                </a>
            <?php 
                if ( 'yes' === $settings['blog_cate_show_hide'] ){
                    $category = get_the_category(get_the_ID());
                    foreach($category as $cat) { 
                    ?>
                    <a href="<?php echo esc_url( get_category_link($cat->term_id) ); ?>" class="rs-cate">
                        <?php echo esc_html($cat->name);?>
                    </a>
                <?php } 
                } 
            }
            if ('date_p_absolute' == $settings['blog_meta_date_position']) {
                if(!empty($blog_only_date) && 'yes' == $settings['blog_meta_date_show_hide']){ ?> 
                    <div class="date_meta <?php echo esc_attr($settings['blog_meta_date_position']); ?>">
                        <span>
                            <b><?php echo esc_html($blog_only_date); ?></b>
                            <?php echo esc_html($blog_only_month); ?>
                        </span>
                    </div>
                <?php }
            } ?>
        </div>
        <div class="pre-blog-content">
            <?php if('yes' == $settings['blog_meta_author_show_hide'] || 'yes' == $settings['blog_meta_comment_show_hide']) {?>
                <div class="top_meta_wrapper separator_<?php echo esc_attr($settings['meta_separator_show']); ?>">
                    <?php if(empty($author_bottom) && (!empty($post_admin) && 'yes' == $settings['blog_meta_author_show_hide'])){ ?>
                        <div class="author_meta">
                            <div class="author_image">
                                <?php
                                    $author_id = get_the_author_meta('ID');
                                    echo get_avatar($author_id, 'full'); 
                                ?>
                            </div>
                            <div class="author_text">
                                <?php if (!empty($author_sub_text)){
                                    echo esc_html($author_sub_text);
                                } ?>
                                <span><?php echo esc_html($post_admin); ?></span>
                            </div>
                        </div>
                    <?php }
                    if ('date_p_default' == $settings['blog_meta_date_position']) {
                        if(!empty($full_date) && 'yes' == $settings['blog_meta_date_show_hide']){ ?> 
                            <div class="date_meta <?php echo esc_attr($settings['blog_meta_date_position']); ?>">
                                <i class="ri-calendar-2-line"></i>
                                <?php echo esc_html($full_date); ?>
                            </div>
                        <?php }
                    }
                    if('yes' == $settings['blog_meta_comment_show_hide']){ ?>
                        <div class="comment_meta">
                            <i class="ri-message-2-line"></i>
                            <?php echo get_comments_number(); ?>
                        </div>
                    <?php } ?>
                </div>
            <?php }
            
            if ( 'yes' === $settings['blog_title_show_hide'] ){ ?>
                <<?php echo esc_html( $settings['title_tag'] ) ?> class="pre-post-title"><a class="pre-pointer-events" href="<?php the_permalink();?>">
                    <?php echo wp_trim_words( get_the_title(), $limits, '...' ); ?></a>
                </<?php echo esc_html( $settings['title_tag'] ) ?>>
            <?php }
            
            if ( !empty(get_the_content()) && 'yes' == $settings['blog_content_show_hide'] ){ ?>
                <p class="pre-content"><?php echo wp_trim_words( get_the_content(), $limit, '...' ); ?></p>
            <?php }
            
            if ('date_p_bottom' == $settings['blog_meta_date_position']) {
                if(!empty($full_date) && 'yes' == $settings['blog_meta_date_show_hide']){ ?> 
                    <div class="date_meta <?php echo esc_attr($settings['blog_meta_date_position']); ?>">
                        <i class="ri-calendar-2-line"></i>
                        <?php echo esc_html($full_date); ?>
                    </div>
                <?php }
            }
            
            if ('yes' == $settings['blog_btn_show_hide']){ ?>
                <div class="blog-btn-part <?php echo $settings['btn_gradient'] ?> <?php echo esc_attr($author_bottom); ?>">

                    <?php if(!empty($author_bottom) && (!empty($post_admin) && 'yes' == $settings['blog_meta_author_show_hide'])){ ?>
                        <div class="author_meta">
                            <div class="author_image">
                                <?php
                                    $author_id = get_the_author_meta('ID');
                                    echo get_avatar($author_id, 'full'); 
                                ?>
                            </div>
                            <div class="author_text">
                                <?php if (!empty($author_sub_text)){
                                    echo esc_html($author_sub_text);
                                } ?>
                                <span><?php echo esc_html($post_admin); ?></span>
                            </div>
                        </div>
                    <?php } ?>

                    <a href="<?php the_permalink();?>">
                        <?php if (!empty($settings['btn_text'])) { ?>
                            <span>
                                <?php echo esc_html($settings['btn_text']); ?>
                            </span>
                        <?php }
                        if (!empty($settings['btn_icon'])) {
                            Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']);
                        } ?>
                    </a>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php
endwhile;

if(('grid' == $settings['widget_type_grid_slider']) && ('yes' == $settings['show_grid_pagination'])) { ?>
    <div class="pagination-area">
        <div class="nav-links">
            <?php
                $bigNum = 999999999;
                echo paginate_links(array(
                    'base'      => str_replace($bigNum, '%#%', esc_url(get_pagenum_link($bigNum))),
                    'format'    => '?paged=%#%',
                    'current'   => max(1, $paged),
                    'total'     => $prelements_query->max_num_pages,
                    'prev_text' => __('Prev', 'rsaddon'),
                    'next_text' => __('Next', 'rsaddon'),
                ));
            ?>
        </div>
    </div>
<?php }

wp_reset_query();
?>