<?php 
	use Elementor\Icons_Manager;
    $cat = $settings['portfolio_category'];
	$select_portfolio = $settings['select_portfolio_item'];
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	$unique = rand(515155,879797);

	if(empty($cat)){
    	$best_wp = new wp_Query(array(
			'post_type'      => 'portfolios',
			'posts_per_page' => $settings['per_page'],	
			'orderby' => 'menu_order',
			'post__in' => $select_portfolio,
			'order' 			=> $settings['pre_posts_sort'],							
		));	  
    }   
    else{
    	$best_wp = new wp_Query(array(
				'post_type'      => 'portfolios',
				'posts_per_page' => $settings['per_page'],	
				'orderby' => 'menu_order',
				'order' 			=> $settings['pre_posts_sort'],		
				'post__in' => $select_portfolio,	
				'tax_query'      => array(
			        array(
						'taxonomy' => 'portfolios-category',
						'field'    => 'slug', //can be set to ID
						'terms'    => $cat //if field is ID you can reference by cat/term number
			        ),
			    )
		));	  
    }

	$counter = 0;
	$thumb_counter = 0;?>
	<div class="project-both-wrap">
		<div class="portfolio_acc_feature_image portfolio-<?php echo $unique; ?>">
			<?php 
			while($best_wp->have_posts()): $best_wp->the_post();
			$thumb_counter++;
			$first_item_active = ($thumb_counter == 1) ? 'active' : '';
			?>
				<img class="<?php echo $thumb_counter ?> <?php echo $first_item_active ?>" src="<?php echo get_the_post_thumbnail_url();?>" alt="">
			<?php endwhile; ?>
		</div>
		<div class="portfolio-accordion accordion portfolio-<?php echo $unique; ?>" id="portfolio_accordion_inner_<?php echo $unique; ?>">
			<?php
			while($best_wp->have_posts()): $best_wp->the_post();
				$cats_show = get_the_term_list( $best_wp->ID, 'portfolios-category', ' ', '<span class="separator">,</span> ');
				$description = get_post_meta( get_the_ID(), 'custom_description', true );

				$i = rand(20212,351820);
				$counter++;
				$first_item_collapsed = ($counter !== 1) ? 'collapsed' : '';
				$first_item_show = ($counter == 1) ? 'show' : '';
			?>
				<div class="accordion-item item-<?php echo $counter ?>">
					<div class="accordion-header" id="heading<?php echo $i;?>">
						<div class="portfolio-acc-btn <?php echo $first_item_collapsed; ?>" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo $i;?>" aria-controls="collapse_<?php echo $i;?>">
							<h4 class="tab-title"><?php echo the_title();?></h4>
						</div>
					</div>
					<div id="collapse_<?php echo $i;?>" class="accordion-collapse collapse <?php echo $first_item_show; ?>" aria-labelledby="heading<?php echo $i;?>" data-bs-parent="#portfolio_accordion_inner_<?php echo $unique; ?>">
						<div class="accordion-body">
							<?php if (!empty($description)) {?>
								<p class="desc"><?php echo $description; ?></p>
							<?php } else {
								echo "Description not found.";
							}
							if (!empty($settings['read_more_text'])) {
								if ('yes' == $settings['show_button']) { ?>
									<div class="p-icon">
										<a href="<?php the_permalink(); ?>" class="prs_btn"><?php echo esc_html($settings['read_more_text']); ?></a>
									</div>
								<?php }
							} ?>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
	</div>

	<script>
		jQuery(document).ready(function($){
			$('.portfolio-<?php echo $unique; ?> .accordion-item').click(function(){
				$('.portfolio-<?php echo $unique; ?>.portfolio_acc_feature_image img').removeClass('active');
				var number = $(this).attr('class').split(' ').pop().split('-').pop();
				$('.portfolio-<?php echo $unique; ?>.portfolio_acc_feature_image img.' + number).addClass('active');
			});
		});
		</script>
	<?php
	wp_reset_query();  