<?php
/**
 * Elementor RS Progress bar Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */


use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;


defined( 'ABSPATH' ) || die();

class Rsaddon_Elementor_pro_progress_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'rs-progress';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'RS Progress Bar', 'rsaddon' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'rs-badge';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories() {
        return [ 'rsaddon_category' ];
    }
	/**
	 * Register services widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_progress',
			[
				'label' => esc_html__( 'Progress Bar', 'rsaddon' ),
			]
		);

		$this->add_control(
			'percent',
			[
				'label' => esc_html__( 'Percentage', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'label_block' => true,
			]
		);

		$this->add_control( 'rs_progress_bar_style', [
			'label' => esc_html__( 'Style', 'rsaddon' ),
			'type' => Controls_Manager::SELECT,
			'default' => 'style1',
			'options' => [
				'style1' => esc_html__( 'Style 1', 'rsaddon' ),
				'style2' => esc_html__( 'Style 2', 'rsaddon' ),
				'style3' => esc_html__( 'Style 3', 'rsaddon' ),
			],
		] );
		$this->add_control( 'layout', [
			'label' => esc_html__( 'Layout', 'rsaddon' ),
			'type' => Controls_Manager::SELECT,
			'default' => 'horizontal',
			'options' => [
				'horizontal' => esc_html__( 'Horizontal', 'rsaddon' ),
				'vertical' => esc_html__( 'Vertical', 'rsaddon' ),
				'circle' => esc_html__( 'Circle', 'rsaddon' ),
			],
		] );
		$this->add_control( 'rs_linear_bar_style', [
			'label' => esc_html__( 'Linear Background Style', 'rsaddon' ),
			'type' => Controls_Manager::SELECT,
			'default' => 'basic',
			'options' => [
				'basic' => esc_html__( 'Basic', 'rsaddon' ),
				'striped' => esc_html__( 'Striped', 'rsaddon' ),
				'animation' => esc_html__( 'Striped Animation', 'rsaddon' ),
			],
			'condition' => [
				'layout!' => 'circle'
			]
		] );
		$this->add_responsive_control(
			'circle_size',
			[
				'label' => esc_html__('Circle Size', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 1,
				],
				'range' => [
					'px' => [
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar.layout-style-circle .card-circle svg' => 'zoom: {{SIZE}};',
				],
				'condition' => [
					'layout' => 'circle'
				]
			]
		);
		$this->add_responsive_control(
			'circle_rotate',
			[
				'label' => esc_html__( 'Circle Rotation Degree', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar.layout-style-circle .card-circle svg' => 'transform: rotate({{SIZE}}deg);',
				],
				'condition' => [
					'layout' => 'circle'
				]
			]
		);
		$this->add_control(
			'display_percentage',
			[
				'label' => esc_html__( 'Show Percentage', 'rsaddon' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'rsaddon' ),
				'label_off' => esc_html__( 'Hide', 'rsaddon' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_progress_inner_text',
			[
				'label' => esc_html__( 'Show Title', 'rsaddon' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'rsaddon' ),
				'label_off' => esc_html__( 'Hide', 'rsaddon' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'rs_progress_inner_text',
			[
				'label' => esc_html__( 'Title Text', 'rsaddon' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Web Designer', 'rsaddon' ),
				'default' => esc_html__( 'Web Designer', 'rsaddon' ),
				'label_block' => true,
				'condition' => [
					'show_progress_inner_text' => 'yes'
				]
			]
		);
		$this->add_responsive_control(
			'progress_title_opacity_text',
			[
				'label' => esc_html__( 'Title Opacity (Normal)', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'show_progress_inner_text' => 'yes',
					'layout' => 'vertical'
				]
			]
		);
		$this->add_responsive_control(
			'progress_title_opacity_text_loaded',
			[
				'label' => esc_html__( 'Title Opacity (After Loaded)', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar.animation-complete .skillbar-title' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'show_progress_inner_text' => 'yes',
					'layout' => 'vertical'
				]
			]
		);
		$this->add_control(
			'rs_view',
			[
				'label' => esc_html__( 'View', 'rsaddon' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'wrapper_style',
			[
				'label' => esc_html__( 'Wrapper', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'wrapper_text_align',
			[
				'label' => esc_html__( 'Alignment', 'rsaddon' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rsaddon' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rsaddon' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rsaddon' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar' => 'text-align: {{VALUE}};',
				],
				'condition' => [
					'layout' => 'circle'
				]
			]
		);
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'wrapper_bg',
                'label' => esc_html__( 'Background', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .rs-skill-bar',
            ]
        );
		$this->add_responsive_control(
		    'wrapper_padding',
		    [
		        'label' => esc_html__( 'Padding', 'rsaddon' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px' ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'wrapper_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rsaddon' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'arrow_shadow_custom',
                'selector' => '{{WRAPPER}} .rs-skill-bar'
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'rs_section_progress_style',
			[
				'label' => esc_html__( 'Progress Bar', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'rs_bar_height',
			[
				'label' => esc_html__( 'Height', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rs-skill-bar.style2 .skillbar .skillbar-title' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'horizontal'
				]
			]
		);
		$this->add_control(
			'rs_bar_height_vertical',
			[
				'label' => esc_html__( 'Height', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'vertical'
				]
			]
		);
		$this->add_control(
			'rs_bar_width_vertical',
			[
				'label' => esc_html__( 'Width', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar, {{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'vertical'
				]
			]
		);
		$this->add_responsive_control(
		    'progress_height',
		    [
		        'label' => esc_html__( 'Progress Height', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ 'px', '%' ],
		        'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar' => 'height: {{SIZE}}{{UNIT}};',
		        ],
				'condition' => [
					'layout' => 'horizontal'
				]
		    ]
		);
		$this->add_responsive_control(
		    'progress_position_horizontal',
		    [
		        'label' => esc_html__( 'Position Horizontal', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .skillbar' => 'left: {{SIZE}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'progress_position_vertical',
		    [
		        'label' => esc_html__( 'Position Vertical', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .skillbar' => 'top: {{SIZE}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'inner_padding',
		    [
		        'label' => esc_html__( 'Inner Padding', 'rsaddon' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px' ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rsaddon' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar,'
		            . '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
		        'name' => 'bar-border',
		        'selector' => '{{WRAPPER}} .rs-skill-bar .skillbar',
		    ]
		);
		$this->add_control(
			'rs_inner_title',
			[
				'label' => esc_html__( 'Title Style', 'rsaddon' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'rs_inner_title_text_align',
			[
				'label' => esc_html__( 'Alignment', 'rsaddon' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rsaddon' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rsaddon' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rsaddon' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rs_bar_inline_color',
			[
				'label' => esc_html__( 'Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'rs_bar_inner_typography',
				'selector' => '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title',
			]
		);
		$this->add_responsive_control(
		    'progress_bar_title_position_horizontal',
		    [
		        'label' => esc_html__( 'Position Horizontal (Left)', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;;',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'progress_bar_title_position_horizontal_right',
		    [
		        'label' => esc_html__( 'Position Horizontal (Right)', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'progress_bar_title_position_vertical',
		    [
		        'label' => esc_html__( 'Position Vertical Top', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => -100,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'progress_bar_title_position_vertical_bottom',
		    [
		        'label' => esc_html__( 'Position Vertical Bottom', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => -100,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-title' => 'top: unset !important; bottom: {{SIZE}}{{UNIT}} !important;',
		        ],
		    ]
		);
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'rs_bar_bg_animate_color_bg',
                'label' => esc_html__( 'Background', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar' => 'background: {{VALUE}};',
            ]
        );

		$this->add_control(
			'rs_inner_percent',
			[
				'label' => esc_html__( 'Percent Style', 'rsaddon' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control( 'gradient_option', [
			'label' => esc_html__( 'Gradient Option', 'rsaddon' ),
			'type' => Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'gradiant_color' => esc_html__( 'Enable', 'rsaddon' ),
				'' => esc_html__( 'Disable', 'rsaddon' ),
			],
			'condition' => [
				'layout!' => 'circle'
			]
		] );

		$this->add_control( 'percent_tooltip_style', [
			'label' => esc_html__( 'Tootip Style', 'rsaddon' ),
			'type' => Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'tooltip-style' => esc_html__( 'Enable', 'rsaddon' ),
				'' => esc_html__( 'Disable', 'rsaddon' ),
			],
			'condition' => [
				'rs_progress_bar_style' => 'style3'
			]
		] );

		$this->add_control(
			'rs_bar_percent_color',
			[
				'label' => esc_html__( 'Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rs_bar_percent_bg_color',
			[
				'label' => esc_html__( 'Background', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'rs_bar_percent_typography',
				'selector' => '{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent',
			]
		);
		$this->add_responsive_control(
		    'progress_bar_percent_position_horizontal',
		    [
		        'label' => esc_html__( 'Position Horizontal', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent' => 'left: {{SIZE}}{{UNIT}};',
		        ],
				'condition' => [
					'layout!' => 'circle'
				]
		    ]
		);
		$this->add_responsive_control(
		    'progress_bar_percent_position_vertical',
		    [
		        'label' => esc_html__( 'Position Vertical', 'rsaddon' ),
		        'type' => Controls_Manager::SLIDER,
		        'size_units' => [ '%', 'px' ],
		        'range' => [
		            'px' => [
		                'min' => -1000,
		                'max' => 1000,
		            ],
		            '%' => [
		                'min' => 0,
		                'max' => 100,
		            ],
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent' => 'top: {{SIZE}}{{UNIT}};',
		        ],
				'condition' => [
					'layout!' => 'circle'
				]
		    ]
		);
		$this->add_control(
			'rs_inner_text_heading',
			[
				'label' => esc_html__( 'Background Color', 'rsaddon' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'rs_circle_outer_color',
			[
				'label' => esc_html__( 'Circle Outer Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar.layout-style-circle .card-circle svg circle:not(.thiscir)' => 'stroke: {{VALUE}};',
				],
				'condition' => [
					'layout' => 'circle'
				]
			]
		);
		$this->add_control(
			'rs_circle_color',
			[
				'label' => esc_html__( 'Circle Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar.layout-style-circle .card-circle svg circle.thiscir' => 'stroke: {{VALUE}};',
				],
				'condition' => [
					'layout' => 'circle'
				]
			]
		);
		$this->add_control(
			'rs_area_title_bg_color',
			[
				'label' => esc_html__( 'Title Background', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar.style2 .skillbar .skillbar-title' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'rs_progress_bar_style' => 'style2',
				],
			]
		);
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'rs_bar_bg_animate_color',
                'label' => esc_html__( 'Background', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .rs-skill-bar .skillbar .skillbar-bar',
				'condition' => [
					'layout!' => 'circle'
				]
            ]
        );
		$this->add_control(
			'rs_area_bar_bg_color',
			[
				'label' => esc_html__( 'Gray Area Background Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'layout!' => 'circle'
				]
			]
		);
		$this->add_control(
			'rs_pers_color',
			[
				'label' => esc_html__( 'Percentage Color', 'rsaddon' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent' => 'color: {{VALUE}};',
				],
				'condition' => [
					'layout!' => 'circle'
				]
			]
		);
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'rs_pers_gradiant_color',
                'label' => esc_html__( 'Percentage Gradiant Color', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
				'condition'=>[
					'gradient_option'=>'gradiant_color',
				],
                'selector' => '{{WRAPPER}} .rs-skill-bar .skillbar .skill-bar-percent',
				'condition' => [
					'layout!' => 'circle'
				]
            ]
        );

		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$unique = rand(153546 , 4465454);

		$this->add_inline_editing_attributes( 'rs_progress_inner_text', 'basic' );
        $this->add_render_attribute( 'rs_progress_inner_text', 'class', 'skillbar-title' );
		if ('circle' == $settings['layout']) {
			$gradient = '';
		} else {
			$gradient = esc_html($settings['gradient_option']);
		}?>

		<div class="rs-skill-bar <?php echo esc_html($settings['rs_linear_bar_style']); ?>  <?php echo esc_html($settings['rs_progress_bar_style']); ?> <?php echo $gradient; ?>"> 
			<div class="skillbar layout-style-<?php echo esc_attr( $settings['layout'] )?>" data-percent="<?php echo esc_attr( $settings['percent']['size'] ) ?>"> 
				<?php if('circle' == $settings['layout']) {?>
					<div class="card-circle">
						<svg>
							<circle cx="50" cy="50" r="47"></circle>
							<circle class="thiscir" cx="50" cy="50" r="47"></circle>
						</svg>
						<?php if($settings['display_percentage'] == 'yes') {?>
							<span class="skill-bar-percent"></span> 
						<?php } ?>
					</div>
					<?php if('yes' === $settings['show_progress_inner_text']) { ?>
						<div <?php echo wp_kses_post( $this->get_render_attribute_string( 'rs_progress_inner_text' ) ); ?>><?php echo esc_html($settings['rs_progress_inner_text']); ?></div>
					<?php } ?>
				<?php } else { ?>
					<?php if('yes' === $settings['show_progress_inner_text']) { ?>
						<span <?php echo wp_kses_post( $this->get_render_attribute_string( 'rs_progress_inner_text' ) ); ?>><?php echo esc_html($settings['rs_progress_inner_text']); ?></span>
					<?php } ?>

					<p class="skillbar-bar style-<?php echo esc_attr($settings['layout']) ?>">
						<?php if($settings['rs_progress_bar_style'] == 'style3'):?>
							<?php if($settings['display_percentage'] == 'yes') {?>
								<span class="skill-bar-percent <?php echo esc_html($settings['percent_tooltip_style']); ?>"></span> 
							<?php } ?>
						<?php endif;  ?>
					</p>
					<?php if($settings['rs_progress_bar_style'] == 'style1' || $settings['rs_progress_bar_style'] == 'style2'){?>
						<?php if($settings['display_percentage'] == 'yes') {?>
							<span class="skill-bar-percent"></span> 
						<?php } ?>
					<?php }  ?>
				<?php } ?>
        	</div>
        </div>
        <script type="text/javascript">
			jQuery(function($){ 
				$('.skillbar').skillBars({  
					from: 0,
					speed: 4000,
					interval: 100,  
					decimals: 0,    
				});
			});
		</script>

		<?php
	}
}
