<?php
/**
 * Elementor rsgallery Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;


defined('ABSPATH') || die();

class Rsaddon_Service_Expand_Effect_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve rsgallery widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'rs-service-expand-effect';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve rsgallery widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('RS Services Expand', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve rsgallery widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the rsgallery widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}

	/**
	 * Register rsgallery widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_responsive_control(
				'item_height',
				[
					'label' => esc_html__('Item Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['px'],
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'min-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'button_show_hide',
				[
					'label' => esc_html__('Button Show/Hide', 'rsaddon'),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__('Show', 'rsaddon'),
					'label_off' => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'btn__selected_icon',
				[
					'label' => __('Icon', 'rsaddon'),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-chevron-right',
						'library' => 'fa-solid',
					],
					'condition' => ['button_show_hide' => 'yes']
				]
			);
			$this->add_control(
				'btn_text',
				[
					'label' => esc_html__( 'Button Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Learn More', 'rsaddon' ),
					'placeholder' => esc_html__( 'Button text here', 'rsaddon' ),
					'condition' => ['button_show_hide' => 'yes']
				]
			);
			$repeater = new Repeater();
				$repeater->add_control(
					'link',
					[
						'label'       => esc_html__('Link', 'rsaddon'),
						'type'        => Controls_Manager::URL,
						'label_block' => true,
						'default' => [
							'url' => '#',
						]
					]
				);
				$repeater->add_control(
					'feature_img',
					[
						'label' => esc_html__('Feature Image Bg', 'rsaddon'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);
				$repeater->add_control(
					'title',
					[
						'label'       => esc_html__('Title', 'rsaddon'),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Services Title',
						'placeholder' => esc_html__('Services Title', 'rsaddon'),
						'separator'   => 'before',
					]
				);
				$repeater->add_control(
					'description',
					[
						'label' => esc_html__('Description', 'rsaddon'),
						'type' => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default' => esc_html__('Quisque placerat vitae lacus ut scelerisque. Fusce luctus odio ac nibh luctus, in porttitor theo lacus egestas. Dummy text generator.', 'rsaddon'),
						'separator' => 'before',
					]
				);
				$repeater->add_control(
					'active_item',
					[
						'label'        => esc_html__('Active this item', 'rsaddon'),
						'type'         => Controls_Manager::SWITCHER,
						'label_on'     => esc_html__('Yes', 'rsaddon'),
						'label_off'    => esc_html__('No', 'rsaddon'),
						'return_value' => 'yes',
						'default'      => 'no',
					]
				);
			$this->add_control(
				'services_list',
				[
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'show_label' => false,
					'default' => [
						[
							'title' => esc_html__( 'Service One', 'rsaddon' ),
							'active_item' => 'no'
						],
						[
							'title' => esc_html__( 'Service Two', 'rsaddon' ),
							'active_item' => 'no'
						],
						[
							'title' => esc_html__( 'Service Three', 'rsaddon' ),
							'active_item' => 'yes'
						],
						[
							'title' => esc_html__( 'Service Three', 'rsaddon' ),
							'active_item' => 'no'
						]
					],
					'title_field' => '{{{ title }}}',
				]
			);
		$this->end_controls_section();

		$this->start_controls_section(
			'content_grid_control_section',
			[
				'label' => esc_html__('Grid Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'column_lg',
				[
					'label'   => esc_html__('Column LG Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '3',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);
			$this->add_control(
				'column_md',
				[
					'label'   => esc_html__('Column MD Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);
			$this->add_control(
				'column_sm',
				[
					'label'   => esc_html__('Column SM Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);

			$this->add_responsive_control(
				'column_padding',
				[
					'label' => esc_html__( 'Column Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'column_margin',
				[
					'label' => esc_html__( 'Column Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();

		// Global Style
		$this->start_controls_section(
			'g_style_service',
			[
				'label' => esc_html__('Global Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'g_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'g_style_tabs'
			);
				$this->start_controls_tab(
					'g_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_background',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);

					$this->add_control(
						'last_child_options',
						[
							'label' => esc_html__( 'Last Child Options', 'rsaddon' ),
							'type' => Controls_Manager::HEADING,
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border_lastchild',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item:last-child .service-inner',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'g_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_background_active',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner',
						]
					);
					$this->add_control(
						'g_border_color_active',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow_active',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();

		// Title Style
		$this->start_controls_section(
			'_title_style',
			[
				'label' => esc_html__('Title Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title',
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => esc_html__('Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'title_color_active',
				[
					'label' => esc_html__('Color (Active)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .title a' => 'color: {{VALUE}};',
					]
				]

			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();

		// Description Style
		$this->start_controls_section(
			'_description_style',
			[
				'label' => esc_html__('Description Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc',
				]
			);
			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__('Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'desc_color_active',
				[
					'label' => esc_html__('Color (Active)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .desc' => 'color: {{VALUE}};',
					]
				]

			);
			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_height_normal',
				[
					'label' => esc_html__( 'Height (Normal)', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_height_active',
				[
					'label' => esc_html__( 'Height (Active)', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .desc' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();

		// Button Style
		$this->start_controls_section(
			'_button_style',
			[
				'label' => esc_html__('Button Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'icon_reverse',
				[
					'label' => esc_html__( 'Icon Position', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Right', 'rsaddon' ),
							'icon' => 'eicon-nowrap',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Left', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						]
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'flex-direction: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'btn_icon_text_gap_between',
				[
					'label' => esc_html__( 'Gap Between', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'gap: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'btn_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn',
				]
			);
			$this->add_responsive_control(
				'btn_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_padding',
				[
					'label' => esc_html__('Padding', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_border_radius',
				[
					'label' => esc_html__('Border Radius', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_width',
				[
					'label' => esc_html__( 'Button Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'button_style_tabs'
			);
				$this->start_controls_tab(
					'button_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'btn_color',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'color: {{VALUE}};',
							],
						]
					);
					$this->add_control(
						'btn_icon_color',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn svg path' => 'fill: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_background',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'btn_border',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'button_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
					]
				);
					$this->add_control(
						'btn_color_active',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn' => 'color: {{VALUE}};',
							]
						]
		
					);
					$this->add_control(
						'btn_icon_color_active',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn svg path' => 'fill: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_background_active',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn',
						]
					);
					$this->add_control(
						'btn_border_color_active',
						[
							'label' => esc_html__('Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn' => 'border-color: {{VALUE}};',
							]
						]
		
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	/**
	 * Render rsgallery widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{

		$settings = $this->get_settings_for_display();
		$unique = rand(54543455, 987484);
		$counter = 0;
		$thumb_counter = 0;
		$active_item = '';
	?>
		<div class="rs-service-flex service-parent-<?php echo $unique; ?>">
			<!-- Background Part Start -->
			<?php foreach ($settings['services_list'] as $index => $item) :
				$alt_text = get_post_meta($item['feature_img']['id'], '_wp_attachment_image_alt', true);
				$alt_text = ($alt_text) ? $alt_text : $item['title'];
				$image = wp_get_attachment_image_url( $item['feature_img']['id'], 'full');
				if ( ! $image ) {
					$image = Utils::get_placeholder_image_src();
				}
				$thumb_counter++;
				$active_item = $item['active_item'];
			?>
				<img class="<?php echo $thumb_counter ?> <?php echo ($active_item == 'yes') ? 'active' : ''; ?>" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr($alt_text); ?>">
			<?php endforeach; ?>
			<!-- Background Part End -->

			<!-- Content Part Start -->
			<div class="service-<?php echo $unique; ?> row">
				<?php foreach ($settings['services_list'] as $index => $item) :
					$link = !empty($item['link']['url']) ? $item['link']['url'] : '#';
					$target = $item['link']['is_external'] ? 'target=_blank' : '';
					$image = wp_get_attachment_image_url( $item['feature_img']['id'], 'full');
					if ( ! $image ) {
						$image = Utils::get_placeholder_image_src();
					}
					$counter++;
					$active_item = $item['active_item'];
				?>
					<div class="grid-item item-<?php echo $counter ?> <?php echo ($active_item == 'yes') ? 'active' : ''; ?> col-lg-<?php echo esc_html($settings['column_lg']); ?> col-md-<?php echo esc_html($settings['column_md']); ?> col-sm-<?php echo esc_html($settings['column_sm']); ?>">
						<div class="service-inner">
							<?php if(!empty($item['title'])) {?>
								<h3 class="title"><a href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>><?php echo esc_html($item['title']); ?></a></h3>
							<?php } ?>
							<?php if(!empty($item['description'])) {?>
								<div class="desc">
									<?php echo esc_html($item['description']); ?>
								</div>
							<?php } ?>
							<?php if ('yes' == $settings['button_show_hide']) { ?>
								<div class="btn-part">
									<a class="service-btn" href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>>
										<?php if(!empty($settings['btn_text'])) {?>
											<span><?php echo esc_html($settings['btn_text']); ?></span>
										<?php }
											Icons_Manager::render_icon($settings['btn__selected_icon'], ['aria-hidden' => 'true']);
										?>
									</a>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<!-- Content Part End -->
		</div>
		<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('.service-<?php echo $unique; ?> .grid-item').mouseenter(function(){
					var $backgrounds = $('.service-parent-<?php echo $unique; ?> img');
					var $items = $('.service-<?php echo $unique; ?> .grid-item');

					$backgrounds.removeClass('active');
					$items.removeClass('active');

					var classes = $(this).attr('class');
					var number = classes.split(' ').filter(function(className) {
						return className.startsWith('item-');
					})[0].split('-').pop();

					$backgrounds.eq(number - 1).addClass('active');
					$(this).addClass('active');
				});
			});
		</script>

<?php
	}
} ?>