<?php
/**
 *
 * @since 1.0.0
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Css_Filter;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class Rsaddon_Elementor_pro_RSservices_List_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'rs-service-list';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('RS Services List', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}
	/**
	 * Register services widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		$post_dropdown[0] = 'Select Post';
        $custom_query = new wp_Query(array(
            'post_type'      => 'services',
            'posts_per_page' => '-1',                                         
        )); 

        if ( $custom_query->have_posts() ):
            while($custom_query->have_posts()): $custom_query->the_post();       
                $id    = get_the_ID($custom_query->ID);
                $title = get_the_title($custom_query->ID);
                $post_dropdown[$id] = $title;
            endwhile;
            wp_reset_query(); 
        endif;

		// Service Global Card Start
		$this->start_controls_section(
			'section_services',
			[
				'label' => esc_html__('Services Global', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'style',
				[
					'label' => esc_html__( 'Select Style', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '1',
					'options' => [
						'1' => esc_html__( 'Style 1', 'rsaddon' ),
						'2' => esc_html__( 'Style 2', 'rsaddon' ),
						'3' => esc_html__( 'Style 3', 'rsaddon' ),
					]
				]
			);
			$this->add_control(
				'source',
				[
					'label' => esc_html__( 'Source', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'repeater',
					'options' => [
						'repeater' => esc_html__( 'Repeater', 'rsaddon' ),
						'dynamic' => esc_html__( 'Dynamic', 'rsaddon' )
					],
					'condition' => [
						'style' => '3'
					]
				]
			);

			$this->add_control(
				'show_btn',
				[
					'label'        => esc_html__('Show Button', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Show', 'rsaddon'),
					'label_off'    => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			$this->add_control(
				'show_title_icon',
				[
					'label'        => esc_html__('Show Title Icon', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Show', 'rsaddon'),
					'label_off'    => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'source!' => 'dynamic'
					]
				]
			);
			$this->add_control(
				'show_count_number',
				[
					'label'        => esc_html__('Show Count Number', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Show', 'rsaddon'),
					'label_off'    => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'scrollable',
				[
					'label'        => esc_html__('Scrollable', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Yes', 'rsaddon'),
					'label_off'    => esc_html__('No', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'gsap_fixed',
				[
					'label'        => esc_html__('GSAP Fix Scrolling', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Yes', 'rsaddon'),
					'label_off'    => esc_html__('No', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'feature_image_as_background',
				[
					'label' => esc_html__( 'Feature Image As', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'flot' => esc_html__( 'Float', 'rsaddon' ),
						'bg'  => esc_html__( 'Background', 'rsaddon' ),
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'active_item_style',
				[
					'label'        => esc_html__('Active Style', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Yes', 'rsaddon'),
					'label_off'    => esc_html__('No', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition' => [
						'feature_image_as_background' => 'bg',
						'style!' => '3'
					],
				]
			);
			$this->add_control(
				'btn_icon',
				[
					'label' => __('Button Icon', 'rsaddon'),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-chevron-right',
						'library' => 'fa-solid',
					],
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name' => 'thumbnail',
					'default' => 'full',
					'separator' => 'before',
					'exclude' => [
						'custom'
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->start_controls_tabs(
				'services_list_tabs_array',
				[
					'condition'    => [
						'style!' => '3'
					]
				]
			);
				$this->start_controls_tab(
					'services_list_tabs',
					[
						'label' => esc_html__( 'Repeater Content', 'rsaddon' ),
					]
				);
					$repeater = new Repeater();
					$repeater->add_control(
						'link',
						[
							'label'       => esc_html__('Link', 'rsaddon'),
							'type'        => Controls_Manager::URL,
							'label_block' => true,
							'default' => [
								'url' => '#',
							]
						]
					);
					$repeater->add_control(
						'feature_img',
						[
							'label' => esc_html__('Feature Image', 'rsaddon'),
							'type' => Controls_Manager::MEDIA,
							'default' => [
								'url' => Utils::get_placeholder_image_src(),
							]
						]
					);
					$repeater->add_control(
						'service_icon',
						[
							'label' => __('Icon', 'rsaddon'),
							'type' => Controls_Manager::ICONS,
							'default' => [
								'value' => 'far fa-smile',
								'library' => 'fa-ragular',
							]
						]
					);
					$repeater->add_control(
						'title',
						[
							'label'       => esc_html__('Title', 'rsaddon'),
							'type'        => Controls_Manager::TEXT,
							'label_block' => true,
							'default'     => 'Services Title',
							'placeholder' => esc_html__('Services Title', 'rsaddon'),
							'separator'   => 'before',
						]
					);
					$repeater->add_control(
						'subinfo',
						[
							'label'       => esc_html__('Sub Info', 'rsaddon'),
							'type'        => Controls_Manager::TEXT,
							'label_block' => true,
							'default'     => 'August 2, 2024 | Vacaville, CA, US',
							'placeholder' => esc_html__('Sub Info Text', 'rsaddon'),
							'separator'   => 'before'
						]
					);
					$repeater->add_control(
						'description',
						[
							'label' => esc_html__('Description', 'rsaddon'),
							'type' => Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__('Quisque placerat vitae lacus ut scelerisque. Fusce luctus odio ac nibh luctus, in porttitor theo lacus egestas. Dummy text generator.', 'rsaddon'),
							'separator' => 'before'
						]
					);
					$repeater->add_control(
						'active_item',
						[
							'label'        => esc_html__('Active this item', 'rsaddon'),
							'type'         => Controls_Manager::SWITCHER,
							'label_on'     => esc_html__('Yes', 'rsaddon'),
							'label_off'    => esc_html__('No', 'rsaddon'),
							'return_value' => 'yes',
							'default'      => 'no'
						]
					);
				$this->add_control(
					'services_list',
					[
						'type' => Controls_Manager::REPEATER,
						'fields' => $repeater->get_controls(),
						'show_label' => false,
						'default' => [
							[
								'title' => esc_html__( 'Service One', 'rsaddon' ),
							],
							[
								'title' => esc_html__( 'Service Two', 'rsaddon' ),
							]
						],
						'title_field' => '{{{ title }}}',
					]
				);
				$this->end_controls_tab();
			$this->end_controls_tabs();

			// Style Three Repeater Content
			$this->start_controls_tabs(
				'services_list_tabs_array_style3',
				[
					'condition'    => [
						'style' => '3',
						'source' => 'repeater'
					]
				]
			);
				$this->start_controls_tab(
					'services_list_tabs_style3',
					[
						'label' => esc_html__( 'Repeater Content', 'rsaddon' ),
					]
				);
					$repeater = new Repeater();
					$repeater->add_control(
						'link_style3',
						[
							'label'       => esc_html__('Link', 'rsaddon'),
							'type'        => Controls_Manager::URL,
							'label_block' => true,
							'default' => [
								'url' => '#',
							]
						]
					);
					$repeater->add_control(
						'title_style3',
						[
							'label'       => esc_html__('Title', 'rsaddon'),
							'type'        => Controls_Manager::TEXT,
							'label_block' => true,
							'default'     => 'Services Title',
							'placeholder' => esc_html__('Services Title', 'rsaddon'),
							'separator'   => 'before',
						]
					);
					$repeater->add_control(
						'service_icon_style3',
						[
							'label' => __('Icon', 'rsaddon'),
							'type' => Controls_Manager::ICONS,
							'default' => [
								'value' => 'far fa-smile',
								'library' => 'fa-ragular',
							]
						]
					);
					$this->add_control(
						'services_list_style3',
						[
							'type' => Controls_Manager::REPEATER,
							'fields' => $repeater->get_controls(),
							'show_label' => false,
							'default' => [
								[
									'title_style3' => esc_html__( 'Service One', 'rsaddon' ),
								],
								[
									'title_style3' => esc_html__( 'Service Two', 'rsaddon' ),
								]
							],
							'title_field' => '{{{ title_style3 }}}',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();

			$this->add_control(
				'animate_border',
				[
					'label'        => esc_html__('Animate Border', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Yes', 'rsaddon'),
					'label_off'    => esc_html__('No', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'no',
					'separator' => 'before',
					'condition' => [
						'style' => '3'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'animate_border_color',
					'types' => [ 'classic', 'gradient'],
					'selector' => '{{WRAPPER}} .rs-service-list.animate-border .services-inner:after',
					'condition' => [
						'style' => '3',
						'animate_border' => 'yes',
					],
				]
			);
			$this->add_responsive_control(
				'animate_border_height',
				[
					'label' => esc_html__( 'Border Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.animate-border .services-inner:after' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'style' => '3',
						'animate_border' => 'yes',
					],
				]
			);

			// Query Options
			$this->add_control(
				'post_query_options',
				[
					'label' => esc_html__( 'Query Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [
						'style' => '3',
						'source' => 'dynamic',
					]
				]
			);
			$this->add_control(
				'selection_type',
				[
					'label' => esc_html__( 'Select posts by:', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'category',
					'options' => [
						'manual'       => esc_html__( 'Selected Post', 'rsaddon' ),
						'category'        => esc_html__( 'Category Post', 'rsaddon' ),
					],
					'condition' => [
						'style' => '3',
						'source' => 'dynamic'
					]
				]
			);
			$this->add_control(
				'categories',
				[
					'label'   => esc_html__( 'Category', 'rsaddon' ),
					'type'    => Controls_Manager::SELECT2,	
					'default' => 0,			
					'options' => $this->getCategories(),
					'multiple' => true,
					'condition' => [
						'style' => '3',
						'source' => 'dynamic',
						'selection_type' => 'category'
					]
				]
			);
			$this->add_control(
				'select_posts',
				[
					'label'   => esc_html__( 'Select Posts', 'rsaddon' ),
					'type'    => Controls_Manager::SELECT2, 
					'default' => 0,         
					'options' => [      
							
					]+ $post_dropdown,
					'multiple' => true,
					'condition' => [
						'style' => '3',
						'source' => 'dynamic',
						'selection_type' => 'manual'
					],      
				]
			);
			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'DESC'  => esc_html__( 'Descending', 'rsaddon' ),
						'ASC'  => esc_html__( 'Ascending', 'rsaddon' )
					],
					'condition' => [
						'style' => '3',
						'source' => 'dynamic'
					]
				]
			);
			$this->add_control(
				'per_page',
				[
					'label' => esc_html__( 'Post Per Page', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( '-1', 'rsaddon' ),
					'condition' => [
						'style' => '3',
						'source' => 'dynamic'
					]
				]
			);
			$this->add_control(
                'posts_offset',
                [
                    'label'     => esc_html__( 'Offset', 'rsaddon' ),
                    'type'      => Controls_Manager::NUMBER,
                    'min'       => 0,
                    'max'       => 20,
					'condition' => [
						'style' => '3',
						'source' => 'dynamic',
					]
                ]
            );

			// Grid Options
			$this->add_control(
				'grid_options',
				[
					'label' => esc_html__( 'Grid Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_control(
				'grid_col_lg',
				[
					'label'   => esc_html__('Large Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '3',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_control(
				'grid_col_md',
				[
					'label'   => esc_html__('Medium Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '4',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_control(
				'grid_col_sm',
				[
					'label'   => esc_html__('Small Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_control(
				'grid_col_xs',
				[
					'label'   => esc_html__('Extra Small Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '12',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_responsive_control(
				'col_item_gap_between',
				[
					'label' => esc_html__( 'Column Gap', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.style-3 .row' => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-list.style-3 .row>*' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
			$this->add_responsive_control(
				'col_item_bottom_gap',
				[
					'label' => esc_html__( 'Column Bottom Gap', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.style-3 .row>*' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'style' => '3'
					]
				]
			);
		$this->end_controls_section();
		// Service Global End

		// Service Global Style Start
        $this->start_controls_section(
			'_section_global_style',
			[
				'label' => esc_html__('General Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'g_v_align',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner' => 'align-items: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_column_align',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner' => 'flex-direction: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
                'g_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
			$this->add_responsive_control(
                'g_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_min_height',
                [
                    'label' => esc_html__( 'Min Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner' => 'min-height: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );

			$this->add_responsive_control(
				'g_overflow',
				[
					'label' => esc_html__( 'Overflow', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'hidden' => esc_html__( 'Hidden', 'rsaddon' ),
						'visible'  => esc_html__( 'Visible', 'rsaddon' )
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner' => 'overflow: {{VALUE}};',
					],
				]
			);

			// Global Hover Normal Tab Start
			$this->start_controls_tabs( 'g_hover_normal_tabs' );
                $this->start_controls_tab(
                    'g_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_background',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner',
						]
					);
					$this->add_control(
                        'g_border_color_last_child',
                        [
                            'label' => esc_html__( 'Border Color ( Last Child )', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-service-list .services-inner:last-child' => 'border-color: {{VALUE}} !important;',
                            ],
                        ]
                    );
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner',
						]
					);
				$this->end_controls_tab();
        
                $this->start_controls_tab(
                    'g_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'g_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-service-list .services-inner:hover',
                        ]
                    );
                    $this->add_control(
                        'g_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-service-list .services-inner:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'g_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-service-list .services-inner:hover',
                        ]
                    );
                $this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Service Global Style End

		// Scroll Enable Style Start
        $this->start_controls_section(
			'_section_scrollable_style',
			[
				'label' => esc_html__('Scrollable Options', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'scrollable' => 'yes'
				]
			]
		);
			$this->add_responsive_control(
				'scrollable_visible_height',
				[
					'label' => esc_html__( 'Visible Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'scrollbar_gap_right',
				[
					'label' => esc_html__( 'Right Gap', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			// Track
			$this->add_control(
				'scrollable_scrollbar_track',
				[
					'label' => esc_html__( 'Scrollbar Track', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'scrollable_scrollbar_track_color',
				[
					'label' => esc_html__( 'Track Bg', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar-track' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'scrollable_scrollbar_track_width',
				[
					'label' => esc_html__( 'Track Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control (
				'scrollable_scrollbar_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar,
						{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar-track,
						{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			// Thumb
			$this->add_control(
				'scrollable_scrollthumb',
				[
					'label' => esc_html__( 'Scroll Thumb', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'scrollable_scrollthumb_color',
				[
					'label' => esc_html__( 'Thumb Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list.scrollable-yes::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
					],
				]
			);
		$this->end_controls_section();
		// Scroll Enable Style End

		// Feature Image Style Start
        $this->start_controls_section(
			'_section_image_style',
			[
				'label' => esc_html__('Feature Image Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'    => [
					'style!' => '3'
				]
			]
		);
			$this->add_responsive_control(
				'image_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
					],
				]
			);
			$this->add_responsive_control(
				'image_height',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img img' => 'height: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_control(
                'img_wrapper_control',
                [
                    'label' => esc_html__( 'Wrapper Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
			$this->add_responsive_control(
				'img_wrapper_opacity',
				[
					'label' => esc_html__('Opacity', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'opacity: {{SIZE}}',
					]
				]
			);
			$this->add_responsive_control(
				'img_wrapper_opacity_hover',
				[
					'label' => esc_html__('Opacity ( Hover )', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner:hover .feature_img' => 'opacity: {{SIZE}}',
					]
				]
			);
			$this->add_responsive_control(
				'img_wrapper_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'width: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'img_wrapper_position_right',
				[
					'label' => esc_html__( 'Right Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
					],
				]
			);
			$this->add_responsive_control(
				'img_wrapper_position_left',
				[
					'label' => esc_html__( 'Left Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;',
					],
				]
			);
			$this->add_responsive_control(
				'img_wrapper_position_top',
				[
					'label' => esc_html__( 'Top Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
					],
				]
			);
			$this->add_responsive_control(
				'img_wrapper_position_bottom',
				[
					'label' => esc_html__( 'Bottom Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .feature_img' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
					],
				]
			);
			$this->add_responsive_control(
                'img_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .feature_img img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
			$this->add_responsive_control(
                'img_wrapper_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .feature_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
			$this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'img_wrapper_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-service-list .services-inner .feature_img img',
                ]
            );
			$this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'img_wrapper_border',
                    'selector' => '{{WRAPPER}} .rs-service-list .services-inner .feature_img img',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'img_wrapper_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-service-list .services-inner .feature_img img',
                ]
            );
		$this->end_controls_section();
		// Feature Image Style End

		// Count Number Style Start
		$this->start_controls_section(
            'section_style_count_number',
            [
                'label' => esc_html__( 'Count Number Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_count_number' => 'yes',
					'style!' => '3'
				]
            ]
        );
            $this->add_responsive_control(
                'count_number_text_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .services-inner .count_number' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'count_number_typography',
                    'selector' => '{{WRAPPER}} .services-inner .count_number',
                ]
            );
			$this->add_group_control(
				Group_Control_Text_Stroke::get_type(),
				[
					'name' => 'count_number_text_stroke',
					'selector' => '{{WRAPPER}} .services-inner .count_number',
				]
			);
            $this->add_responsive_control(
                'count_number_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .services-inner .count_number' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'count_number_padding',
                [
                    'label' => esc_html__('Padding', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .services-inner .count_number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'count_number_margin',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .services-inner .count_number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'count_number_radius',
                [
                    'label' => esc_html__('Border Radius', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .services-inner .count_number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Position Maker
            $this->add_control(
                'count_number_position_maker_options',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'count_number_position_popover_toggle',
                [
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Position', 'rsaddon' ),
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'return_value' => 'yes',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'count_number_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'unset' => esc_html__( 'Unset', 'rsaddon' ),
                            'relative' => esc_html__( 'Relative', 'rsaddon' ),
                            'absolute'  => esc_html__( 'Absolute', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'count_number_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'count_number_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'count_number_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'count_number_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'count_number_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'count_number_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'count_number_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'count_number_position' => ['relative', 'absolute']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
			
			$this->add_control(
				'hr',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);

			$this->start_controls_tabs('count_number_hover_normal_tabs');
                $this->start_controls_tab(
                    'count_number_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'count_number_text_color',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner .count_number' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'count_number_background',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .count_number',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'count_number_border',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .count_number',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'count_number_box_shadow',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .count_number',
						]
					);
				$this->end_controls_tab();

				// Hover
                $this->start_controls_tab(
                    'count_number_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'count_number_text_color_hover',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .count_number, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .count_number' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'count_number_background_hover',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner:hover .count_number, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .count_number',
						]
					);
					$this->add_control(
						'count_number_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .count_number, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .count_number' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_control(
						'count_number_stroke_color_hover',
						[
							'label' => esc_html__( 'Stroke Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .count_number, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .count_number' => '-webkit-text-stroke-color: {{VALUE}}; text-stroke-color: {{VALUE}};',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
			
        $this->end_controls_section();
		// Count Number Style End

		// Title & Icon Wrapper Style Start
        $this->start_controls_section(
			'_section_title_icon_wrapper_style',
			[
				'label' => esc_html__('Title & Icon Wrapper Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'icon_title_weapper_options_heading',
				[
					'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
				]
			);
			$this->add_responsive_control(
				'title_icon_wrapper_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .top-wrapper' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_icon_wrapper_v_align',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .top-wrapper' => 'align-items: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_icon_wrapper_column_align',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .top-wrapper' => 'flex-direction: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_icon_wrapper_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .top-wrapper' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
                'title_icon_wrapper_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .top-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

			// Title
			$this->add_control(
				'title_options_heading',
				[
					'label' => esc_html__( 'Title Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .rs-service-list .services-inner .title',
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Title Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_color_hover',
				[
					'label' => esc_html__( 'Title Color ( Hover )', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner:hover .title, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			// Subinfo
			$this->add_control(
				'subinfo_options_heading',
				[
					'label' => esc_html__( 'Subinfo Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'subinfo_typography',
					'selector' => '{{WRAPPER}} .rs-service-list .services-inner .subinfo',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'subinfo_color',
				[
					'label' => esc_html__( 'Subinfo Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .subinfo' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'subinfo_color_hover',
				[
					'label' => esc_html__( 'Subinfo Color ( Hover )', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner:hover .subinfo, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .subinfo' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_responsive_control(
				'subinfo_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .subinfo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
				
			// Icon
			$this->add_control(
				'icon_options_heading',
				[
					'label' => esc_html__( 'Icon Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'icon_font_size',
				[
					'label' => esc_html__( 'Font Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_width',
				[
					'label' => esc_html__( 'Wrapper Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_height',
				[
					'label' => esc_html__( 'Wrapper Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
                'icon_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ],
					'condition' => [
						'show_title_icon' => 'yes'
					]
                ]
            );
			$this->add_responsive_control(
                'icon_wrapper_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ],
					'condition' => [
						'show_title_icon' => 'yes'
					]
                ]
            );
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_wrapper_box_shadow',
					'selector' => '{{WRAPPER}} .rs-service-list .services-inner .icon-wrap',
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
			// Icon Hover Normal Tab
			$this->start_controls_tabs( 
				'icon_hover_normal_tabs',
				[
					'condition' => [
						'show_title_icon' => 'yes'
					]
				]
			);
                $this->start_controls_tab(
                    'icon_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap svg path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .rs-service-list .services-inner .icon-wrap i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_wrapper_background',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .icon-wrap',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'icon_wrapper_border',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .icon-wrap',
						]
					);
				$this->end_controls_tab();
				// Hover
                $this->start_controls_tab(
                    'icon_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'icon_color_hover',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .icon-wrap svg path, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .icon-wrap svg pathZ' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .rs-service-list .services-inner:hover .icon-wrap i, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .icon-wrap i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_wrapper_background_hover',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner:hover .icon-wrap, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .icon-wrap',
						]
					);
					$this->add_control(
						'icon_wrapper_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .icon-wrap, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .icon-wrap' => 'border-color: {{VALUE}}',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Title & Icon Wrapper Style End

		// Description & Button Wrapper Style Start
        $this->start_controls_section(
			'_section_desc_btn_wrapper_style',
			[
				'label' => esc_html__('Desc & Button Wrapper Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_control(
				'desc_btn_weapper_options_heading',
				[
					'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
				]
			);
			$this->add_responsive_control(
				'desc_btn_wrapper_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .bottom-wrapper' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_btn_wrapper_v_align',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .bottom-wrapper' => 'align-items: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_btn_wrapper_column_align',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .bottom-wrapper' => 'flex-direction: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_btn_wrapper_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .bottom-wrapper' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
                'desc_btn_wrapper_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .bottom-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

			// Description
			$this->add_control(
				'desc_options_heading',
				[
					'label' => esc_html__( 'Description Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .rs-service-list .services-inner .desc-text',
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Description Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .desc-text' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'desc_color_hover',
				[
					'label' => esc_html__( 'Description Color ( Hover )', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner:hover .desc-text, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .desc-text' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'desc_span_color',
				[
					'label' => esc_html__( 'Desc <span> Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .desc-text span' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);
			$this->add_control(
				'desc_span_color_hover',
				[
					'label' => esc_html__( 'Desc <span> Color ( Hover )', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner:hover .desc-text span,
						{{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .desc-text span' => 'color: {{VALUE}}',
					],
					'condition'    => [
						'style!' => '3'
					]
				]
			);

			// Button
			$this->add_control(
				'btn_options_heading',
				[
					'label' => esc_html__( 'Button Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'btn_icon_font_size',
				[
					'label' => esc_html__( 'Font Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .btn-part svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-list .services-inner .btn-part i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'btn_wrapper_width',
				[
					'label' => esc_html__( 'Wrapper Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .btn-part' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'btn_wrapper_height',
				[
					'label' => esc_html__( 'Wrapper Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-list .services-inner .btn-part' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
                'btn_wrapper_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-list .services-inner .btn-part' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ],
					'condition' => [
						'show_btn' => 'yes'
					]
                ]
            );
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'btn_wrapper_box_shadow',
					'selector' => '{{WRAPPER}} .rs-service-list .services-inner .btn-part',
					'condition' => [
						'show_btn' => 'yes'
					]
				]
			);
			// Icon Hover Normal Tab
			$this->start_controls_tabs(
				'btn_hover_normal_tabs',
				[
					'condition' => [
						'show_btn' => 'yes'
					],
				]
			);
                $this->start_controls_tab(
                    'btn_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'btn_icon_color',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner .btn-part svg path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .rs-service-list .services-inner .btn-part i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_wrapper_background',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .btn-part',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'btn_wrapper_border',
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner .btn-part',
						]
					);
				$this->end_controls_tab();
				// Hover
                $this->start_controls_tab(
                    'btn_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
					$this->add_control(
						'btn_icon_color_hover',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .btn-part svg path, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .btn-part svg path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .rs-service-list .services-inner:hover .btn-part i, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .btn-part i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_wrapper_background_hover',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-list .services-inner:hover .btn-part, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .btn-part',
						]
					);
					$this->add_control(
						'btn_wrapper_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-list .services-inner:hover .btn-part, {{WRAPPER}} .rs-service-list.thumb-bg .services-inner.active .btn-part' => 'border-color: {{VALUE}}',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tab();
		$this->end_controls_section();
		// Description & Button Wrapper Style End
	}

	/**
	 * Render counter widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	/**
	 * Render counter widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$unique = rand(2012, 3554120);
		$count = 0;
		$active_item = '';
		$preventSmoothScroll = ('yes' === $settings['scrollable']) ? 'data-lenis-prevent' : '';
	?>
		<?php if ('3' == $settings['style']) {
			$grid_col_lg = 'col-lg-' . $settings['grid_col_lg'];
			$grid_col_md = 'col-md-' . $settings['grid_col_md'];
			$grid_col_sm = 'col-sm-' . $settings['grid_col_sm'];
			$grid_col_xs = 'col-' . $settings['grid_col_xs'];
			$columns_grid = $grid_col_lg . ' ' . $grid_col_md . ' ' . $grid_col_sm . ' ' . $grid_col_xs;
			$animateBorder = ('yes' == $settings['animate_border']) ? 'animate-border' : ''; ?>
			<div class="rs-service-list style-<?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['source']); ?> <?php echo esc_attr($animateBorder) ?>">
				<div class="row">
					<?php if('repeater' == $settings['source']){
							foreach ($settings['services_list_style3'] as $index => $item) :
							$link = !empty($item['link_style3']['url']) ? $item['link_style3']['url'] : '#';
							$target = $item['link_style3']['is_external'] ? 'target=_blank' : '';
						?>
							<div class="<?php echo esc_attr($columns_grid); ?>">
								<a class="services-inner" href="<?php echo esc_url($item['link_style3']['url']); ?>" <?php echo esc_attr($target); ?>>
									<div class="top-wrapper">
										<?php if ('yes' == $settings['show_title_icon']) { ?>
											<div class="icon-wrap">
												<?php Icons_Manager::render_icon($item['service_icon_style3'], ['aria-hidden' => 'true']) ?>
											</div>
										<?php }
										if (!empty($item['title_style3'])) { ?>
											<h4 class="title">
												<?php echo wp_kses_post($item['title_style3']); ?>
											</h4>
										<?php } ?>
									</div>
									<?php if ('yes' == $settings['show_btn']) { ?>
										<div class="bottom-wrapper"> 
											<div class="btn-part">
												<?php
													if (!empty($settings['btn_icon'])) {
														Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']);
													}
												?>
											</div>
										</div>
									<?php } ?>
								</a>
							</div>
						<?php endforeach;
					} else {
						$order = $settings['order'];
						$postype = 'services';
						$taxonomyName =  'services-category';
						$categories = $settings['categories'];
						$select = $settings['select_posts'];

						if (!empty($categories)) {
							$terms = array(
								array(
									'taxonomy' => $taxonomyName,
									'field'    => 'slug', 
									'terms'    => $categories
								)
							);
						} else {
							$terms = '';
						}

						$custom_query = new WP_Query( 
							array(
								'post_type'   => $postype,
								'posts_per_page' => $settings['per_page'],
								'post_status' => 'publish',
								'order'       => $order,
								'tax_query'   => $terms,
								'post__in'          => $select,
								'offset'            => $settings['posts_offset'],
							)
						); ?>
						<?php while($custom_query->have_posts()) : $custom_query->the_post(); ?>
							<div class="<?php echo esc_attr($columns_grid); ?>">
								<a class="services-inner" href="<?php echo the_permalink(); ?>">
									<div class="top-wrapper">
										<?php if (get_the_title()) { ?>
											<h4 class="title">
												<?php echo get_the_title(); ?>
											</h4>
										<?php }
										if ('yes' == $settings['show_btn']) { ?>
											<div class="icon-wrap">
												<?php Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']) ?>
											</div>
										<?php } ?>
									</div>
								</a>
							</div>
						<?php 
							endwhile;
							wp_reset_postdata();
						?>
					<?php } ?>
				</div>
			</div>
		<?php } else { ?>
			<div class="rs-service-list thumb-<?php echo esc_attr($settings['feature_image_as_background'])?> scrollable-<?php echo esc_attr($settings['scrollable'])?> gsap-fixed-<?php echo esc_attr($settings['gsap_fixed'])?> service-list-<?php echo $unique ?>" <?php echo $preventSmoothScroll ?>>
				<?php foreach ($settings['services_list'] as $index => $item) :
					$link = !empty($item['link']['url']) ? $item['link']['url'] : '#';
					$target = $item['link']['is_external'] ? 'target=_blank' : '';
					$count++;

					$image = wp_get_attachment_image_url( $item['feature_img']['id'], $settings['thumbnail_size']);
					$thumbnail_id = $item['feature_img']['id'];
					$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
					if ( empty( $thumbnail_alt ) ) {
						$thumbnail_alt = get_the_title( $thumbnail_id );
					}
					if ('yes' == $settings['active_item_style']) {
						$active_item = $item['active_item'];
					}
					if ( ! $image ) {
						$image = Utils::get_placeholder_image_src();
					}
				?>
					<a class="services-inner <?php echo ($active_item == 'yes') ? 'active' : ''; ?>" href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>>
						<?php if ('yes' == $settings['show_count_number']) { ?>
							<div class="count_number">
								<?php echo sprintf("%02d", $count); ?>
							</div>
						<?php } ?>
						<div class="feature_img <?php if ('bg' !== $settings['feature_image_as_background']) { ?>prallax-img<?php } ?>">
							<img data-depth="2" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr($thumbnail_alt); ?>">
						</div>
						<div class="top-wrapper">
							<?php if ('yes' == $settings['show_title_icon']) { ?>
								<div class="icon-wrap">
									<?php Icons_Manager::render_icon($item['service_icon'], ['aria-hidden' => 'true']) ?>
								</div>
							<?php } ?>
							<?php if (!empty($item['title'])) { ?>
								<h4 class="title">
									<?php echo wp_kses_post($item['title']); ?>
								</h4>
							<?php } ?>
							<?php if (!empty($item['subinfo'])) { ?>
								<span class="subinfo">
									<?php echo wp_kses_post($item['subinfo']); ?>
								</span>
							<?php } ?>
						</div>
						<div class="bottom-wrapper">
							<?php if (!empty($item['description'])) : ?>
								<div class="desc-text">
									<?php echo wp_kses_post($item['description']); ?>
								</div>
							<?php endif; ?>
							<?php if ('yes' == $settings['show_btn']) { ?>
								<div class="btn-part">
									<?php
										if (!empty($settings['btn_icon'])) {
											Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']);
										}
									?>
								</div>
							<?php } ?>
						</div>
					</a>
				<?php endforeach; ?>
			</div>
			<?php if ('bg' !== $settings['feature_image_as_background']) { ?>
				<script> 
					jQuery(document).ready(function(){
						jQuery(".prallax-img").each(function() {
							var prallaxImg = jQuery(this).get(0);
							var parallaxInstance = new Parallax(prallaxImg);
						});
					});
				</script>
			<?php }
			if ('yes' == $settings['active_item_style']) { ?>
				<script>
					jQuery(document).ready(function($){
						$('.service-list-<?php echo $unique ?> .services-inner').on('mouseenter', function(){
							$('.service-list-<?php echo $unique ?> .services-inner').removeClass('active');
							$(this).addClass('active');
						});
					});
				</script>
			<?php }
		} ?>
<?php
	}

	public function getCategories(){
		$cat_list = [];
			if ( post_type_exists( 'services' ) ) { 
			$terms = get_terms( array(
				'taxonomy'    => 'services-category',
				'hide_empty'  => true            
			) );           
		

			foreach($terms as $post) {
				$cat_list[$post->slug]  = [$post->name];
			}
		}  
		return $cat_list;
	}
}