<?php
/**
 * Elementor rsgallery Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;


defined('ABSPATH') || die();

class Rsaddon_Single_Post_Comment_Pro_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve rsgallery widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'single-post-comment';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve rsgallery widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('RS Single Post Comment', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve rsgallery widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the rsgallery widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}

	/**
	 * Register rsgallery widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{
		// Global Style Control Start
		$this->start_controls_section(
			'section_comment_global_style_control',
			[
				'label' => __( 'Wrapper Style', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_responsive_control(
				'g_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'g_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'g_border',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'g_box_shadow',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area',
				]
			);
		$this->end_controls_section();
		// Global Style Control End
		
		// Title part Control Start
		$this->start_controls_section(
			'section_comment_title_style_control',
			[
				'label' => __( 'Title Style', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'rsaddon' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'rsaddon' ),
					'label_off' => esc_html__( 'Hide', 'rsaddon' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comments-title',
					'condition' => [
						'show_title' => 'yes'
					]
				]
			);
			$this->add_control(
				'title_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comments-title' => 'color: {{VALUE}}',
					],
					'condition' => [
						'show_title' => 'yes'
					]
				]
			);

			// Form Title
			$this->add_control(
				'form_part_title_more_options',
				[
					'label' => esc_html__( 'Form Part Title Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'form_part_title_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .comment-reply-title'
				]
			);
			$this->add_control(
				'form_part_title_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .comment-reply-title' => 'color: {{VALUE}}',
					]
				]
			);

			// Form Login as
			$this->add_control(
				'form_login_info_more_options',
				[
					'label' => esc_html__( 'Form Login Info Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'form_login_info_title_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .logged-in-as'
				]
			);
			$this->add_control(
				'form_login_info_title_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .logged-in-as,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .logged-in-as a' => 'color: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'form_login_info_title_text_hover_color',
				[
					'label' => esc_html__( 'Link Color (Hover)', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .logged-in-as a:hover' => 'color: {{VALUE}}',
					]
				]
			);
			
		$this->end_controls_section();
		// Title part Control End

		// Reply Part Control Start
		$this->start_controls_section(
			'section_comment_reply_style_control',
			[
				'label' => __( 'Reply Control', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			// Author
			$this->add_control(
				'reply_author_options_heading',
				[
					'label' => esc_html__( 'Author Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'reply_author_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-author' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'reply_author_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-author',
				]
			);
			// Meta
			$this->add_control(
				'reply_meta_options_heading',
				[
					'label' => esc_html__( 'Meta Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'reply_meta_text_color',
				[
					'label' => esc_html__( 'Date Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-metadata a time' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'reply_meta_edit_text_color',
				[
					'label' => esc_html__( 'Edit Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-metadata span a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'reply_meta_edit_text_color_hover',
				[
					'label' => esc_html__( 'Edit Text Color (Hover)', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-metadata span a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'reply_meta_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-metadata a',
				]
			);
			// Reply Content
			$this->add_control(
				'reply_content_options_heading',
				[
					'label' => esc_html__( 'Reply Content Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before'
				]
			);
			$this->add_control(
				'reply_content_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'reply_content_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-content p',
				]
			);
			$this->add_responsive_control(
				'reply_content_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .comment-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			// Button Content
			$this->add_control(
				'reply_button_options_heading',
				[
					'label' => esc_html__( 'Reply Button Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before'
				]
			);
			$this->add_control(
				'reply_button_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'reply_button_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'reply_button_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a',
				]
			);
			$this->add_control(
				'reply_button_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'reply_button_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'reply_button_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'reply_button_border',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply',
				]
			);
			$this->add_control(
				'reply_button_hover_options_heading',
				[
					'label' => esc_html__( 'Reply Button Hover Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'reply_button_text_color_hover',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'reply_button_background_hover',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a:hover',
				]
			);
			$this->add_control(
				'reply_button_text_border_color_hover',
				[
					'label' => esc_html__( 'Border Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-list li.comment .reply a:hover' => 'border-color: {{VALUE}}',
					],
				]
			);
		$this->end_controls_section();
		// Reply Part Control End

		// Field Control Start
		$this->start_controls_section(
			'section_comment_field_style_control',
			[
				'label' => __( 'Fields Control', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_control(
				'field_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'field_placeholder_color',
				[
					'label' => esc_html__( 'Placeholder Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment nput::placeholder' => 'color: {{VALUE}}',
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input::-ms-input-placeholder' => 'color: {{VALUE}}',
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea::placeholder' => 'color: {{VALUE}}',
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea::-ms-input-placeholder' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'filed_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'filed_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'filed_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'field_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'default' => [
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 1,
							'max' => 100,
						],
						'px' => [
							'min' => 1,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'field_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea
					',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'field_border',
					'selector' => '
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea
					',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'field_box_shadow',
					'selector' => '
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment input,
						{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea
					',
				]
			);
			// Form Textarea
			$this->add_control(
				'form_part_textarea_more_options',
				[
					'label' => esc_html__( 'Textarea Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'textarea_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'textarea_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'default' => [
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 1,
							'max' => 100,
						],
						'px' => [
							'min' => 1,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'textarea_height',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'default' => [
						'unit' => 'px',
					],
					'range' => [
						'%' => [
							'min' => 1,
							'max' => 100,
						],
						'px' => [
							'min' => 1,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment textarea' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Field Control End

		// Field Label Control Start
		$this->start_controls_section(
			'section_comment_field_label_style_control',
			[
				'label' => __( 'Label Control', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_control(
				'label_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment label' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography',
					'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment label'
				]
			);
			$this->add_responsive_control(
				'label_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond form .comment-form-comment label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Field Label Control End

		// Button Control Start
		$this->start_controls_section(
			'section_comment_button_style_control',
			[
				'label' => __( 'Button Control', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
			$this->add_responsive_control(
				'filebutton_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'default' => [
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 1,
							'max' => 100,
						],
						'px' => [
							'min' => 1,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'button_style_tabs'
			);
				$this->start_controls_tab(
					'button_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'button_text_color',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'button_background',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit'
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'button_border',
							'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit'
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'button_box_shadow',
							'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit'
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'button_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_control(
						'button_text_color_hover',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit:hover' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'button_background_hover',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit:hover'
						]
					);
					$this->add_control(
						'button_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit:hover' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'button_box_shadow_hover',
							'selector' => '{{WRAPPER}} .rs-single-post-comment-e-addon .comments-area .comment-respond .form-submit #submit:hover'
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Button Control End
	}

	/**
	 * Render rsgallery widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings     = $this->get_settings_for_display();
		$blog_author = '';
		
		if ('yes' == $settings['show_title']) {
			$show_comments_title = true;
		} else {
			$show_comments_title = false;
		}
		set_query_var('show_comments_title', $show_comments_title);
	?>
		<div class="rs-single-post-comment-e-addon">
			<?php 
				if($blog_author == ""){
					if ( comments_open() || get_comments_number() ) {
						comments_template();
					}
				}
            ?>
		</div>
	<?php
	}
}
