<?php
/**
 * Feature List
 *
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\register_controls;

defined( 'ABSPATH' ) || die();

class Rsaddon_Elementor_pro_RSwork_Process_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'rswork-process';
    }   


    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'RS Work Process', 'rsaddon' );
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'rs-badge';
    }


    public function get_categories() {
        return [ 'rsaddon_category' ];
    }

    public function get_keywords() {
        return [ 'work', 'process' ];
    }



    protected function register_controls() {       

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'scrollable',
			[
				'label' => esc_html__( 'Scrollable', 'rsaddon' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rsaddon' ),
				'label_off' => esc_html__( 'No', 'rsaddon' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        $this->add_control(
            'scroll_travel',
            [
                'label' => esc_html__( 'OnClick Distance', 'rsaddon' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'condition' => [
                    'scrollable' => 'yes',
                ],
            ]
        );
        $this->add_control(
			'scroll_icon',
			[
				'label' => esc_html__( 'Icon', 'rsaddon' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-arrow-down',
					'library' => 'fa-solid',
				],
                'condition' => [
                    'scrollable' => 'yes',
                ],
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'work_process_title',
            [
                'label' => esc_html__( 'Work Title', 'rsaddon' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Product Design and Planning', 'rsaddon' ),
            ]
        );

        $repeater->add_control(
            'number_title',
            [
                'label' => esc_html__( 'Number Title', 'rsaddon' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '01', 'rsaddon' ),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description', 'rsaddon' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => "I'm winner of the world's most prestigious web design awards in the fields.",
            ]
        );
        $repeater->add_control(
            'ul_list',
            [
                'label' => esc_html__( 'List Content', 'rsaddon' ),
                'description' => esc_html__('Use double comma (e.g. First Line,,).', 'rsaddon'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'history_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'show_label' => false,
                'default' => [
                    [
                        'work_process_title' => esc_html__( 'Web Developer', 'rsaddon' ),
                    ],
                    [
                        'work_process_title' => esc_html__( 'Sr. Developer', 'rsaddon' ),
                    ],
                   
                ],
                'title_field' => '{{{ work_process_title }}}',
            ]
        );
     
        $this->end_controls_section();

        $this->start_controls_section(
            'section_g_style',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'g_text_align',
                [
                    'label' => esc_html__( 'Text Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_display_style',
                [
                    'label' => esc_html__( 'Display Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],

                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_flex_wrap',
                [
                    'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'nowrap' => [
                            'title' => esc_html__( 'No Wrap', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'wrap' => [
                            'title' => esc_html__( 'Wrap', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'flex-wrap: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_flex_gap',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'g_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item',
                ]
            );
            $this->add_responsive_control(
                'g_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_item_min_height',
                [
                    'label' => esc_html__( 'Item Min Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item' => 'min-height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'g_border',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'g_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_scrollable_style',
            [
                'label' => esc_html__( 'Scroll Related Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'scrollable' => 'yes'
                ]
            ]
        );
            // Scroll Wrapper
            $this->add_control(
                'scrollable_wrapper_opt_heading',
                [
                    'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING
                ]
            );
            $this->add_responsive_control(
                'g_wrapper_height',
                [
                    'label' => esc_html__( 'Wrapper Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap-main .rs-work-process-wrap' => 'height: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );
            // Scroll overlay
            $this->add_control(
                'scrollable_overlay_opt_heading',
                [
                    'label' => esc_html__( 'Overlay Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'scrollable_overlay_color',
                [
                    'label' => esc_html__( 'Overlay Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap-main.is_scrollable:before' => 'background: linear-gradient(180deg, {{VALUE}} 0%, transparent 100%);',
                        '{{WRAPPER}} .rs-work-process-wrap-main.is_scrollable:after' => 'background: linear-gradient(180deg, transparent 0%, {{VALUE}} 100%);',
                    ],
                ]
            );
            // Scroll Btn
            $this->add_control(
                'scrollable_button_opt_heading',
                [
                    'label' => esc_html__( 'Button Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'scrollable_button_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-scroll-btn' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollable_button_size',
                [
                    'label' => esc_html__( 'Button Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollable_button_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollable_button_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-scroll-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollable_button_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs( 'scrollable_button_style_tabs' );
                $this->start_controls_tab(
                    'scrollable_button_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'scrollable_button_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'scrollable_button_background',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'scrollable_button_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'scrollable_button_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner:hover i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner:hover svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'scrollable_button_background_hover',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .rs-work-process-scroll-btn .btn-inner:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .title' => 'color: {{VALUE}};'
                    ],                
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .title',                    
                ]
            );
            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'title_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .title',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'title_border',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .title',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'title_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .title',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_description_style',
            [
                'label' => esc_html__( 'Description Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .desc' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .desc',                    
                ]
            );
            $this->add_responsive_control(
                'desc_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'desc_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'desc_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .desc' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'desc_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .desc',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'desc_border',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .desc',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'desc_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .desc',
                ]
            );
        $this->end_controls_section();

        // Content Button Style Start
        $this->start_controls_section(
            'section_content_list_style',
            [
                'label' => esc_html__('List Style', 'rsaddon'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
            $this->add_control(
                'ul_list_color',
                [
                    'label' => esc_html__('List Color', 'rsaddon'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'ul_list_typography',
                    'label' => esc_html__('Typography', 'rsaddon'),
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li',
                    'separator'   => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'feature_border',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li',
                ]
            );
            $this->add_control(
                'ul_list_icon_color',
                [
                    'label' => esc_html__('List Icon Color', 'rsaddon'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_box_icon_flex_direction',
                [
                    'label' => esc_html__( 'Icon Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content li' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'ul_list_box_horizontal_align',
                [
                    'label' => esc_html__( 'List Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'default' => 'flex',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'display: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'ul_list_box_flex_direction',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'ul_list_box_horizontal_align' => 'flex',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_box_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'ul_list_box_horizontal_align' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_flex_box_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'ul_list_box_horizontal_align' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_flex_box_flex_wrap',
                [
                    'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'wrap' => [
                            'title' => esc_html__( 'Wrap', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'nowrap' => [
                            'title' => esc_html__( 'No Wrap', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'ul_list_box_horizontal_align' => 'flex',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'flex-wrap: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'ul_list_flex_gap',
                [
                    'label' => esc_html__('Flex Gap', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['%', 'px'],
                    'show_label' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'ul_list_box_horizontal_align' => 'flex',
                    ]
                ]
            );

            $this->add_responsive_control(
                'ul_list_style_margin',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item ul.list_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_step_style',
            [
                'label' => esc_html__( 'Step Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'step_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'color: {{VALUE}};',
                    ],                
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'step_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part',                    
                ]
            );
            $this->add_responsive_control(
                'step_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'step_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'step_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'step_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'step_border',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'step_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part',
                ]
            );
            // Step Position Maker Start
            $this->add_control(
                'step_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'step_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'step_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'step_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'step_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'step_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-work-process-wrap .work-item .step-part' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Step Position Maker End
        $this->end_controls_section();

    }

    /**
     * Render rsgallery widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {

    $settings = $this->get_settings_for_display();


    $unique = ('yes' == $settings['scrollable']) ? 'unq-' . $this->get_id() : '';
    $preventSmoothScroll = ('yes' == $settings['scrollable']) ? 'data-lenis-prevent' : '';
    $isScrollAble = ('yes' == $settings['scrollable']) ? 'is_scrollable' : '';
    $travel = !empty($settings['scroll_travel']['size']) ? $settings['scroll_travel']['size'] : '300';
    ?>
        <div class="rs-work-process-wrap-main <?php echo esc_attr( $isScrollAble ); ?> <?php echo esc_attr( $unique ); ?>">
            <div class="rs-work-process-wrap <?php echo esc_attr( $unique ); ?>" <?php echo esc_attr( $preventSmoothScroll ); ?>>
                <?php 
                    foreach ( $settings['history_list'] as $index => $feature ) : 
                        $work_process_title = $feature['work_process_title'];
                        $description        = $feature['description'];
                        $number_title       = $feature['number_title'];
                        $list_content       = $feature['ul_list'];
                        $list_content_text  = esc_html($list_content);
                        $list_content_text_lines = explode(",,", $list_content_text);
                    ?>               
                    <div class="work-item">
                        <?php if (!empty($number_title)) { ?>
                            <div class="step-part"><?php echo $number_title;?></div>
                        <?php } ?>
                        <h5 class="title"><?php echo esc_html($work_process_title); ?></h5>
                        <?php if(!empty($description)) {?>
                            <div class="desc">
                                <?php echo $description;?>
                            </div>
                        <?php }
                        if ( !empty($list_content) ) { ?>
                            <ul class="list_content">
                                <?php foreach ($list_content_text_lines as $list_content_text_line) {?>
                                    <li><svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" width="48px" height="48px"><path d="M19.8,10.4c0.1,0.5,0.2,1.1,0.2,1.6c0,4.4-3.6,8-8,8s-8-3.6-8-8s3.6-8,8-8c1.6,0,3.2,0.5,4.4,1.3l1.4-1.4 C16.2,2.7,14.2,2,12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10c0-1.1-0.2-2.2-0.5-3.2L19.8,10.4z"/><path d="M11 16.4L6.3 11.7 7.7 10.3 11 13.6 21.3 3.3 22.7 4.7z"/></svg> <?php echo $list_content_text_line ?></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php if ('yes' == $settings['scrollable']) { ?>
            <div class="rs-work-process-scroll-btn <?php echo esc_attr( $unique ); ?>">
                <div class="btn-inner">
                    <?php Icons_Manager::render_icon( $settings['scroll_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
            </div>
        
            <script>
                jQuery(document).ready(function($) {
                    if ($('.rs-work-process-wrap-main.is_scrollable.<?php echo esc_attr( $unique ); ?>').length) {
                        const selector = (selector) => document.querySelector(selector);
                        const wrapper = selector('.rs-work-process-wrap-main.<?php echo esc_attr( $unique ); ?>');
                        const targetDiv = wrapper.querySelector('.rs-work-process-wrap.<?php echo esc_attr( $unique ); ?>');
                        const scrollButton = selector('.rs-work-process-scroll-btn.<?php echo esc_attr( $unique ); ?> .btn-inner');
                        if (scrollButton && targetDiv) {
                            scrollButton.addEventListener('click', () => {
                                let travel = <?php echo esc_attr( $travel ) ?>;
                                if (scrollButton.classList.contains('anti')) {
                                    targetDiv.scrollBy({ top: -travel, behavior: 'smooth' });
                                } else {
                                    targetDiv.scrollBy({ top: travel, behavior: 'smooth' });
                                }
                            });
                            targetDiv.addEventListener('scroll', () => {
                                const isAtBottom = targetDiv.scrollTop + targetDiv.clientHeight >= targetDiv.scrollHeight;
                                const isAtTop = targetDiv.scrollTop === 0;
                                if (isAtBottom) {
                                    scrollButton.classList.add('anti');
                                    wrapper.classList.add('anti');
                                }
                                if (isAtTop) {
                                    scrollButton.classList.remove('anti');
                                    wrapper.classList.remove('anti');
                                }
                            });
                        }
                    }
                });
            </script>
        <?php } ?>
    <?php
    }
}?>