(function ($) {

    window.rsmegaMenuAdmin = {

        init: function () {
            $(document)
                .on('click.rsmegaMenuAdmin', '.save-rsmega-menu', this.saveMenuOptions)
                .on('click.rsmegaMenuAdmin', '.rsmega-menu-opener', this.openMegaMenuModal)
                .on('click.rsmegaMenuAdmin', '.rsmega-menu-modal-closer', this.closeMegaMenuModal)
                .on('click.rsmegaMenuAdmin', '.save-rs-menu-item-options', this.updatersmegaMenuItemSettings)
                .on('click.rsmegaMenuAdmin', '.delete-rs-menu-item-options', this.deletersmegaMenuItemSettings)
                .on('click.rsmegaMenuAdmin', '.rsmega_pro_warning_img', this.alertForLicenseActive)
                .on('click.rsmegaMenuAdmin', '.rsmega-notice .notice-dismiss', this.ignorePluginNotice)
                ;
        },
        alertForLicenseActive: function () {
            alert(rsmegamenu_ajax.rsmega_pro_warning_msg);
        },
        ignorePluginNotice: function (that) {

            let notice_id = $(this).parent().data('notice_id');

            $.ajax({
                type: 'POST',
                url: rsmegamenu_ajax.ajaxurl,
                data: {
                    action: "rsmega_ignore_plugin_notice",
                    notice_id: notice_id,
                    nonce: rsmegamenu_ajax.nonce,
                },
                cache: false,
            });
        },
        openMegaMenuModal: function (that) {
            $('#rsmega-menu-setting-modal').css('display', 'flex');
            $('div#rsmega-menu-setting-modal #tabs-nav li').removeClass('active');
            $('div#rsmega-menu-setting-modal #tabs-nav li:first-child').addClass('active');
            let menuItemId = $(this).attr('data-menu_item_id');
            $('.save-rs-menu-item-options').attr('data-menu_item_id', menuItemId);
            $('.delete-rs-menu-item-options').attr('data-menu_item_id', menuItemId);
            rsmegaMenuAdmin.showMegaMenuModalAjaxLoader($(this));
            rsmegaMenuAdmin.getMenuItemOptions(menuItemId);
        },
        closeMegaMenuModal: function () {
            $('#rsmega-menu-setting-modal').css('display', 'none');
        },
        showMegaMenuModalAjaxLoader: function () {
            $('#rsmega-menu-setting-modal .ajax-loader').css('display', 'flex');
        },
        hideMegaMenuModalAjaxLoader: function () {
            $('#rsmega-menu-setting-modal .ajax-loader').css('display', 'none');
        },
        deletersmegaMenuItemSettings: function (that) {
            rsmegaMenuAdmin.showMegaMenuModalAjaxLoader($(this));
            let menu_id = $("#nav-menu-meta-object-id").val();
            let menu_item_id = $(this).attr('data-menu_item_id');
            let status_form = $('#rsmega-menu-setting-modal .form-status');

            $.ajax({
                type: 'POST',
                url: rsmegamenu_ajax.ajaxurl,
                data: {
                    action: "rsmega_delete_menu_options",
                    menu_id: menu_id,
                    menu_item_id: menu_item_id,
                    nonce: rsmegamenu_ajax.nonce,
                },
                cache: false,
                success: function (response) {
                    if (response.success == true) {
                        $(status_form).html('<span class="rsmega-text-success">Settings Deleted!</span>');
                        setTimeout(() => {
                            $(status_form).html('');
                            location.reload();
                        }, 2000);
                        rsmegaMenuAdmin.hideMegaMenuModalAjaxLoader($(this));
                    }

                }
            });
        },
        getMenuItemOptions: function (menu_item_id) {
            $.ajax({
                type: 'POST',
                url: rsmegamenu_ajax.ajaxurl,
                data: {
                    action: "rsmega_get_menu_options",
                    menu_item_id: menu_item_id,
                    nonce: rsmegamenu_ajax.nonce,
                },
                cache: false,
                success: function (response) {
                    $('#rsmega-menu-setting-modal .tab-contents-wrapper').html(response);
                    rsmegaMenuAdmin.hideMegaMenuModalAjaxLoader($(this));
                }
            });
        },

        saveMenuOptions: function (that) {

            var spinner = $(this).parent().parent().find('.ajax-loader');
            spinner.addClass('show');


            let menu_id = $("#nav-menu-meta-object-id").val();

            var settings = {
                'enable_menu': $(".rs_mega_menu_switch").is(':checked') === true ? 'on' : 'off'
            };

            $.ajax({
                type: 'POST',
                url: rsmegamenu_ajax.ajaxurl,
                data: {
                    action: "rsmega_update_menu_options",
                    actualAction: 'saveMenuOptions',
                    settings: settings,
                    menu_id: menu_id,
                    nonce: rsmegamenu_ajax.nonce,
                },
                cache: false,
                success: function (response) {
                    $(that).parent().parent().find('.ajax-loader').removeClass('show');
                    location.reload();
                }
            });

        },

        updatersmegaMenuItemSettings: function (that) {

            rsmegaMenuAdmin.showMegaMenuModalAjaxLoader($(this));
            let menu_id = $("#nav-menu-meta-object-id").val();
            let menu_item_id = $(this).attr('data-menu_item_id');

            // let settings = $('#rsmega_menu_items_settings').serialize();
            // let css = $('#rsmega_menu_items_css').serialize();
            let status_form = $('#rsmega-menu-setting-modal .form-status');

            let css = {};
            let settings = {};


            // Iterate over each input in the form
            $('#rsmega_menu_items_settings').find('input, select').each(function () {
                // Exclude the submit button from the values
                if ($(this).attr('type') !== 'submit' && $(this).attr('name') !== 'search_rs_icon') {
                    settings[$(this).attr('name')] = $(this).val();
                }
            });

            // Iterate over each input in the form
            $('#rsmega_menu_items_css').find('input, select').each(function () {
                // Exclude the submit button from the values
                if ($(this).attr('type') !== 'submit') {
                    css[$(this).attr('name')] = $(this).val();
                }
            });


            console.log('settings', settings);
            console.log('css', css);

            $.ajax({
                type: 'POST',
                url: rsmegamenu_ajax.ajaxurl,
                data: {
                    action: "rsmega_update_menu_options",
                    actualAction: 'saveMenuItemSettings',
                    settings: settings,
                    css: css,
                    menu_id: menu_id,
                    menu_item_id: menu_item_id,
                    nonce: rsmegamenu_ajax.nonce,
                },
                cache: false,
                success: function (response) {

                    console.log(response);

                    if (response.success == true) {
                        $(status_form).html('<span class="rsmega-text-success">Settings Saved!</span>');
                        setTimeout(() => {
                            $(status_form).html('');
                        }, 2000);
                        rsmegaMenuAdmin.hideMegaMenuModalAjaxLoader($(this));
                    }

                }
            });

        },


    }

    rsmegaMenuAdmin.init();



})(jQuery);