(function ($) {
    $(document).ready(function () {

        $('.rsmega-templates-item').each(function () {
            let el = $(this).find('.preview_btn');
            let src = el.attr('data-thumb_url');
            let title = el.attr('title');
            $(el).click(function () {
                $('#rsmega-template-imoporter-form').css('display', 'none');
                $('#rsmega-menu-setting-modal').css('display', 'flex');
                $('#template-previewer img').attr('src', src);
                $('#template-previewer').css('display', 'block');
            });
        })

        // Importer Modal
        $('.rs-mega-template-actions .import_btn').click(function () {
            let template_id = $(this).attr('data-template_id');
            $('.rsmega-template-imoporter-form .importer-status').removeClass('show');
            $('.rsmega-template-imoporter-form input[name="template-id"]').val(template_id);
            $('#template-previewer').css('display', 'none');
            $('#rsmega-menu-setting-modal').css('display', 'flex');
            $('#rsmega-template-imoporter-form').css('display', 'block');
        })

        // Import data request
        $('body').on('click', 'a.import_template_btn', function (e) {
            e.preventDefault();

            var $this = $(this),
                pageTitle = ($('.rsmega-template-imoporter-form input[name="page-title"]').val()) ? ($('.rsmega-template-imoporter-form input[name="page-title"]').val()) : '',
                template_id = $('.rsmega-template-imoporter-form input[name="template-id"]').val();


            $.ajax({
                url: ajaxurl,
                data: {
                    'action': 'import_rsmega_template',
                    'templateId': template_id,
                    'pageTitle': pageTitle,
                    'nonce': rsmegamenu_ajax.nonce,
                },
                //dataType: 'JSON',
                beforeSend: function () {
                    $('.rsmega-template-imoporter-form .form-groups').addClass('hide');
                    $('.rsmega-template-imoporter-form .ajax-loader').addClass('show');
                },
                success: function (data) {
                    console.log(data);
                    var template_edit_url = rsmegamenu_ajax.adminURL + "/post.php?post=" + data.id + "&action=elementor";
                },
                complete: function (data) {

                    $('.rsmega-template-imoporter-form .ajax-loader').removeClass('show');
                    $('.rsmega-template-imoporter-form .importer-status.success-status').addClass('show');
                },
                error: function (errorThrown) {
                    console.log(errorThrown);
                }
            });

        });

    });
})(jQuery);