<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.
if ( !class_exists('RSMEGA_MENU_Admin_Ajax')) {
    class RSMEGA_MENU_Admin_Ajax {

        function __construct(){

            add_action( "wp_ajax_rsmega_update_menu_options", array ( $this, 'rsmega_update_menu_options' ) );
            add_action( "wp_ajax_rsmega_get_menu_options", array ( $this, 'rsmega_get_menu_options' ) );
            add_action( "wp_ajax_rsmega_set_menu_item_mega_button", array ( $this, 'rsmega_set_menu_item_mega_button' ) );
            add_action( "wp_ajax_rsmega_delete_menu_options", array ( $this, 'rsmega_delete_menu_options' ) );
        }

        public function rsmega_update_menu_options($menu_id) {

            check_ajax_referer('rsmega_templates_import_nonce', 'nonce');
            
            if(isset($_POST['settings']) && isset($_POST['menu_id']) && isset($_POST['actualAction'])){
                $actual_action = sanitize_text_field($_POST['actualAction']);
                $menu_id = sanitize_text_field($_POST['menu_id']);
                $menu_id = absint( $_POST['menu_id'] );

                if($actual_action == 'saveMenuOptions'){
                    $settings = isset( $_POST['settings'] ) ?  $_POST['settings'] : array();
                    update_option( 'rsmega_menu_settings_' . $menu_id, $settings );
                }else{
                    $menu_item_id = sanitize_text_field($_POST['menu_item_id']);
                    $settings = '';
                    if( isset( $_POST['settings'] ) && !empty( $_POST['settings'] ) ) {
                        $settings = array_map('sanitize_text_field', $_POST['settings']);
                    } 
                    $css = '';
                    if( isset($_POST['css']) && !empty( $_POST['css'] ) ) {
                        $css = array_map('sanitize_text_field', $_POST['css']);
                    }
                    update_post_meta( $menu_item_id, 'rsmega_menu_settings', ['switch' => 'on', 'content' => $settings, 'css' => $css] );
                }
                wp_send_json_success([
                    'message' => esc_html__( 'Successfully data saved','rs-mega-menu' )
                ]);
                wp_die();
            }
        }

        public function rsmega_set_menu_item_mega_button() {
            check_ajax_referer('rsmega_templates_import_nonce', 'nonce');
            if(isset($_POST['menu_item_id'])){

                $menu_item_id = sanitize_text_field($_POST['menu_item_id']);
                $rsmega_menu_item_settings = get_post_meta( $menu_item_id, 'rsmega_menu_settings', true );

                echo wp_send_json_success( $rsmega_menu_item_settings ) ;
            }
            wp_die();
        }

        public function rsmega_delete_menu_options() {
            check_ajax_referer('rsmega_templates_import_nonce', 'nonce');
            if(isset($_POST['menu_item_id'])){

                $menu_item_id = sanitize_text_field($_POST['menu_item_id']);
                $rsmega_menu_item_settings = get_post_meta( $menu_item_id, 'rsmega_menu_settings', true );

                if(isset($rsmega_menu_item_settings)){
                    delete_post_meta( $menu_item_id, 'rsmega_menu_settings' );
                    echo wp_send_json_success( $rsmega_menu_item_settings, 200 );
                }else{
                    echo wp_send_json_success( $rsmega_menu_item_settings, 404 );
                }
            }
            wp_die();
        }

        public function rsmega_get_menu_options() {
            check_ajax_referer('rsmega_templates_import_nonce', 'nonce');
            if(isset($_POST['menu_item_id'])){
                $menu_item_id = sanitize_text_field($_POST['menu_item_id']);
                $rsmega_menupos_left = $rsmega_menupos_left = $rsmega_menupos_top = $rsmega_menuwidth = $rsmega_menu_item_css = '';
                $rsmega_menu_item_settings = get_post_meta($menu_item_id, 'rsmega_menu_settings', true);
                if (isset($rsmega_menu_item_settings['css'])) {
                    $css = $rsmega_menu_item_settings['css'];
                    $rsmega_menupos_left = $css['left'] ?? null;
                    $rsmega_menupos_right = $css['right'] ?? null;
                    $rsmega_menupos_top = $css['top'] ?? null;
                    $rsmega_menuwidth = $css['width'] ?? null;
                }
                ?>
                    <div id="tabs-content">
                        <div id="tab1" class="tab-content">
                            <h2>Select a template</h2>
                            <!-- elementor_library -->
                            <?php
                                $activeKitId = get_option( 'elementor_active_kit' );

                                $elementor_library_query_args = array(
                                    'post_type' => 'elementor_library',
                                    'post__not_in' => array($activeKitId),
                                    'posts_per_page' => -1,
                                    'orderby' => 'id',
                                    'order' => 'DESC'
                                );

                                $elementor_library_query = new WP_Query($elementor_library_query_args);
                                
                                $content_tempalte = '';
                                if(isset($rsmega_menu_item_settings['content']['rsmega_template'])){
                                    $content_tempalte = $rsmega_menu_item_settings['content']['rsmega_template'];
                                }

                            ?>
                            <form action="" onsubmit="return false" id='rsmega_menu_items_settings'>    
                                <div class="rsmega-menu-option-inputs">
                                    <ul class="rsmega-menu-option-input-list"> 
                                        <li>
                                            <?php 
                                                if($elementor_library_query->have_posts()){
                                                    ?>
                                                        <select name="rsmega_template" id="rsmega-template-select">
                                                            <option value="">Select Template</option>
                                                            <?php 
                                                                
                                                                while ($elementor_library_query->have_posts()) {
                                                                    $elementor_library_query->the_post();
                                                                    ?>
                                                                        <option value="<?php echo esc_attr(get_the_ID());?>" <?php echo esc_attr($content_tempalte == get_the_ID() ? 'selected' : ''); ?> ><?php the_title( );?></option>
                                                                    <?php
                                                                }
                                                                
                                                            ?>
                                                    </select>
                                            <?php }else{
                                                ?>
                                                <strong class="rsmega-text-danger ">Ops! Templates not found. <a href="<?php echo esc_url(admin_url('edit.php?post_type=elementor_library&tabs_group=library')) ?>" title="Click here to create a template.">Create</a> a new template.</strong>
                                                <?php
                                            } ?>
                                            <?php 
                                            if($elementor_library_query->have_posts()){ ?>
                                                <a href="<?php echo esc_url(admin_url('post.php?post='.$content_tempalte.'&action=elementor')) ?>" id="edit-remega-selected-template" class="button" target="_blank">Edit Template</a>
                                            <?php } ?>
                                        </li>
                                        
                                        <?php do_action( 'after_content_options_rs_mega_menu' ); ?>
                                    </ul>
                                </div>
                            </form>
                            
                            <!-- Mega Menu Container Style -->
                            <h2>Container Style</h2>
                            <form action="" onsubmit="return false" id='rsmega_menu_items_css'>          
                                <div class="rsmega-menu-option-inputs">
                                    <ul class="rsmega-menu-option-input-list">
                                        <li>
                                            <div class="option-label">Position : </div>
                                            <div class="option-inputs">
                                                <label>
                                                    <strong>Left (ex: 100px or 100%)</strong>
                                                    <input type="text" name="left" value="<?php echo esc_attr($rsmega_menupos_left); ?>">
                                                </label>
                                                <label>
                                                    <strong>Right (ex: 100px or 100%)</strong>
                                                    <input type="text" name="right" value="<?php echo esc_attr($rsmega_menupos_right); ?>">
                                                </label>
                                                <label>
                                                    <strong>Top (ex: 100px or 100%)</strong>
                                                    <input type="text" name="top" value="<?php echo esc_attr($rsmega_menupos_top); ?>">
                                                </label>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="option-label">Mega Menu Size : </div>
                                            <div class="option-inputs">
                                                <label>
                                                    <strong>Width (ex: 100px or 100%)</strong>
                                                    <input type="text" name="width" value="<?php echo esc_attr($rsmega_menuwidth); ?>">
                                                </label>
                                            </div>
                                        </li>
                                        <?php do_action( 'after_style_options_rs_mega_menu' ); ?>
                                    </ul>
                                </div>
                            </form>
                        </div>
                    </div> <!-- END tabs-content -->
                <?php

            }
            
            wp_die();
        }


    }

    $RSMEGA_MENU_Admin_Ajax = new RSMEGA_MENU_Admin_Ajax();
}