<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.
if ( !class_exists('RSMEGA_MENU_Nav')) {
    class RSMEGA_MENU_Nav {

        function __construct(){

            add_action( 'admin_footer', array($this, 'rsmega_menu_nav_contents') );
            add_action( 'admin_footer', array( $this, 'rsmega_menu_pop_up_content' ) );

            add_action( "wp_ajax_rsmega_get_menu_switch", array ( $this, 'rsmega_get_menu_switch' ) );
            add_action( "wp_ajax_nopriv_rsmega_get_menu_switch", array ( $this, 'rsmega_get_menu_switch' ) );
        
        }

  
        public function rsmega_get_menu_switch (){

            check_ajax_referer('rsmega_templates_import_nonce', 'nonce');

            $selected_menu_id = isset( $_REQUEST['menu_id'] ) ? absint( $_REQUEST['menu_id'] ) : 0;

            $rsmega_menu_options = get_option( 'rsmega_menu_settings_'.$selected_menu_id);

            $rsmega_menu_options_switch = isset($rsmega_menu_options['enable_menu']) ? $rsmega_menu_options['enable_menu'] : '';

            ?>
                <div class="rsmega-menu-switch-wrapper">
                    <div class="ajax-loader">
                        <img src="<?php echo esc_url(RSHFE_URL.'admin/assets/img/ajax-loader.gif'); ?>" alt="Ajax Loader">
                    </div>
                    <label class="menu-item-title">
                
                        <input 
                        type="checkbox" 
                        class="menu-item-checkbox rs_mega_menu_switch" 
                        name="rs_mega_menu_switch" 
                        value="<?php echo esc_attr( $rsmega_menu_options_switch == 'on' ? 'on' : '' ) ?>" <?php echo esc_attr( $rsmega_menu_options_switch == 'on' ? 'checked' : '' ) ?>>
                            Enable RS Mega Menu
                    </label>
                    <p><input type="submit" class="button button-primary button-large save-rsmega-menu" value="Save"></p>
                    </div>
            <?php

            wp_die();

        }
    
        public function rsmega_menu_nav_contents() {
            ?>
            <script>
                (function($){
                    $(document).ready(function () {
                        let seleceted_menu = $('input[name="menu"]').val();
                        $.ajax({
                            type: 'POST',
                            url: rsmegamenu_ajax.ajaxurl,
                            data: {
                                action          : "rsmega_get_menu_switch",
                                menu_id         : seleceted_menu,
                                nonce : rsmegamenu_ajax.nonce,
                            },
                            cache: false,
                            success: function(response) {
                                $('#nav-menus-frame').prepend(response);
                            }
                        });
                    });
                    
                })(jQuery);
            
            </script>	
        <?php }

        public function rsmega_menu_pop_up_content(){
            ob_start();
            $contents = ob_get_clean();
            ?>
                <div id="rsmega-menu-setting-modal" style="display: none;">
                    <div class="rsmega-menu-overlay"></div>
                    <div class="rsmega-modal-body">
                        <div class="ajax-loader">
                            <img src="<?php echo esc_url(RSHFE_URL.'admin/assets/img/ajax-loader.gif'); ?>" alt="Ajax Loader">
                        </div>
                        <button type="button" class="rsmega-menu-modal-closer"><span class="dashicons dashicons-no"></span></button>
                        <div class="rsmega-modal-content">
                            
                                <div class="tabs">
                                    <ul id="tabs-nav">
                                        <li><a href="#tab1">RS Mega Menu Settings</a></li>
                                    </ul> <!-- END tabs-nav -->
                                    <div class="tab-contents-wrapper">

                                    </div>
                                    <p class="form-status"></p>
                                    <div class="tab-footer">
                                        <button type="button" class="button delete-rs-menu-item-options">Disable Mega Menu</button>
                                        <button type="button" class="button save-rs-menu-item-options">Save</button>
                                    </div>
                                </div> <!-- END tabs -->
                            
                        </div>
                    </div>
                </div>


            <script>
                (function($){

                    $(document).ready(function () {
                        setTimeout(() => {
                            let checkrsmegaMneu = $('input.rs_mega_menu_switch').val();

                           
                            if(checkrsmegaMneu == 'on'){

                                $('#menu-to-edit li').each(function () {
                                    let menuItemId = $(this).find('.menu-item-checkbox').attr('data-menu-item-id');
                                    $(this).addClass('has-rs-mega-menu');
                                    $(this).find('label.item-title').append('<span class="rsmega-menu-opener" data-menu_item_id="'+menuItemId+'"><span class="dashicons dashicons-welcome-widgets-menus"></span>RS Mega Menu</span>')
                               
                                    
                                    let rsmegaMenuOpener =  $(this).find('.rsmega-menu-opener');
                                    // Set Menu Item Mega Buttons
                                    $.ajax({
                                        type: 'POST',
                                        url: rsmegamenu_ajax.ajaxurl,
                                        data: {
                                            action          : "rsmega_set_menu_item_mega_button",
                                            menu_item_id    : menuItemId,
                                            nonce : rsmegamenu_ajax.nonce,
                                        },
                                        cache: false,
                                        success: function(response) {
                                            if(response.data !='' && response.data.content.rsmega_template){
                                                $(rsmegaMenuOpener).addClass('has-mega-menu');
                                            }
                                        }
                                    });
                               
                                })
                            }
                        }, 1500);

                        // Show the first tab and hide the rest
                        $('div#rsmega-menu-setting-modal #tabs-nav li:first-child').addClass('active');
                        $('div#rsmega-menu-setting-modal .tab-content').hide();
                        $('div#rsmega-menu-setting-modal .tab-content:first').show();

                        // Click function
                        $('div#rsmega-menu-setting-modal #tabs-nav li').click(function(){
                            $('div#rsmega-menu-setting-modal #tabs-nav li').removeClass('active');
                            $(this).addClass('active');
                            $('div#rsmega-menu-setting-modal .tab-content').hide();
                            
                            var activeTab = $(this).find('a').attr('href');
                            $(activeTab).fadeIn();
                            return false;
                        });

                        //Change Edit url when change template
                        $(document).on('change', 'select#rsmega-template-select', function () {
                            let templateId = $(this).val();
                            let newEditLink = rsmegamenu_ajax.adminURL+'post.php?post='+templateId+'&action=elementor';
                            $('a#edit-remega-selected-template').attr('href', newEditLink);
                        })

                    });

                })(jQuery);
            </script>

            <?php
            echo esc_html($contents);
        }

       
    }
    $RSMEGA_MENU_Nav = new RSMEGA_MENU_Nav();
}







