<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.
add_action('admin_enqueue_scripts', 'rsmega_menu_admin_enqueue_scripts');
function rsmega_menu_admin_enqueue_scripts (){

    wp_enqueue_media();
    wp_enqueue_style( 'wp-color-picker');
    wp_enqueue_script( 'wp-color-picker');

    wp_enqueue_style( 'rsmegamenu-admin-style', RSHFE_URL . 'admin/assets/css/rsmega-menu-admin.css' );
    wp_enqueue_script( 'rsmegamenu-admin', RSHFE_URL . 'admin/assets/js/rsmega-menu-admin.js', array('jquery'), RSHFE_VER, TRUE );
    wp_enqueue_script( 'rsmegamenu-template', RSHFE_URL . 'admin/assets/js/rsmega-template.js', array('jquery'), RSHFE_VER, TRUE );

    $pro_warning_msg = 'Please use Premium Verison of this plugin to use this advanced features!';
    if ( get_option( 'rsmega_license_key' ) !== false ) {
        $pro_warning_msg = 'Please activate plugin license to use this advanced features!';
    }


    $current_user = wp_get_current_user();

    wp_localize_script(
            'rsmegamenu-admin', 
            'rsmegamenu_ajax',
                [
                    'ajaxurl'          => admin_url( 'admin-ajax.php' ),
                    'adminURL'         => admin_url(),
                    'elementorURL'     => admin_url( 'edit.php?post_type=elementor_library' ),
                    'nonce'            => wp_create_nonce('rsmega_templates_import_nonce'),
                    'version'          => RSHFE_VER,
                    'pluginURL'        => plugin_dir_url( __FILE__ ),
                    'packagedesc'      => __( 'Templates in this package', 'rsmega-menu' ),
                    'rsmega_pro_warning_msg' => ( $pro_warning_msg ),
                    'user'             => [
                    'email' => $current_user->user_email,
                    ]
                ]
        );

}

