
<div class="rsmega-templates-library">
    <div class="section-header">
        <h1>Templates Library</h1>
    </div>    
    <div class="rsmega-templates-row">
        <?php 
        $templates = RSMEGA_MENU_Template_Library::instance()->get_rsmega_templates();        
        if(!empty($templates)){
            $templates = json_decode($templates, true);
        }        
        if(is_array($templates)){

            foreach ($templates as $template) {
                $thumbnail_url = 'https://rsmega.rstheme.com/wp-content/uploads/2024/05/b-img-1-1.jpg';
                $title =  $template['title'];
                $template_id = $template['template_id'];
                if(isset($template['thumbnail_url']) && !empty($template['thumbnail_url'])) {
                    $thumbnail_url = $template['thumbnail_url'];
                }
                ?>
                    <div class="rsmega-templates-item">
                        <div class="rsmega-template-thumbnail-wrapper">
                            <img src="<?php echo esc_url( $thumbnail_url ); ?>" alt="" class="rsmega-template-thumbnail thumbnail-1">
                        </div>
                         <div class="rs-mega-template-actions">
                                <h4 class="template-title"><?php echo esc_html($title); ?></h4>
                                <div class="buttons">
                                    <a href="#" class="button preview_btn" data-thumb_url="<?php echo esc_attr($thumbnail_url);?>" title="<?php echo esc_html($title); ?>">Preview</a>
                                    <a href="#rsmega-template-imoporter-form" class="button import_btn popup-with-form" data-template_id="<?php echo esc_attr($template_id);?>">Import</a>
                                </div>
                         </div>
                     </div>
                 <?php
            }
        }       
        ?>
    </div>     
    <div id="rsmega-menu-setting-modal" style="display: none;">
        <div class="rsmega-menu-overlay"></div>
        <div class="rsmega-modal-body">
            <button type="button" class="rsmega-menu-modal-closer"><span class="dashicons dashicons-no"></span></button>
            <div class="rsmega-modal-content">

                <div id="template-previewer">
                    <?php 
                        $thumbnail_url = 'https://rsmega.themewant.com/wp-content/uploads/2024/05/b-img-1-1.jpg';
                    ?>
                    <img src="<?php echo $thumbnail_url; ?>" alt="">
                </div>

                <form id="rsmega-template-imoporter-form" class="rsmega-template-imoporter-form">
                    <div class="ajax-loader">
                        <img src="<?php echo esc_url(RSHFE_URL.'admin/assets/img/ajax-loader.gif'); ?>" alt="Ajax Loader">
                    </div>
                
                    <div class="importer-status success-status">
                        <img src="<?php echo esc_url(RSHFE_URL.'admin/assets/img/success.gif'); ?>" alt="Ajax Loader">
                        <h2 class="rsmega-text-success">Successfully imported the template!</h2>
                    </div>
                    
                    <div class="form-groups">
                        <div class="form-group">
                            <h2>Import to template library</h2>
                            <input type="hidden" name="template-id" placeholder="Enter your page name">
                            <a href="#" class="button button-primary import_template_btn">Import</a>
                        </div>
                        <hr>
                        <div class="form-group">
                            <h2>Import to a page</h2>
                            <div>
                                <input type="text" name="page-title" placeholder="Enter your page name">
                                <a href="#" class="button button-primary import_template_btn">Import</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>