<?php

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;


defined('ABSPATH') || die();

class RS_Header_Footer_Setting
{

	public function __construct()
	{
		add_action('elementor/element/container/section_layout/after_section_end', [$this, 'rs_header_controls_section'], 1);
		add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'rs_header_controls_section'], 1);		
		
		add_action('elementor/frontend/before_render', [$this, 'rs_before_section_render'], 1);
		
	}

	public function rs_header_controls_section(Element_Base $get_element)
	{
		$tabs_field = Controls_Manager::TAB_CONTENT;

		if ('section' === $get_element->get_name()  || 'container' === $get_element->get_name()) {
			$tabs_field = Controls_Manager::TAB_LAYOUT;
		}

		$get_element->start_controls_section(
			'_section_hfe_wrapper_setting',
			[
				'label' => __('RS Header Settings', 'rs-header-footer-elementor'),
				'tab'   => $tabs_field,
			]
		);

		$get_element->add_control(
			'position_header',
			[
				'label'     => __('Select Position', 'rs-header-footer-elementor'),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'no-position' 		=> __('Default', 'rs-header-footer-elementor'),
					'transparent-position'  	=> __('Transparent', 'rs-header-footer-elementor'),
				],
				'default'   => 'no-position',
			]
		);
		$get_element->add_control(
			'header_sticky_part',
			[
				'label'     	=> __('This is sticky part?', 'rs-header-footer-elementor'),
				'description'   => __('This control will make sure that when you select this container as sticky part it will come when sticky header should appear.', 'rs-header-footer-elementor'),
				'type'     		=> Controls_Manager::SELECT,
				'options'   	=> [
					'' 	=> __('No', 'rs-header-footer-elementor'),
					'header-sticky-part' => __('Yes', 'rs-header-footer-elementor'),
				],
				'default' => '',
			]
		);

		$get_element->end_controls_section();
	}

	public function rs_before_section_render(Element_Base $get_element)
	{
		$position_header = $get_element->get_settings_for_display('position_header');
		$header_sticky_part = $get_element->get_settings_for_display('header_sticky_part');

		if (
			($position_header && !empty($position_header)) ||
			($header_sticky_part && !empty($header_sticky_part))
		) {
			$get_element->add_render_attribute(
				'_wrapper',
				[
					'class' => [$position_header, $header_sticky_part],
				]
			);
		}
	}

}

new RS_Header_Footer_Setting();
?>