<?php
namespace RSHFE\WidgetsManager\Widgets;
require_once RSHFE_DIR . 'inc/widgets-manager/widgets/class-menu-walker.php';
/**
 * @author  rs-theme
 * @since   1.0.0
 * @version 1.0.0 
 */


$post_id = get_the_ID();
$rs_onepage_post_check = get_post_meta($post_id, 'rs_onepage_post_check', true);
$sticky = !empty(get_theme_mod('rstheme_enable_sticky_menu')) ? 'rs-enable-sticky' : '';
if ($rs_onepage_post_check === 'on') {
	$onepage = 'rs-onepage-header';
	$page_type = 'is-onepage';
} else {
	$onepage = '';
	$page_type = 'is-page';
}
$gsapEnable = !empty(get_theme_mod('gsap_animation_enable_disable')) ? 'gsap-enable' : '';


?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>

<!--Preloader start here-->
<?php
	if( is_404() ){
		return;
	} else {
    	get_template_part( 'inc/header/preloader' ); 
	}
?>

<div class="rs-offcanvas-area">
	<div class="rsoffwrap"></div>
	<!-- Canvas Menu start -->
	<nav class="right_menu_togle" data-lenis-prevent>	
		<div class="rsoffwrap-close"> <i class="ri-close-line"></i> </div>

		<?php
			if(!empty(get_theme_mod('rstheme_offcanvas_sidebar_logo_img'))){
				if(!empty(get_theme_mod('offcanvas_sidebar_logo_enable_disable'))){
					$offcanvas_sidebar_logo_height    = !empty(get_theme_mod('rstheme_offcanvas_sidebar_logo_image_height')) ? 'style = "width: auto; height: '.get_theme_mod('rstheme_offcanvas_sidebar_logo_image_height').';"' : '';
					$offcanvas_sidebar_logo_bottom_margin   = !empty(get_theme_mod('rstheme_offcanvas_sidebar_logo_bottom_margin')) ? 'style = "margin-bottom: '.get_theme_mod('rstheme_offcanvas_sidebar_logo_bottom_margin').';"' : ''; ?>
					<div class="sidebar-offcanvas-menu-logo" <?php echo wp_kses($offcanvas_sidebar_logo_bottom_margin, 'rs-header-footer-elementor');?>>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
							<img <?php echo wp_kses($offcanvas_sidebar_logo_height, 'rs-header-footer-elementor');?> src="<?php echo esc_url(get_theme_mod('rstheme_offcanvas_sidebar_logo_img')); ?>" alt="Offcanvas Logo">
						</a>
					</div>
			<?php }
		} ?>


		<?php if ( is_active_sidebar( 'rs-offcanvas-sidebar' ) ) { ?>    
	    	<div class="rs-desk-off-content"><?php dynamic_sidebar('rs-offcanvas-sidebar'); ?></div>
	    <?php } ?>

	    <?php
	    	if ( has_nav_menu( 'menu-2' ) || has_nav_menu( 'menu-3' ) ) { ?>
				<nav class="nav navbar">
					<div class="navbar-menu">
						<?php
							if ($rs_onepage_post_check === 'on') {
								if (has_nav_menu( 'menu-3' )) {
									wp_nav_menu( array(
										'theme_location' => 'menu-3',
										'menu_id'        => 'mobile_menu_rstheme',
										'menu_class'     => 'menu rs_onepage_mobile_menu',
										'walker'         => new Menu_Walker(),
									) );
								} else {
									wp_nav_menu( array(
										'theme_location' => 'menu-2',
										'menu_id'        => 'mobile_menu_rstheme',
										'menu_class'     => 'menu rs_mobile_menu',
										'walker'         => new Menu_Walker(),
									) );
								}
								
							} else {
								wp_nav_menu( array(
									'theme_location' => 'menu-2',
									'menu_id'        => 'mobile_menu_rstheme',
									'menu_class'     => 'menu rs_mobile_menu',
									'walker'         => new Menu_Walker(),
								) );
							}
						?>
					</div>
				</nav>
	    <?php }
		

		


		if ( is_active_sidebar( 'rs-offcanvas-sidebar' ) ) { ?>    
			<div class="rs-mob-off-content"><?php dynamic_sidebar('rs-mobile-offcanvas-sidebar'); ?></div>
		<?php } ?>
	</nav>
</div>

<div id="page" class="hfeed site <?php echo esc_attr($page_type); ?> <?php echo esc_attr($gsapEnable); ?>">
<?php
if( is_404() ){
	return;
} else {

	?>
	<?php do_action( 'rshfe_modal' ); ?>
	<header id="rs-header" class="single-header <?php echo esc_attr($sticky); ?> <?php echo esc_attr($onepage); ?>" style="display: none;">
	    <div class="header-inner">
	    	<?php
	    		do_action( 'rshfe_topbar' ); 
				do_action( 'rshfe_header' );
			?>
		</div>
		<div id="rs-theme-toggle" class="rs_ld_btn" style="opacity: 0; display: none;">
			<span class="d-block-light"><i class="ri-sun-line"></i></span>
		 	<span class="d-block-dark"><i class="ri-moon-line"></i></span>
		</div>

	</header>
	<script>
        jQuery(document).ready(function($) {
			const menuLoadFixer = $('#rs-header');
			if (menuLoadFixer.length) {
				menuLoadFixer.show();
			}
		});
	</script>
	<?php do_action( 'rshfe_header_after' ); ?>
	<?php
}