<?php

/*** Child Theme Function  ***/
function techtlk_theme_enqueue_scripts() {
	wp_register_style( 'childstyle', get_template_directory_uri() . '/style.css'  );
	wp_enqueue_style( 'childstyle' );
}
add_action('wp_enqueue_scripts', 'techtlk_theme_enqueue_scripts', 11);

/*Blog Posts Schema Markup */
function add_full_blogpost_schema() {
    if (is_single() && 'post' === get_post_type()) {

        $headline = get_the_title();
        $description = get_the_excerpt();
        $datePublished = get_the_date('c');
        $dateModified = get_the_modified_date('c');
        $mainEntityOfPage = get_permalink();

        // Featured image or fallback
        $featured_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
        if (!$featured_image) {
            $featured_image = get_site_url() . '/images/default-blog-cover.jpg';
        }

        // Dynamic logo from Site Identity
        $custom_logo_id = get_theme_mod('custom_logo');
        if ($custom_logo_id) {
            $logo_url = wp_get_attachment_image_url($custom_logo_id, 'full');
        } else {
            $logo_url = get_site_url() . '/wp-content/uploads/2025/02/webhead-logo-header-44ht-black.png';
        }

        $author_name = get_the_author();

        $schema = [
            "@context" => "https://schema.org",
            "@type" => "BlogPosting",
            "mainEntityOfPage" => $mainEntityOfPage,
            "headline" => $headline,
            "description" => $description,
            "image" => $featured_image,
            "author" => [
                "@type" => "Person",
                "name" => $author_name
            ],
            "publisher" => [
                "@type" => "Organization",
                "name" => "Webhead",
                "logo" => [
                    "@type" => "ImageObject",
                    "url" => $logo_url
                ]
            ],
            "datePublished" => $datePublished,
            "dateModified" => $dateModified
        ];

        echo '<script type="application/ld+json">' . wp_json_encode($schema) . '</script>';
    }
}
add_action('wp_head', 'add_full_blogpost_schema');


/* sitemap */

// === Register Menus ===
function custom_theme_register_menus() {
    register_nav_menus( array(
        'main_menu' => 'main_menu',
        'footer'    => 'Footer'
    ));
}
add_action('init', 'custom_theme_register_menus');


// === Sitemap Shortcode: Pull from Main Menu and Footer ===
function visual_main_footer_sitemap_shortcode() {
    $output = '<div style="max-width: 1100px; margin: 0 auto; padding: 60px 20px; text-align: center;">';
    $output .= '<h1 style="font-size: 2.5rem; margin-bottom: 10px;">Website Sitemap</h1>';
    $output .= '<p style="font-size: 1.2rem; color: #777;">Easily navigate to the information that matters most</p>';
    $output .= '<div style="display: flex; flex-wrap: wrap; justify-content: center; margin-top: 50px; gap: 40px;">';

    $locations = get_nav_menu_locations();

    // === Primary Pages from Main Menu ===
    if (isset($locations['main_menu']) && $locations['main_menu'] > 0) {
        $menu = wp_get_nav_menu_object($locations['main_menu']);
        $menu_items = wp_get_nav_menu_items($menu->term_id);

        if ($menu_items) {
            $output .= '<div style="min-width: 200px;">';
            $output .= '<h3 style="font-size: 1.3rem; margin-bottom: 15px;">Primary Pages</h3>';
            $output .= '<ul style="list-style: none; padding: 0;">';

            foreach ($menu_items as $item) {
                $output .= '<li><a href="' . esc_url($item->url) . '" style="text-decoration: none; color: #000;">' . esc_html($item->title) . '</a></li>';
            }

            $output .= '</ul></div>';
        }
    }

    // === Footer Links ===
    if (isset($locations['footer']) && $locations['footer'] > 0) {
        $menu = wp_get_nav_menu_object($locations['footer']);
        $menu_items = wp_get_nav_menu_items($menu->term_id);

        if ($menu_items) {
            $output .= '<div style="min-width: 200px;">';
            $output .= '<h3 style="font-size: 1.3rem; margin-bottom: 15px;">Footer Links</h3>';
            $output .= '<ul style="list-style: none; padding: 0;">';

            foreach ($menu_items as $item) {
                $output .= '<li><a href="' . esc_url($item->url) . '" style="text-decoration: none; color: #000;">' . esc_html($item->title) . '</a></li>';
            }

            $output .= '</ul></div>';
        }
    }

    $output .= '</div></div>'; // Close grid and container

    return $output;
}
add_shortcode('visual_main_footer_sitemap', 'visual_main_footer_sitemap_shortcode');

/*Insert image into first paragraph if one is not included in blog post */

/**
 * ============================================================================
 * FEATURED IMAGE PLACEHOLDER REPLACEMENT & AUTO-INJECTION
 * ----------------------------------------------------------------------------
 * 1. Replaces <img class="blog-post-image-x"> with your featured image.
 * 2. If no placeholder exists, injects the featured image at the top of
 *    the first <p>…</p>, preserving your alignright float.
 * ============================================================================
 */
function replace_or_inject_featured_in_content( $content ) {
    if ( ! is_singular( 'post' ) || ! has_post_thumbnail() ) {
        return $content;
    }

    // Build the real featured-image <img> tag
    $featured_img = get_the_post_thumbnail(
        null,
        'medium',
        [
            'class'    => 'blog-post-image alignright',
            'loading'  => 'lazy',
            'decoding' => 'async',
            'alt'      => get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ),
        ]
    );

    // 1) Replace first <img class="blog-post-image-x"> if present
    if ( preg_match( '/<img\b[^>]*class="[^"]*blog-post-image-x[^"]*"[^>]*>/i', $content ) ) {
        return preg_replace(
            '/<img\b[^>]*class="[^"]*blog-post-image-x[^"]*"[^>]*>/i',
            $featured_img,
            $content,
            1
        );
    }

    // 2) Otherwise inject into the very first paragraph
    return preg_replace(
        '/<p([^>]*)>/i',
        '<p$1>' . $featured_img,
        $content,
        1
    );
}
add_filter( 'the_content', 'replace_or_inject_featured_in_content', 20 );


/* Headings Class Add */

// Print responsive clamp() sizes + Inter font + normal line-height
function webhead_blog_heading_styles() {
    if ( ! ( is_home() || is_archive() || is_singular( 'post' ) ) ) {
        return;
    }

    // Default clamp() sizes (filterable)
    $sizes = apply_filters( 'webhead_blog_heading_sizes', [
        'h1' => 'clamp(2rem, 5vw, 2.5rem)',
        'h2' => 'clamp(1.75rem, 4.5vw, 2rem)',
        'h3' => 'clamp(1.5rem, 4vw, 1.75rem)',
        'h4' => 'clamp(1.25rem, 3.5vw, 1.5rem)',
        'h5' => 'clamp(1.125rem, 3vw, 1.25rem)',
        'h6' => 'clamp(1rem, 2.5vw, 1.125rem)',
    ] );

    // build inline CSS
    $css = '';
    foreach ( $sizes as $tag => $clamp ) {
        $css .= sprintf(
            '%1$s.webhead-blog-post, %1$s.title.rs-split-text-disable{'
          . 'font-family:"Inter",sans-serif!important;'
          . 'font-size:%2$s!important;'
          . 'line-height:normal!important;}',
            esc_html( $tag ),
            esc_html( $clamp )
        );
    }

    // enqueue late so it overrides everything
    wp_register_style( 'webhead-blog-headings', false );
    wp_enqueue_style(  'webhead-blog-headings' );
    wp_add_inline_style( 'webhead-blog-headings', $css );
}
add_action( 'wp_enqueue_scripts', 'webhead_blog_heading_styles', 999 );

