<?php
/**
 * In-template filter to replace the first <img class="blog-post-image-x">
 * with the post’s featured image when rendering a single post.
 *
 * NOTE: Best practice is to put this in your theme’s functions.php.
 * But here it’s merged at the top of single.php per your request.
 */
function replace_placeholder_with_featured( $content ) {
    if ( ! is_singular( 'post' ) || ! has_post_thumbnail() ) {
        return $content;
    }

    // Build the featured-image HTML (size “medium”)
    $featured_img = get_the_post_thumbnail(
        null,
        'medium',
        [
            'class'    => 'blog-post-image alignright',
            'loading'  => 'lazy',
            'decoding' => 'async',
            'alt'      => get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ),
        ]
    );

    // Replace only the first occurrence of the placeholder <img class="blog-post-image-x">
    $content = preg_replace(
        '/<img\b[^>]*class="[^"]*blog-post-image-x[^"]*"[^>]*>/i',
        $featured_img,
        $content,
        1
    );

    return $content;
}
add_filter( 'the_content', 'replace_placeholder_with_featured', 20 );


/** ——— The rest of your single.php template ——— */

get_header();
$post_id      = get_the_id();
$author_id    = get_post_field( 'post_author', $post_id );
$display_name = get_the_author_meta( 'display_name', $author_id );
?>
<div class="container"> 
    <div id="webhead-blog-post-content" class="webhead-blog-content">
        <?php
        // page layout
        $page_layout                      = get_theme_mod( 'techtlk_blog_single_sidebar_setting' );
        $col_side                         = '';
        $col_letf                         = '';
        if ( $page_layout === '2left' ) {
            $col_side = '8';
            $col_letf = 'left-sidebar';
        } elseif ( $page_layout === '2right' ) {
            $col_side = '8';
        } else {
            $col_side = '12';
        }

        // meta visibility
        $techtlk_blog_single_hide_author      = get_theme_mod( 'techtlk_blog_single_hide_author' );
        $techtlk_blog_single_hide_comment     = get_theme_mod( 'techtlk_blog_single_hide_comment' );
        $techtlk_blog_single_hide_published   = get_theme_mod( 'techtlk_blog_single_hide_published' );
        $techtlk_blog_single_hide_categiry    = get_theme_mod( 'techtlk_blog_single_hide_categiry' );
        $techtlk_blog_single_feature_img_in_col = get_theme_mod( 'techtlk_blog_single_feature_img_in_col' ) ?: '';
        $heading_tag                          = get_theme_mod( 'techtlk_blog_single_heading_tag_setting' ) ?: 'h1';
        ?>

      <!-- Blog Detail Start -->
        <div class="rs-blog-details">
            <div class="row padding-<?php echo esc_attr( $col_letf ); ?>">
                <div class="col-lg-<?php echo esc_attr( $col_side ) . ' ' . esc_attr( $col_letf ); ?>">
                    <?php while ( have_posts() ) : the_post(); ?>
                      <article id="post-<?php the_ID(); ?>" <?php post_class('webhead-blog-post'); ?>>

                            <?php if ( has_post_thumbnail() && $techtlk_blog_single_feature_img_in_col ) : ?>
                                <div class="bs-img">
                                    <?php the_post_thumbnail(); ?>
                                </div>

                                <?php if ( did_action( 'elementor/loaded' ) && ( function_exists( 'rshfe_plugin_activation' ) || function_exists( 'hfe_plugin_activation' ) ) ) : ?>
                                    <div class="rs-blog-single-meta inside-col"> 
                                        <<?php echo esc_html( $heading_tag ); ?> class="page-title webhead-blog-post">
                                            <?php the_title(); ?>
                                        </<?php echo esc_html( $heading_tag ); ?>>

                                        <?php if ( ! ( $techtlk_blog_single_hide_author === '1'
                                                   && $techtlk_blog_single_hide_comment === '1'
                                                   && $techtlk_blog_single_hide_published === '1'
                                                   && $techtlk_blog_single_hide_categiry === '1' ) ) : ?>
                                            <ul class="bs-meta-area">
                                                <?php if ( $techtlk_blog_single_hide_author !== '1' ) : ?>
                                                    <li class="author">
                                                        <!-- SVG … -->
                                                        <?php echo esc_html( $display_name ); ?>
                                                    </li>
                                                <?php endif; ?>

                                                <?php if ( $techtlk_blog_single_hide_published !== '1' ) : ?>
                                                    <li>
                                                        <!-- SVG … -->
                                                        <?php echo get_the_date(); ?>
                                                    </li>
                                                <?php endif; ?>

                                                <?php if ( $techtlk_blog_single_hide_categiry !== '1' ) : ?>
                                                    <li>
                                                        <!-- SVG … -->
                                                        <span class="tag-line"><?php the_category( ', ' ); ?></span>
                                                    </li>
                                                <?php endif; ?>

                                                <?php if ( $techtlk_blog_single_hide_comment !== '1' ) : ?>
                                                    <li>
                                                        <!-- SVG … -->
                                                        <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php
                            // This will automatically have the first <img class="blog-post-image-x"> replaced
                            get_template_part( 'template-parts/post/content', get_post_format() );
                            ?>

                            <div class="clear-fix"></div>           
                        </article> 

                        <?php
                        // Author bio
                        $author_meta = get_the_author_meta( 'description' );
                        if ( $author_meta ) : ?>
                            <div class="author-block">
                                <div class="author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 260 ); ?></div>
                                <div class="author-desc">
                                    <h3 class="author-title"><?php the_author(); ?></h3>
                                    <p><?php echo wpautop( $author_meta ); ?></p>
                                    <a href="<?php echo esc_url( get_the_author_meta( 'user_url' ) ); ?>" target="_blank">
                                        <?php echo esc_url( get_the_author_meta( 'user_url' ) ); ?>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php
                        // Comments
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;

                    endwhile; // End of the loop.
                    ?>

                </div>

                <?php
                if ( in_array( $page_layout, [ '2left', '2right' ], true ) ) {
                    get_sidebar( 'single' );
                }
                ?>
            </div>
        </div>
      <!-- Blog Detail End --> 

    </div>
</div>

<?php
get_footer();
