<?php
/**
 * @author  rs-theme
 * @since   1.0
 * @version 1.0 
 */

if ( ! function_exists( 'techtlk_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */ 

define( 'TECHTLK_THEME_DIR', get_template_directory() );
define( 'TECHTLK_THEME_URI', get_template_directory_uri() );
define( 'TECHTLK_THEME_SUB_DIR', TECHTLK_THEME_DIR.'/inc/' );
define( 'TECHTLK_THEME_CSS_DIR', TECHTLK_THEME_URI.'/css/' );
define( 'TECHTLK_THEME_JS_DIR', TECHTLK_THEME_URI.'/js/' );

function techtlk_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on techtlk, use a find and replace
	 * to change 'techtlk' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'techtlk', get_template_directory() . '/languages' );


	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );	
	
	function techtlk_change_excerpt( $text )
	{
		$pos = strrpos( $text, '[');
		if ($pos === false)
		{
			return $text;
		}
		
		return rtrim (substr($text, 0, $pos) ) . '...';
	}
	add_filter('get_the_excerpt', 'techtlk_change_excerpt');


	// Limit Excerpt Length by number of Words
	function techtlk_custom_excerpt( $limit ) {
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt).'...';
		} else {
		$excerpt = implode(" ",$excerpt);
		}
		$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
		return $excerpt;
		}
		function content($limit) {
		$content = explode(' ', get_the_content(), $limit);
		if (count($content)>=$limit) {
		array_pop($content);
		$content = implode(" ",$content).'...';
		} else {
		$content = implode(" ",$content);
		}
		$content = preg_replace('/[.+]/','', $content);
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'menu-1' => esc_html__( 'Primary Menu', 'techtlk' ),
		'menu-2' => esc_html__( 'Mobile Menu', 'techtlk' ),
		'menu-3' => esc_html__( 'Onepage Menu', 'techtlk' ),
	) );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'techtlk_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support( 'custom-logo', array(
		'height'      => 250,
		'width'       => 250,
		'flex-width'  => true,
		'flex-height' => true,
	) );

	//add support posts format
	add_theme_support( 'post-formats', array( 
		'aside', 
		'gallery',
		'audio',
		'video',
		'image',
		'quote',
		'link',
	) );

add_theme_support( 'align-wide' );	
}

endif;
add_action( 'after_setup_theme', 'techtlk_setup' );


/**
*Custom Image Size
*/

add_image_size( 'techtlk_portfolio-slider', 520, 640, true );
add_image_size( 'techtlk_blog-transparent', 700, 600, true );
add_image_size( 'techtlk_blog-single', 1200, 630, true );
add_image_size( 'techtlk_portfolio-slider-four', 416, 340, true );
add_image_size( 'techtlk_service-grid', 352, 199, true );
add_image_size( 'techtlk_portfolio-slider', 666, 450, true );
add_image_size( 'techtlk_portfolio-grid-large', 834, 550, true );
add_image_size( 'techtlk_portfolio-grid2', 434, 450, true );
add_image_size( 'techtlk_portfolio-grid-small', 413, 269, true );
add_image_size( 'techtlk_portfolio-grid-architecture1', 421, 550, true );
add_image_size( 'techtlk_team-member-grid', 414, 500, true );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function techtlk_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'techtlk_content_width', 640 );
}
add_action( 'after_setup_theme', 'techtlk_content_width', 0 );

/**
 * Implement the Custom Header feature.
 */
require_once get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 *  Enqueue scripts and styles.
 */
require_once get_template_directory() . '/inc/template-scripts.php';



/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once get_template_directory() . '/inc/template-functions.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once get_template_directory() . '/inc/template-sidebar.php';

/**
 * Customizer additions.
 */
require_once get_template_directory() . '/inc/customizer.php';


/**
 * Customizer additions.
 */
require_once TECHTLK_THEME_SUB_DIR.'/customizer/includes.php';

$licenseKey = get_option("TechtlkWordPressTheme_lic_Key","");

if (!empty($licenseKey)){
	require_once get_template_directory() . '/framework/custom.php';
	require_once get_template_directory() . '/inc/woocommerce-functions.php';
}

if (is_admin()){
	require_once get_template_directory() . '/framework/ini/class-rstheme-licenser.php';
	require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
	require_once get_template_directory() . '/framework/tgm-config.php';	
}


/**
 * Registers an editor stylesheet for the theme.
 */
function techtlk_theme_add_editor_styles() {
    add_editor_style( 'css/custom-editor-style.css' );
}
add_action( 'admin_init', 'techtlk_theme_add_editor_styles' );


//------------------------------------------------------------------------
//Organize Comments form field
//-----------------------------------------------------------------------
function techtlk_wpb_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}

add_filter( 'comment_form_fields', 'techtlk_wpb_move_comment_field_to_bottom' );	

add_filter( 'get_the_archive_title', function ($title) {
    if ( is_category() ) {
            $title = single_cat_title( '', false );
        } elseif ( is_tag() ) {
            $title = single_tag_title( '', false );
        } elseif ( is_author() ) {
            $title = '<span class="vcard">' . get_the_author() . '</span>' ;
        }
    return $title;
});



function techtlk_comment_textarea_placeholder( $args ) {
	$replace_comment = __('Comment*', 'techtlk');
	$args['comment_field']        = str_replace( '<textarea', '<textarea placeholder="'.$replace_comment.'"', $args['comment_field'] );
	return $args;
}
add_filter( 'comment_form_defaults', 'techtlk_comment_textarea_placeholder' );

/**
 * 
 * Comment Form Fields Placeholder
 *
 */
function techtlk_comment_form_fields( $fields ) {
	$replace_author = __('Name*', 'techtlk');
    $replace_email = __('Email*', 'techtlk');
    $website_url = __('Website', 'techtlk');
	foreach( $fields as &$field ) {
		$field = str_replace( 'id="author"', 'id="author" placeholder="'.$replace_author.'"', $field );
		$field = str_replace( 'id="email"', 'id="email" placeholder="'.$replace_email.'"', $field );
		$field = str_replace( 'id="url"', 'id="url" placeholder="'.$website_url.'"', $field );
	}
	return $fields;
}
add_filter( 'comment_form_default_fields', 'techtlk_comment_form_fields' );