<?php
function techtlk_404_panel($techtlk_customizer, $priority)
{
    $techtlk_customizer->add_section('techtlk_404_setting',
        array(
            'title'       => esc_html__('404 Page Settings', 'techtlk'),
            'panel'       => 'techtlk_options_panel',
            'priority'    => $priority,
            'capability'  => 'edit_theme_options',
            'description' => esc_html__('Allows you to customize 404 page.', 'techtlk'),
        )
    );

    //404
    $techtlk_customizer->add_setting('techtlk_404_title', array(
        'default'   => esc_html__('404', 'techtlk'),
        'transport' => 'refresh',
    ));
    $techtlk_customizer->add_control('techtlk_404_title', array(
        'label'       => esc_html__('Title', 'techtlk'),
        'description' => esc_html__('Enter title for 404 page', 'techtlk'),
        'section'     => 'techtlk_404_setting',
        'type'        => 'text',
        'setting'     => 'techtlk_404_title',
    ));

    //Start separator
    $techtlk_customizer->add_setting(
        '404_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            '404_hr_0',
            array(
                'settings' => '404_hr_0',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //404
    $techtlk_customizer->add_setting('techtlk_404_text', array(
        'default'   => esc_html__('Page Not Found', 'techtlk'),
        'transport' => 'refresh',
    ));
    $techtlk_customizer->add_control('techtlk_404_text', array(
        'label'       => esc_html__('Text', 'techtlk'),
        'description' => esc_html__('Enter text for 404 page', 'techtlk'),
        'section'     => 'techtlk_404_setting',
        'type'        => 'text',
        'setting'     => 'techtlk_404_text',
    ));
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        '404_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            '404_hr_1',
            array(
                'settings' => '404_hr_1',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //404
    $techtlk_customizer->add_setting('techtlk_404_home_button_label', array(
        'default'   => esc_html__('Back to Homepage', 'techtlk'),
        'transport' => 'refresh',
    ));
    $techtlk_customizer->add_control('techtlk_404_home_button_label', array(
        'label'       => esc_html__('Back to Home Button Label', 'techtlk'),
        'description' => esc_html__('Enter label for "Back to Home" button', 'techtlk'),
        'section'     => 'techtlk_404_setting',
        'type'        => 'text',
        'setting'     => 'techtlk_404_home_button_label',
    ));
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        '404_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            '404_hr_2',
            array(
                'settings' => '404_hr_2',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //Start default header logo
    $techtlk_customizer->add_setting(
        'techtlk_404_page_bg',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Image_Control(
            $techtlk_customizer,
            'techtlk_404_page_bg',
            array(
                'label'    => esc_html__('Upload 404 Page Bg', 'techtlk'),
                'section'  => 'techtlk_404_setting',
                'settings' => 'techtlk_404_page_bg',
            )
        )
    );
    //End default logo

    //Start separator
    $techtlk_customizer->add_setting(
        'team_hr_3',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'team_hr_3',
            array(
                'settings' => 'team_hr_3',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $techtlk_customizer->add_setting(
        'techtlk_404_text_color',
        array(
            'default' => '#FFFFFF',
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_404_text_color',
            array(
                'label'       => esc_html__('Text Color', 'techtlk'),
                'description' => esc_html__('Text Color', 'techtlk'),
                'section'     => 'techtlk_404_setting',
                'settings'    => 'techtlk_404_text_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $techtlk_customizer->add_setting(
        'team_hr_4',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'team_hr_4',
            array(
                'settings' => 'team_hr_4',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //Start Color
    $techtlk_customizer->add_setting(
        'techtlk_404_btn_bg_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_404_btn_bg_color',
            array(
                'label'       => esc_html__('Button Background Color', 'techtlk'),
                'description' => esc_html__('choose button background color', 'techtlk'),
                'section'     => 'techtlk_404_setting',
                'settings'    => 'techtlk_404_btn_bg_color',
            )
        )
    );
    //End Color

    //Start separator
    $techtlk_customizer->add_setting(
        'team_hr_5',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'team_hr_5',
            array(
                'settings' => 'team_hr_5',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

    //Start Color
    $techtlk_customizer->add_setting(
        'techtlk_404_btn_text_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_404_btn_text_color',
            array(
                'label'       => esc_html__('Button Text Color', 'techtlk'),
                'description' => esc_html__('Choose button text color', 'techtlk'),
                'section'     => 'techtlk_404_setting',
                'settings'    => 'techtlk_404_btn_text_color',
            )
        )
    );
    //End Color

    //Start separator
    $techtlk_customizer->add_setting(
        'team_hr_6',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'team_hr_6',
            array(
                'settings' => 'team_hr_6',
                'section'  => 'techtlk_404_setting',
            )
        )
    );
    //End separator

}
