<?php
function techtlk_blog_page_style_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_blog_page_style_setting' , array(
        'title'      => esc_html__( 'Blog Page', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_blog_setting'
    ) );

	//Start default Page Banner
	$techtlk_customizer->add_setting(
		'techtlk_blog_page_bg', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'techtlk_blog_page_bg',
			array(
			'label'      => esc_html__( 'Blog Page Image', 'techtlk' ),
			'section'    => 'techtlk_blog_page_style_setting',
			'settings'   => 'techtlk_blog_page_bg',
			)
		)   
	);
	//End default Page Banner

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_0', 
			array(
				'settings'		=> 'blog_page_hr_0',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator
	

	//Start Background Color
	$techtlk_customizer->add_setting (
        'techtlk_blog_page_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_blog_page_bg_color',
            array(
                'label'      => esc_html__('Body Backgroud Color','techtlk'),
                'description'      => esc_html__('Pick body background color','techtlk'),
                'section'    => 'techtlk_blog_page_style_setting',
                'settings'   => 'techtlk_blog_page_bg_color',
            )
        )
    );
	//End Background Color

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_1', 
			array(
				'settings'		=> 'blog_page_hr_1',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator


	//Start
	$techtlk_customizer->add_setting( 'techtlk_blog_page_sidebar_setting', array(
		'default'           => 'blog_no_sidebar',
		'transport'	        => 'postMessage',
	) );
	$techtlk_customizer->add_control( 'techtlk_blog_page_sidebar_setting', array(
		'label'   => esc_html__( 'Sidebar Setting', 'techtlk' ),
		'section' => 'techtlk_blog_page_style_setting',
		'type'    => 'select',
		'choices' => array(
			'blog_no_sidebar' => esc_html__( 'Full Width', 'techtlk' ),
			'blog_left_sidebar' => esc_html__( 'Left Sidebar', 'techtlk' ),
			'blog_right_sidebar'  => esc_html__( 'Right Sidebar', 'techtlk' ),
		),
	) );
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_4', 
			array(
				'settings'		=> 'blog_page_hr_4',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Author
	$techtlk_customizer->add_setting( 'techtlk_blog_page_hide_author', 
	array(
		'default'           => 0,
	)
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_page_hide_author',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Author','techtlk'),
				'description' => esc_html__('If you want to hide author click ON button','techtlk'),
				'section' => 'techtlk_blog_page_style_setting'
			)
		)
	);
	//End Hide Author

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_5', 
			array(
				'settings'		=> 'blog_page_hr_5',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$techtlk_customizer->add_setting( 'techtlk_blog_page_hide_date', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_page_hide_date',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Date','techtlk'),
				'description' => esc_html__('If you want to hide date click ON button','techtlk'),
				'section' => 'techtlk_blog_page_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_6', 
			array(
				'settings'		=> 'blog_page_hr_6',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$techtlk_customizer->add_setting( 'techtlk_blog_page_hide_categiry', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_page_hide_categiry',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Category','techtlk'),
				'description' => esc_html__('If you want to hide categoy click ON button','techtlk'),
				'section' => 'techtlk_blog_page_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_7', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_7', 
			array(
				'settings'		=> 'blog_page_hr_7',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Blog Page Custom Title
	$techtlk_customizer->add_setting(
		'techtlk_blog_page_custom_read_more',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('techtlk_blog_page_custom_read_more', array(
        'section'	=> 'techtlk_blog_page_style_setting',
        'label'		=> esc_html__( 'Blog Read More Text', 'techtlk' ),
        'description' => esc_html__( 'Enter Blog Read More Here', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'techtlk_blog_page_custom_read_more'
    ));
	//End Blog Page Custom Title

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_page_hr_8', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_page_hr_8', 
			array(
				'settings'		=> 'blog_page_hr_8',
				'section'  		=> 'techtlk_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting( 'techtlk_blog_page_btn_setting', array(
	 	'default'           => 'rs-flat',
	 	'transport'	        => 'postMessage',
	));

	$techtlk_customizer->add_control( 'techtlk_blog_page_btn_setting', array(
	 	'label'   => esc_html__( 'Button Setting', 'techtlk' ),
	 	'section' => 'techtlk_blog_page_style_setting',
	 	'type'    => 'select',
	 	'choices' => array(
	 		'rs-default' => esc_html__( 'Default Style', 'techtlk' ),
	 		'rs-border' => esc_html__( 'Border Style', 'techtlk' ),
	 		'rs-flat' => esc_html__( 'Flat Style', 'techtlk' )
	 	),
	));
	//End
}