<?php
function techtlk_blog_single_style_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_blog_single_style_setting' , array(
        'title'      => esc_html__( 'Blog Single', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_blog_setting'
    ) );


	//Start
	$techtlk_customizer->add_setting( 'techtlk_blog_single_sidebar_setting', array(
		'default'           => 'blog_single_no_sidebar',
		'transport'	        => 'postMessage',
	) );
	$techtlk_customizer->add_control( 'techtlk_blog_single_sidebar_setting', array(
		'label'   => esc_html__( 'Sidebar Setting', 'techtlk' ),
		'section' => 'techtlk_blog_single_style_setting',
		'type'    => 'select',
		'choices' => array(
			'blog_single_no_sidebar' => esc_html__( 'Full Width', 'techtlk' ),
			'2left' => esc_html__( 'Left Sidebar', 'techtlk' ),
			'2right'  => esc_html__( 'Right Sidebar', 'techtlk' ),
		),
	) );
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_00', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_00', 
			array(
				'settings'		=> 'blog_single_hr_00',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Author
	$techtlk_customizer->add_setting( 'techtlk_blog_single_hide_author', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_single_hide_author',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Author','techtlk'),
				'description' => esc_html__('You can show or hide Author','techtlk'),
				'section' => 'techtlk_blog_single_style_setting'
			)
		)
	);
	//End Hide Author

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_1', 
			array(
				'settings'		=> 'blog_single_hr_1',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$techtlk_customizer->add_setting( 'techtlk_blog_single_hide_comment', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_single_hide_comment',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Comment','techtlk'),
				'description' => esc_html__('You can show or hide comment','techtlk'),
				'section' => 'techtlk_blog_single_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_2', 
			array(
				'settings'		=> 'blog_single_hr_2',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Published
	$techtlk_customizer->add_setting( 'techtlk_blog_single_hide_published', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_single_hide_published',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Published','techtlk'),
				'description' => esc_html__('You can show or hide published','techtlk'),
				'section' => 'techtlk_blog_single_style_setting'
			)
		)
	);
	//End Hide Published

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_3', 
			array(
				'settings'		=> 'blog_single_hr_3',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Category
	$techtlk_customizer->add_setting( 'techtlk_blog_single_hide_categiry', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_single_hide_categiry',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Category','techtlk'),
				'description' => esc_html__('You can show or hide categiry','techtlk'),
				'section' => 'techtlk_blog_single_style_setting'
			)
		)
	);
	//End Hide Category

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_4', 
			array(
				'settings'		=> 'blog_single_hr_4',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	$techtlk_customizer->add_setting( 'techtlk_blog_single_feature_img_in_col', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_blog_single_feature_img_in_col',
			array(
				'type' => 'switch',
				'label' => esc_html__('Feature Image Inside','techtlk'),
				'description' => esc_html__('Enable if you want feature image inside column.','techtlk'),
				'section' => 'techtlk_blog_single_style_setting'
			)
		)
	);
	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_5', 
			array(
				'settings'		=> 'blog_single_hr_5',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Title Tag
	$techtlk_customizer->add_setting( 'techtlk_blog_single_heading_tag_setting', array(
		'default'           => 'h1',
		'transport'	        => 'postMessage',
	) );
	$techtlk_customizer->add_control( 'techtlk_blog_single_heading_tag_setting', array(
		'label'   => esc_html__( 'Blog Title Tag', 'techtlk' ),
		'section' => 'techtlk_blog_single_style_setting',
		'type'    => 'select',
		'choices' => array(
			'h1' => esc_html__( 'H1', 'techtlk' ),
			'h2' => esc_html__( 'H2', 'techtlk' ),
			'h3'  => esc_html__( 'H3', 'techtlk' ),
			'h4'  => esc_html__( 'H4', 'techtlk' ),
			'h5'  => esc_html__( 'H5', 'techtlk' ),
			'h6'  => esc_html__( 'H6', 'techtlk' ),
		),
	) );
	//End Title Tag

	//Start separator
	$techtlk_customizer->add_setting(
		'blog_single_hr_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'blog_single_hr_6', 
			array(
				'settings'		=> 'blog_single_hr_6',
				'section'  		=> 'techtlk_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Page Padding
	$techtlk_customizer->add_setting(
		'techtlk_blog_single_page_padding',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('techtlk_blog_single_page_padding', array(
        'section'	=> 'techtlk_blog_single_style_setting',
        'label'		=> esc_html__( 'Page Padding', 'techtlk' ),
        'description' => esc_html__( 'Example: 100px 0px 100px 0px', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'techtlk_blog_single_page_padding'
    ));
	//End Page Padding
}