<?php
function techtlk_custom_fonts_panel($techtlk_customizer, $priority)
{
    $techtlk_customizer->add_section('techtlk_custom_fonts_panel', array(
        'title'    => esc_html__('Custom Fonts Settings', 'techtlk'),
        'priority' => $priority,
        'panel'    => 'techtlk_options_panel',
    ));

    $font_weight = [
        'normal' => esc_html__('Normal', 'techtlk' ),
        '300' => esc_html__('300', 'techtlk' ),
        '400' => esc_html__('400', 'techtlk' ),
        '500' => esc_html__('500', 'techtlk' ),
        '600' => esc_html__('600', 'techtlk' ),
        '700' => esc_html__('700', 'techtlk' ),
        '800' => esc_html__('800', 'techtlk' ),
        '900' => esc_html__('900', 'techtlk' ),
    ];

    //Start
    $techtlk_customizer->add_setting(
        'techtlk_custom_font_file', 
        array(
        'transport'     => 'refresh'
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Upload_Control(
        $techtlk_customizer,
        'techtlk_custom_font_file',
            array(
            'label'      => esc_html__( 'Upload Body Font Here', 'techtlk' ),
            'section'    => 'techtlk_custom_fonts_panel',
            'settings'   => 'techtlk_custom_font_file',
            )
        )   
    );
    //End

    //Start
    $techtlk_customizer->add_setting( 'techtlk_custom_body_font_weight', array(
        'default' => 'normal'
    ));

    $techtlk_customizer->add_control( 'techtlk_custom_body_font_weight', array(
        'type'        => 'select',
        'label'       => esc_html__( 'Font Weight', 'techtlk' ),
        'description' => __( 'Select font Weight', 'techtlk' ),
        'section'     => 'techtlk_custom_fonts_panel',
        'choices'     => $font_weight
    ));
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        'separator_1', 
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer, 
            'separator_15', 
            array(
                'settings'      => 'separator_1',
                'section'       => 'techtlk_custom_fonts_panel',
            )
        )
    );
    //End separator

    //Start
    $techtlk_customizer->add_setting(
        'techtlk_title_custom_font_file', 
        array(
        'transport'     => 'refresh'
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Upload_Control(
        $techtlk_customizer,
        'techtlk_title_custom_font_file',
            array(
            'label'      => esc_html__( 'Upload Heading Font Here', 'techtlk' ),
            'section'    => 'techtlk_custom_fonts_panel',
            'settings'   => 'techtlk_title_custom_font_file',
            )
        )   
    );
    //End

    //Start
    $techtlk_customizer->add_setting( 'techtlk_custom_title_font_weight', array(
        'default' => 'normal'
    ));
    
    $techtlk_customizer->add_control( 'techtlk_custom_title_font_weight', array(
        'type'        => 'select',
        'label'       => esc_html__( 'Font Weight', 'techtlk' ),
        'description' => __( 'Select font Weight', 'techtlk' ),
        'section'     => 'techtlk_custom_fonts_panel',
        'choices'     => $font_weight
    ));
    //End
}
