<?php
function techtlk_general_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section(
		'techtlk_general_section',
		array(
			'title'    => esc_html__( 'General Settings', 'techtlk' ),
			'priority' => $priority,
			'panel'    => 'techtlk_options_panel'
		)
	);


	//Start separator
	$techtlk_customizer->add_setting(
		'separator_14', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_14', 
			array(
				'settings'		=> 'separator_14',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start default header logo
	$techtlk_customizer->add_setting(
		'rstheme_default_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'rstheme_default_logo',
			array(
			'label'      => esc_html__( 'Upload Default Logo', 'techtlk' ),
			'section'    => 'techtlk_general_section',
			'settings'   => 'rstheme_default_logo',
			)
		)   
	);
	//End default logo

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_15', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_15', 
			array(
				'settings'		=> 'separator_15',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_3', 
			array(
				'settings'		=> 'separator_3',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Logo Height
	$techtlk_customizer->add_setting(
		'rstheme_logo_height',
		array(
			'default' => esc_html__( '', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('rstheme_logo_height', array(
        'section'	=> 'techtlk_general_section',
        'label'		=> esc_html__( 'Logo Height', 'techtlk' ),
        'description' => esc_html__( 'Logo max height example(50px)', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_logo_height'
    ));
	//End Logo Height

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_4', 
			array(
				'settings'		=> 'separator_4',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Sticky Menu
	$techtlk_customizer->add_setting( 'rstheme_enable_sticky_menu', 
	array(
			'default'    => '0',
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'rstheme_enable_sticky_menu',
			array(
				'type' => 'switch',
				'label' => esc_html__('Sticky Menu','techtlk'),
				'description' => esc_html__('You can show or hide sticky menu here','techtlk'),
				'section' => 'techtlk_general_section'
			)
		)
	);
	//End Sticky Menu

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_9', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_9', 
			array(
				'settings'		=> 'separator_9',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Sticky logo
	$techtlk_customizer->add_setting(
		'rstheme_sticky_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'rstheme_sticky_logo',
			array(
			'label'      => esc_html__( 'Upload Your Sticky Logo', 'techtlk' ),
			'section'    => 'techtlk_general_section',
			'settings'   => 'rstheme_sticky_logo',
			)
		)   
	);
	//End Sticky logo

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_7', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_7', 
			array(
				'settings'		=> 'separator_7',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Sticky Logo Height
	$techtlk_customizer->add_setting(
		'rstheme_sticky_logo_height',
		array(
			'default' => esc_html__( '25px', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('rstheme_sticky_logo_height', array(
        'section'	=> 'techtlk_general_section',
        'label'		=> esc_html__( 'Sticky Logo Height', 'techtlk' ),
        'description' => esc_html__( 'Sticky Logo max height example(20px)', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_sticky_logo_height'
    ));
	//End Sticky Logo Height

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_180', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_180', 
			array(
				'settings'		=> 'separator_180',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Footer logo
	$techtlk_customizer->add_setting(
		'rstheme_footer_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'rstheme_footer_logo',
			array(
			'label'      => esc_html__( 'Upload Your Footer Logo', 'techtlk' ),
			'section'    => 'techtlk_general_section',
			'settings'   => 'rstheme_footer_logo',
			)
		)   
	);
	//End Footer logo

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_181', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_181', 
			array(
				'settings'		=> 'separator_181',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start Footer Logo Height
	$techtlk_customizer->add_setting(
		'rstheme_footer_logo_height',
		array(
			'default' => esc_html__( '36px', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('rstheme_footer_logo_height', array(
        'section'	=> 'techtlk_general_section',
        'label'		=> esc_html__( 'Footer Logo Height', 'techtlk' ),
        'description' => esc_html__( 'Footer Logo max height example(36px)', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_footer_logo_height'
    ));
	//End Footer Logo Height

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_80', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_80', 
			array(
				'settings'		=> 'separator_80',
				'section'  		=> 'techtlk_general_section',
			)
		)
	);
	//End separator

	//Start favicon
	$techtlk_customizer->add_setting(
		'techtlk_favicon', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'techtlk_favicon',
			array(
			'label'      => esc_html__( 'Upload Favicon', 'techtlk' ),
			'section'    => 'techtlk_general_section',
			'settings'   => 'techtlk_favicon',
			)
		)   
	);
	//End favicon
}