<?php
function techtlk_gsap_animation_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_gsap_animation_setting' , array(
        'title'      => esc_html__( 'GSAP Animation Setting', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

	// GSAP Control Start
	$techtlk_customizer->add_setting( 'gsap_animation_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'gsap_animation_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('GSAP Animation','techtlk'),
				'description' => esc_html__('You can enable or disable GSAP Animation here','techtlk'),
				'section' => 'techtlk_gsap_animation_setting'
			)
		)
	);
	// GSAP Control End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_0', 
			array(
				'settings'		=> 'separator_0',
				'section'  		=> 'techtlk_gsap_animation_setting',
			)
		)
	);
	//End separator

	// GSAP Custom Cursor Control Start
	$techtlk_customizer->add_setting( 'gsap_custom_cursor_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'gsap_custom_cursor_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('Custom Cursor','techtlk'),
				'description' => esc_html__('You can enable or disable custom cursor. If GSAP Animation is on then it will work.','techtlk'),
				'section' => 'techtlk_gsap_animation_setting'
			)
		)
	);
	// GSAP Custom Cursor Control End
}