<?php
function techtlk_header_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_header_setting' , array(
        'title'      => esc_html__( 'Header Settings', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_header_sign_in_text',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('techtlk_header_sign_in_text', array(
        'section' => 'techtlk_header_setting',
        'label'   => esc_html__('Sign In', 'techtlk'),
        'type'    => 'text',
        'setting' => 'techtlk_header_sign_in_text',
    ));
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_0', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_0', 
			array(
				'settings'		=> 'header_hr_0',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_sign_in_text_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_sign_in_text_color',
            array(
                'label'       => esc_html__('Text Color','techtlk'),
                'description' => esc_html__('Select Text Color','techtlk'),
                'section'     => 'techtlk_header_setting',
                'settings'    => 'techtlk_header_sign_in_text_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_1', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_1', 
			array(
				'settings'		=> 'header_hr_1',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_sign_in_text_hover_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_sign_in_text_hover_color',
            array(
                'label'       => esc_html__('Hover Color','techtlk'),
                'description' => esc_html__('Select Hover Color','techtlk'),
                'section'     => 'techtlk_header_setting',
                'settings'    => 'techtlk_header_sign_in_text_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_2', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_2', 
			array(
				'settings'		=> 'header_hr_2',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_header_sign_in_link',
        array(
			'default' => esc_html__( '#', 'techtlk' ),
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('techtlk_header_sign_in_link', array(
        'section' => 'techtlk_header_setting',
        'label'   => esc_html__('Sign In Link', 'techtlk'),
        'type'    => 'text',
        'setting' => 'techtlk_header_sign_in_link',
    ));
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_3', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_3', 
			array(
				'settings'		=> 'header_hr_3',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting( 'techtlk_header_sign_in_link_new_tab', 
	array(
		'default'    => '1',
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_header_sign_in_link_new_tab',
			array(
				'type'        => 'switch',
				'label'       => esc_html__('Open New Tab','techtlk'),
				'description' => esc_html__('Open the link document in a new window or tab','techtlk'),
				'section'     => 'techtlk_header_setting'
			)
		)
	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_4', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_4', 
			array(
				'settings'		=> 'header_hr_4',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_header_download_text',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('techtlk_header_download_text', array(
        'section' => 'techtlk_header_setting',
        'label'   => esc_html__('Download', 'techtlk'),
        'type'    => 'text',
        'setting' => 'techtlk_header_download_text',
    ));
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_5', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_5', 
			array(
				'settings'		=> 'header_hr_5',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_download_border_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_download_border_color',
            array(
                'label'      => esc_html__('Border Color','techtlk'),
                'description'      => esc_html__('Select Button Border Color','techtlk'),
                'section'    => 'techtlk_header_setting',
                'settings'   => 'techtlk_header_download_border_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_6', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_6', 
			array(
				'settings'		=> 'header_hr_6',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_download_text_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_download_text_color',
            array(
                'label'      => esc_html__('Text Color','techtlk'),
                'description'      => esc_html__('Select text Color','techtlk'),
                'section'    => 'techtlk_header_setting',
                'settings'   => 'techtlk_header_download_text_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_7', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_7', 
			array(
				'settings'		=> 'header_hr_7',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_download_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_download_text_hover_color',
            array(
                'label'      => esc_html__('Text Hover Color','techtlk'),
                'description'      => esc_html__('Select Text Hover Color','techtlk'),
                'section'    => 'techtlk_header_setting',
                'settings'   => 'techtlk_header_download_text_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_8', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_8', 
			array(
				'settings'		=> 'header_hr_8',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_header_download_btn_hover_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_header_download_btn_hover_color',
            array(
                'label'      => esc_html__('Button Hover Color','techtlk'),
                'description'      => esc_html__('Select Button Hover Color','techtlk'),
                'section'    => 'techtlk_header_setting',
                'settings'   => 'techtlk_header_download_btn_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_9', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_9', 
			array(
				'settings'		=> 'header_hr_9',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_header_download_link',
        array(
            'default' => esc_html__( '#', 'techtlk' ),
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('techtlk_header_download_link', array(
        'section' => 'techtlk_header_setting',
        'label' => esc_html__('Download Link', 'techtlk'),
        'type' => 'text',
        'setting' => 'techtlk_header_download_link',
    ));
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_10', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_10', 
			array(
				'settings'		=> 'header_hr_10',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Show Top Bar
	$techtlk_customizer->add_setting( 'techtlk_header_download_link_new_tab', 
	array(
		'default'    => '1',
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_header_download_link_new_tab',
			array(
				'type' => 'switch',
				'label' => esc_html__('Open New Tab','techtlk'),
				'description' => esc_html__('Open the link document in a new window or tab','techtlk'),
				'section' => 'techtlk_header_setting'
			)
		)
	);
	//End Show Top Bar

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_11', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_11', 
			array(
				'settings'		=> 'header_hr_11',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Meta Text Alignment
	$techtlk_customizer->add_setting( 'techtlk_header_width', array(
		'default'           => 'container',
		'transport'	        => 'postMessage',
	) );
	$techtlk_customizer->add_control( 'techtlk_header_width', array(
		'label'   => esc_html__( 'Header Area Width', 'techtlk' ),
		'section' => 'techtlk_header_setting',
		'type'    => 'select',
		'choices' => array(
			'container' => esc_html__( 'Container', 'techtlk' ),
			'container-fluid' => esc_html__( 'Container Fluid', 'techtlk' ),
			),
	));
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'header_hr_12', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'header_hr_12', 
			array(
				'settings'		=> 'header_hr_12',
				'section'  		=> 'techtlk_header_setting',
			)
		)
	);
	//End separator

	//Start Header Bg Color
	$techtlk_customizer->add_setting (
        'techtlk_style_header_bg_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_style_header_bg_color',
            array(
                'label'      => esc_html__('Header Bg Color','techtlk'),
                'description'      => esc_html__('Select Header Bg Color','techtlk'),
                'section'    => 'techtlk_header_setting',
                'settings'   => 'techtlk_style_header_bg_color',
            )
        )
    );
	//End Header Bg Color
}