<?php
function techtlk_offcanvas_sidebar_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_offcanvas_sidebar_setting' , array(
        'title'      => esc_html__( 'Offcanvas Sidebar Setting', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

	// Offcanvas Sidebar Logo Control Start
	$techtlk_customizer->add_setting( 'offcanvas_sidebar_logo_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'offcanvas_sidebar_logo_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('Offcanvas Sidebar Logo','techtlk'),
				'description' => esc_html__('You can enable or disable offcanvas sidebar logo here','techtlk'),
				'section' => 'techtlk_offcanvas_sidebar_setting'
			)
		)
	);
	// Offcanvas Sidebar Logo Control End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_30', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_30', 
			array(
				'settings'		=> 'separator_30',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Image
	$techtlk_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_img', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'rstheme_offcanvas_sidebar_logo_img',
			array(
			'label'      => esc_html__( 'Logo', 'techtlk' ),
			'section'    => 'techtlk_offcanvas_sidebar_setting',
			'settings'   => 'rstheme_offcanvas_sidebar_logo_img',
			)
		)   
	);
	//End Offcanvas Sidebar Logo Image

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_31', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_31', 
			array(
				'settings'		=> 'separator_31',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Height
	$techtlk_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_image_height',
		array(
			'default' => esc_html__( '30px', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	);

	$techtlk_customizer->add_control('rstheme_offcanvas_sidebar_logo_image_height', array(
        'section'	=> 'techtlk_offcanvas_sidebar_setting',
        'label'		=> esc_html__( 'Logo Height', 'techtlk' ),
        'description' => esc_html__( 'Logo height example(30px)', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_offcanvas_sidebar_logo_image_height'
    ));
	//End Offcanvas Sidebar Logo Height

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_32', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_32', 
			array(
				'settings'		=> 'separator_32',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Margin Bottom
	$techtlk_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_bottom_margin',
		array(
			'default' => esc_html__( '20px', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	);

	$techtlk_customizer->add_control('rstheme_offcanvas_sidebar_logo_bottom_margin', array(
        'section'	=> 'techtlk_offcanvas_sidebar_setting',
        'label'		=> esc_html__( 'Logo Margin Bottom', 'techtlk' ),
        'description' => esc_html__( 'Logo Margin Bottom example(20px)', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_offcanvas_sidebar_logo_bottom_margin'
    ));
	//End Offcanvas Sidebar Logo Margin Bottom

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_33', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_33', 
			array(
				'settings'		=> 'separator_33',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Widget Title Color
	$techtlk_customizer->add_setting (
        'techtlk_mobile_sidebar_widget_title_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mobile_sidebar_widget_title_color',
            array(
                'label'       => esc_html__('Widget Title Color','techtlk'),
                'description' => esc_html__('Pic Color','techtlk'),
                'section'     => 'techtlk_offcanvas_sidebar_setting',
                'settings'    => 'techtlk_mobile_sidebar_widget_title_color',
            )
        )
    );
	//End Mobile Sidebar Widget Title Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_333', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_333', 
			array(
				'settings'		=> 'separator_333',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Normal Color
	$techtlk_customizer->add_setting (
        'techtlk_mobile_sidebar_menu_normal_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mobile_sidebar_menu_normal_color',
            array(
                'label'       => esc_html__('Mobile Menu Normal Color','techtlk'),
                'description' => esc_html__('Pic Color','techtlk'),
                'section'     => 'techtlk_offcanvas_sidebar_setting',
                'settings'    => 'techtlk_mobile_sidebar_menu_normal_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Normal Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_34', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_34', 
			array(
				'settings'		=> 'separator_34',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Hover Color
	$techtlk_customizer->add_setting (
        'techtlk_mobile_sidebar_menu_hover_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mobile_sidebar_menu_hover_color',
            array(
                'label'       => esc_html__('Mobile Menu Hover Color','techtlk'),
                'description' => esc_html__('Pic Color','techtlk'),
                'section'     => 'techtlk_offcanvas_sidebar_setting',
                'settings'    => 'techtlk_mobile_sidebar_menu_hover_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Hover Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_35', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_35', 
			array(
				'settings'		=> 'separator_35',
				'section'  		=> 'techtlk_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Active Color
	$techtlk_customizer->add_setting (
        'techtlk_mobile_sidebar_menu_active_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mobile_sidebar_menu_active_color',
            array(
                'label'       => esc_html__('Mobile Menu Active Color','techtlk'),
                'description' => esc_html__('Pic Color','techtlk'),
                'section'     => 'techtlk_offcanvas_sidebar_setting',
                'settings'    => 'techtlk_mobile_sidebar_menu_active_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Active Color
}