<?php
function techtlk_mouse_pointer_panel($techtlk_customizer, $priority)
{
    $techtlk_customizer->add_section('techtlk_mouse_pt_setting', array(
        'title' => esc_html__('Mouse Pointer Setting', 'techtlk'),
        'priority' => $priority,
        'panel' => 'techtlk_options_panel',
    ));

    //Start enabal global setting
    $techtlk_customizer->add_setting('techtlk_mouse_pt_enabel_pointer',
        array(
            'default' => '1',
            'sanitize_callback' => 'techtlk_sanitize_integer',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Customize_Switch_Control(
            $techtlk_customizer,
            'techtlk_mouse_pt_enabel_pointer',
            array(
                'type' => 'switch',
                'label' => esc_html__('Show Pointer', 'techtlk'),
                'description' => esc_html__('You can show or hide Mouse Pointer', 'techtlk'),
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End enabal global setting

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_0',
            array(
                'settings' => 'mouse_pt_hr_0',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $techtlk_customizer->add_setting(
        'techtlk_mouse_pt_pointer_border_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mouse_pt_pointer_border_color',
            array(
                'label' => esc_html__('Pointer Border', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_mouse_pt_setting',
                'settings' => 'techtlk_mouse_pt_pointer_border_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_1',
            array(
                'settings' => 'mouse_pt_hr_1',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator

	//Start container size
    $techtlk_customizer->add_setting(
        'techtlk_mouse_pt_border_width',
        array(
            'default' => esc_html__('2', 'techtlk'),
            'transport' => 'refresh',
        )
    );

    $techtlk_customizer->add_control('techtlk_mouse_pt_border_width', array(
        'section' => 'techtlk_mouse_pt_setting',
        'label' => esc_html__('Border Width', 'techtlk'),
        'description' => esc_html__('Enter Pointer Border Width', 'techtlk'),
        'type' => 'text',
        'setting' => 'techtlk_mouse_pt_border_width',
    ));
    //End container size

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_2',
            array(
                'settings' => 'mouse_pt_hr_2',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $techtlk_customizer->add_setting(
        'techtlk_mouse_pt_pointer_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_mouse_pt_pointer_bg_color',
            array(
                'label' => esc_html__('Pointer Background', 'techtlk'),
                'description' => esc_html__('Enter Pointer Background color', 'techtlk'),
                'section' => 'techtlk_mouse_pt_setting',
                'settings' => 'techtlk_mouse_pt_pointer_bg_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_4',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_4',
            array(
                'settings' => 'mouse_pt_hr_4',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator	

	//Start container size
	$techtlk_customizer->add_setting(
		'techtlk_mouse_pt_diameter',
		array(
			'default' => esc_html__('40', 'techtlk'),
			'transport' => 'refresh',
		)
	);

	$techtlk_customizer->add_control('techtlk_mouse_pt_diameter', array(
		'section' => 'techtlk_mouse_pt_setting',
		'label' => esc_html__('Diameter', 'techtlk'),
		'description' => esc_html__('Enter Pointer diameter Size', 'techtlk'),
		'type' => 'text',
		'setting' => 'techtlk_mouse_pt_diameter',
	));
	//End container size

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_5',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_5',
            array(
                'settings' => 'mouse_pt_hr_5',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator	

	//Start container size
    $techtlk_customizer->add_setting(
        'techtlk_mouse_pt_pointer_speed',
        array(
            'default' => esc_html__('4', 'techtlk'),
            'transport' => 'refresh',
        )
    );

    $techtlk_customizer->add_control('techtlk_mouse_pt_pointer_speed', array(
        'section' => 'techtlk_mouse_pt_setting',
        'label' => esc_html__('Pointer Speed', 'techtlk'),
        'description' => esc_html__('Enter Pointer Scale Size', 'techtlk'),
        'type' => 'text',
        'setting' => 'techtlk_mouse_pt_pointer_speed',
    ));
    //End container size

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_6',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_6',
            array(
                'settings' => 'mouse_pt_hr_6',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator

	//Start container size
    $techtlk_customizer->add_setting(
        'techtlk_mouse_pt_hover_scale',
        array(
            'default' => esc_html__('1.3', 'techtlk'),
            'transport' => 'refresh',
        )
    );

    $techtlk_customizer->add_control('techtlk_mouse_pt_hover_scale', array(
        'section' => 'techtlk_mouse_pt_setting',
        'label' => esc_html__('Hover Scale', 'techtlk'),
        'description' => esc_html__('Enter Pointer Scale Size', 'techtlk'),
        'type' => 'text',
        'setting' => 'techtlk_mouse_pt_hover_scale',
    ));
    //End container size

    //Start separator
    $techtlk_customizer->add_setting(
        'mouse_pt_hr_7',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'mouse_pt_hr_7',
            array(
                'settings' => 'mouse_pt_hr_7',
                'section' => 'techtlk_mouse_pt_setting',
            )
        )
    );
    //End separator

}
