<?php
function techtlk_page_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_page_setting' , array(
        'title'      => esc_html__( 'Page Setting', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_page_default_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'techtlk_page_default_logo',
			array(
			'label'      => esc_html__( 'Upload Page Logo', 'techtlk' ),
			'section'    => 'techtlk_page_setting',
			'settings'   => 'techtlk_page_default_logo',
			)
		)   
	);
	//End

	//Start Sticky Menu
	$techtlk_customizer->add_setting( 'techtlk_page_enable_sticky_menu', 
	array(
			'default'    => '0',
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_page_enable_sticky_menu',
			array(
				'type' => 'switch',
				'label' => esc_html__('Sticky Menu','techtlk'),
				'description' => esc_html__('You can show or hide sticky menu here','techtlk'),
				'section' => 'techtlk_page_setting'
			)
		)
	);
	//End Sticky Menu

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_page_header_menu_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_header_menu_bg_color',
            array(
                'label' => esc_html__('Header Background Color', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_page_setting',
                'settings' => 'techtlk_page_header_menu_bg_color',
            )
        )
    );
    //End

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_page_header_menu_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_header_menu_color',
            array(
                'label' => esc_html__('Header Menu Color', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_page_setting',
                'settings' => 'techtlk_page_header_menu_color',
            )
        )
    );
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'page_hr_0', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'page_hr_0', 
			array(
				'settings'		=> 'page_hr_0',
				'section'  		=> 'techtlk_page_setting',
			)
		)
	);
	//End separator

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_page_header_menu_hover_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_header_menu_hover_color',
            array(
                'label' => esc_html__('Header Menu Hover Color', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_page_setting',
                'settings' => 'techtlk_page_header_menu_hover_color',
            )
        )
    );
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'page_hr_1', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'page_hr_1', 
			array(
				'settings'		=> 'page_hr_1',
				'section'  		=> 'techtlk_page_setting',
			)
		)
	);
	//End separator

	//Start
    $techtlk_customizer->add_setting(
        'techtlk_page_header_menu_active_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_header_menu_active_color',
            array(
                'label' => esc_html__('Header Menu Active Color', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_page_setting',
                'settings' => 'techtlk_page_header_menu_active_color',
            )
        )
    );
    //End

	//Start separator
	$techtlk_customizer->add_setting(
		'page_hr_2', 
		array(
			'default'           => '',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'page_hr_2', 
			array(
				'settings'		=> 'page_hr_2',
				'section'  		=> 'techtlk_page_setting',
			)
		)
	);
	//End separator

	//Start Color
	$techtlk_customizer->add_setting (
        'techtlk_page_sign_in_text_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_sign_in_text_color',
            array(
                'label'      => esc_html__('Text Color','techtlk'),
                'description'      => esc_html__('Select Text Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_sign_in_text_color',
            )
        )
    );
	//End Color

    //Start Color
	$techtlk_customizer->add_setting (
        'techtlk_page_sign_in_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_sign_in_text_hover_color',
            array(
                'label'      => esc_html__('Hover Color','techtlk'),
                'description'      => esc_html__('Select Hover Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_sign_in_text_hover_color',
            )
        )
    );
	//End Color

    //Start Color
	$techtlk_customizer->add_setting (
        'techtlk_page_download_border_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_download_border_color',
            array(
                'label'      => esc_html__('Button Border Color','techtlk'),
                'description'      => esc_html__('Select Button Border Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_download_border_color',
            )
        )
    );
	//End Color

    //Start Color
	$techtlk_customizer->add_setting (
        'techtlk_page_download_text_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_download_text_color',
            array(
                'label'      => esc_html__('Button Link Color','techtlk'),
                'description'      => esc_html__('Select text Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_download_text_color',
            )
        )
    );
	//End Color

    //Start Color
    $techtlk_customizer->add_setting (
        'techtlk_page_download_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_download_text_hover_color',
            array(
                'label'      => esc_html__('Button Link Hover Color','techtlk'),
                'description'      => esc_html__('Select Text Hover Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_download_text_hover_color',
            )
        )
    );
    //End Color

    //Start Color
	$techtlk_customizer->add_setting (
        'techtlk_page_download_btn_hover_color',
        array(
            'default'     => ''
        )
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_page_download_btn_hover_color',
            array(
                'label'      => esc_html__('Button Hover Color','techtlk'),
                'description'      => esc_html__('Select Button Hover Color','techtlk'),
                'section'    => 'techtlk_page_setting',
                'settings'   => 'techtlk_page_download_btn_hover_color',
            )
        )
    );
	//End Color
}