<?php
function techtlk_portfolio_panel($techtlk_customizer, $priority){
    $techtlk_customizer->add_section('techtlk_portfolio_setting', array(
        'title'    => esc_html__('Portfolio Settings', 'techtlk'),
        'priority' => $priority,
        'panel'    => 'techtlk_options_panel',
    ));

    //Start enabal
    $techtlk_customizer->add_setting('techtlk_enable_portfolio_page_banner',
    array(
        'default' => 0
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Customize_Switch_Control(
        $techtlk_customizer,
        'techtlk_enable_portfolio_page_banner',
        array(
            'type'        => 'switch',
            'label'       => esc_html__('Show Portfolio Page Banner', 'techtlk'),
            'description' => esc_html__('You can select banner show or hide', 'techtlk'),
            'section'     => 'techtlk_portfolio_setting',
        )
    )
    );
    //End enabal

    //Start separator
    $techtlk_customizer->add_setting(
    'portfolio_hr_00',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Separator_Control(
        $techtlk_customizer,
        'portfolio_hr_00',
        array(
            'settings' => 'portfolio_hr_00',
            'section' => 'techtlk_portfolio_setting',
        )
    )
    );
    //End separator

    //Start enabal
    $techtlk_customizer->add_setting('techtlk_enable_portfolio_breadcrumb',
    array(
        'default' => 0
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Customize_Switch_Control(
        $techtlk_customizer,
        'techtlk_enable_portfolio_breadcrumb',
        array(
            'type'        => 'switch',
            'label'       => esc_html__('Show Breadcrumb', 'techtlk'),
            'description' => esc_html__('You want to show breadcrumb click ON', 'techtlk'),
            'section'     => 'techtlk_portfolio_setting',
        )
    )
    );
    //End enabal

    //Start separator
    $techtlk_customizer->add_setting(
    'portfolio_hr_0',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Separator_Control(
        $techtlk_customizer,
        'portfolio_hr_0',
        array(
            'settings' => 'portfolio_hr_0',
            'section' => 'techtlk_portfolio_setting',
        )
    )
    );
    //End separator

    //Start default header logo
    $techtlk_customizer->add_setting(
    'techtlk_portfolio_banner_image',
    array(
        'transport' => 'refresh',
    )
    );
    $techtlk_customizer->add_control(
    new WP_Customize_Image_Control(
        $techtlk_customizer,
        'techtlk_portfolio_banner_image',
        array(
            'label'    => esc_html__('Portfolio Single Page Banner Image', 'techtlk'),
            'section'  => 'techtlk_portfolio_setting',
            'settings' => 'techtlk_portfolio_banner_image',
        )
    )
    );
    //End default logo

    //Start separator
    $techtlk_customizer->add_setting(
    'portfolio_hr_1',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Separator_Control(
        $techtlk_customizer,
        'portfolio_hr_1',
        array(
            'settings' => 'portfolio_hr_1',
            'section' => 'techtlk_portfolio_setting',
        )
    )
    );
    //End separator

    //Start Body Background Color
    $techtlk_customizer->add_setting(
    'techtlk_portfolio_bg_color'
    );
    $techtlk_customizer->add_control(
    new WP_Customize_Color_Control(
        $techtlk_customizer,
        'techtlk_portfolio_bg_color',
        array(
            'label'       => esc_html__('Sinlge Portfolio Body Backgroud Color', 'techtlk'),
            'description' => esc_html__('Pick body background color', 'techtlk'),
            'section'     => 'techtlk_portfolio_setting',
            'settings'    => 'techtlk_portfolio_bg_color',
        )
    )
    );
    //End Body Background Color

    //Start separator
    $techtlk_customizer->add_setting(
    'portfolio_hr_2',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Separator_Control(
        $techtlk_customizer,
        'portfolio_hr_2',
        array(
            'settings' => 'portfolio_hr_2',
            'section' => 'techtlk_portfolio_setting',
        )
    )
    );
    //End separator

    //Start Logo Height
    $techtlk_customizer->add_setting(
    'techtlk_portfolio_banner_title',
    array(
        'transport' => 'refresh',
    )
    );
    $techtlk_customizer->add_control('techtlk_portfolio_banner_title', array(
    'section' => 'techtlk_portfolio_setting',
    'label'   => esc_html__('Portfolio Single Banner Title', 'techtlk'),
    'type'    => 'text',
    'setting' => 'techtlk_portfolio_banner_title',
    ));
    //End Logo Height

    //Start separator
    $techtlk_customizer->add_setting(
    'portfolio_hr_04',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $techtlk_customizer->add_control(
    new techtlk_Separator_Control(
        $techtlk_customizer,
        'portfolio_hr_04',
        array(
            'settings' => 'portfolio_hr_04',
            'section' => 'techtlk_portfolio_setting',
        )
    )
    );
    //End separator

    //Start
    $techtlk_customizer->add_setting(
    'techtlk_portfolio_banner_text',
    array(
        'transport' => 'refresh',
    )
    );
    $techtlk_customizer->add_control('techtlk_portfolio_banner_text', array(
    'section' => 'techtlk_portfolio_setting',
    'label'   => esc_html__('Portfolio Single Banner Text', 'techtlk'),
    'type'    => 'textarea',
    'setting' => 'techtlk_portfolio_banner_text',
    ));
    //End
}
