<?php
function techtlk_preloader_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_preloader_setting' , array(
        'title'      => esc_html__( 'Preloader Setting', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

    //Start Show Top Bar
	$techtlk_customizer->add_setting( 'techtlk_enable_preloader', 
	array(
		'default'    		=> '0', 
		) 
	);
	
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_enable_preloader',
			array(
				'type' 			=> 'switch',
				'label' 		=> esc_html__( 'Show Preloader','techtlk' ),
				'description' 	=> esc_html__( 'You can show or hide preloader','techtlk' ),
				'section' 		=> 'techtlk_preloader_setting'
			)
		)
	);
	//End Show Top Bar

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_0', 
			array(
				'settings'		=> 'separator_0',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Background Color
	$techtlk_customizer->add_setting (
        'techtlk_preloader_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_preloader_bg_color',
            array(
                'label'      => esc_html__('Preloader Background Color','techtlk'),
                'section'    => 'techtlk_preloader_setting',
                'settings'   => 'techtlk_preloader_bg_color',
            )
        )
    );
	//End Preloader Background Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_1', 
			array(
				'settings'		=> 'separator_1',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Border Color
	$techtlk_customizer->add_setting (
        'techtlk_preloader_border_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_preloader_border_color',
            array(
                'label'      => esc_html__('Preloader Border Color','techtlk'),
                'section'    => 'techtlk_preloader_setting',
                'settings'   => 'techtlk_preloader_border_color',
            )
        )
    );
	//End Preloader Border Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_2', 
			array(
				'settings'		=> 'separator_2',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Animate Circle Color
	$techtlk_customizer->add_setting (
        'techtlk_preloader_animate_circle_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_preloader_animate_circle_color',
            array(
                'label'      => esc_html__('Preloader Animate Circle Color','techtlk'),
                'section'    => 'techtlk_preloader_setting',
                'settings'   => 'techtlk_preloader_animate_circle_color',
            )
        )
    );
	//End Preloader Animate Circle Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_3', 
			array(
				'settings'		=> 'separator_3',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Image
	$techtlk_customizer->add_setting(
		'techtlk_preloader_image', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'techtlk_preloader_image',
			array(
			'label'      => esc_html__( 'Preloader Image', 'techtlk' ),
			'section'    => 'techtlk_preloader_setting',
			'settings'   => 'techtlk_preloader_image',
			)
		)   
	);
	//End Preloader Image

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_4', 
			array(
				'settings'		=> 'separator_4',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Cancel Button BG Color
	$techtlk_customizer->add_setting (
        'techtlk_preloader_cancel_button_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_preloader_cancel_button_bg_color',
            array(
                'label'      => esc_html__('Cancel Button Background','techtlk'),
                'section'    => 'techtlk_preloader_setting',
                'settings'   => 'techtlk_preloader_cancel_button_bg_color',
            )
        )
    );
	//End Preloader Cancel Button BG Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_5', 
			array(
				'settings'		=> 'separator_5',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Cancel Button Text Color
	$techtlk_customizer->add_setting (
        'techtlk_preloader_cancel_button_text_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_preloader_cancel_button_text_color',
            array(
                'label'      => esc_html__('Cancel Button Text Color','techtlk'),
                'section'    => 'techtlk_preloader_setting',
                'settings'   => 'techtlk_preloader_cancel_button_text_color',
            )
        )
    );
	//End Preloader Cancel Button BG Color

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_6', 
			array(
				'settings'		=> 'separator_6',
				'section'  		=> 'techtlk_preloader_setting',
			)
		)
	);
	//End separator

	$techtlk_customizer->add_setting(
        'techtlk_preloader_cancel_button_text',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('techtlk_preloader_cancel_button_text', array(
        'section' => 'techtlk_preloader_setting',
        'label'   => esc_html__('Cancle Button Text', 'techtlk'),
        'description' => esc_html__('Default is: Cancle Loader','techtlk'),
        'type'    => 'text',
        'setting' => 'techtlk_preloader_cancel_button_text',
    ));
}