<?php
function techtlk_team_panel($techtlk_customizer, $priority){
    $techtlk_customizer->add_section('techtlk_slug_setting', array(
        'title'    => esc_html__('Post Type Configuration', 'techtlk'),
        'priority' => $priority,
        'panel'    => 'techtlk_options_panel',
    ));

    //Start Portfolio
    $techtlk_customizer->add_setting(
        'rstheme_portfolio_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_portfolio_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Portfolio Slug Change', 'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_slug',
    ));
    // Cat Label
    $techtlk_customizer->add_setting(
        'rstheme_portfolio_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_portfolio_cat_taxonomy_title', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'techtlk'),
        'description' => esc_html__('Default title is: Portfolio Categories','techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_cat_taxonomy_title',
    ));
    // Cat Slug
    $techtlk_customizer->add_setting(
        'rstheme_portfolio_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_portfolio_cat_taxonomy_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'techtlk'),
        'description' => esc_html__("Default slug is: portfolios-categorie (Note: Don't use same slug for portfolio & taxonomy).",'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_cat_taxonomy_slug',
    ));
    //End Portfolio

    //Start separator
	$techtlk_customizer->add_setting(
		'separator_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_1', 
			array(
				'settings'		=> 'separator_1',
				'section'  		=> 'techtlk_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$techtlk_customizer->add_setting(
		'separator_11', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_11', 
			array(
				'settings'		=> 'separator_11',
				'section'  		=> 'techtlk_slug_setting',
			)
		)
	);
	//End separator

    //Start Team
    $techtlk_customizer->add_setting(
        'rstheme_team_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_team_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Team Slug Change', 'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_team_slug',
    ));
    // Cat label
    $techtlk_customizer->add_setting(
        'rstheme_team_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_team_cat_taxonomy_title', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'techtlk'),
        'description' => esc_html__('Default title is: Team Categories','techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_team_cat_taxonomy_title',
    ));
    // Cat Slug
    $techtlk_customizer->add_setting(
        'rstheme_team_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_team_cat_taxonomy_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'techtlk'),
        'description' => esc_html__("Default slug is: teams-categorie (Note: Don't use same slug for team & taxonomy).",'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_team_cat_taxonomy_slug',
    ));
    //End Team

    //Start separator
	$techtlk_customizer->add_setting(
		'separator_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_2', 
			array(
				'settings'		=> 'separator_2',
				'section'  		=> 'techtlk_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$techtlk_customizer->add_setting(
		'separator_22', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_22', 
			array(
				'settings'		=> 'separator_22',
				'section'  		=> 'techtlk_slug_setting',
			)
		)
	);
	//End separator

    //Start Service
    $techtlk_customizer->add_setting(
        'rstheme_service_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_service_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Service Slug Change', 'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_service_slug',
    ));
    // Cat Label
    $techtlk_customizer->add_setting(
        'rstheme_service_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_service_cat_taxonomy_title', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'techtlk'),
        'description' => esc_html__('Default title is: Service Categories','techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_service_cat_taxonomy_title',
    ));
    // Cat Slug
    $techtlk_customizer->add_setting(
        'rstheme_service_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $techtlk_customizer->add_control('rstheme_service_cat_taxonomy_slug', array(
        'section' => 'techtlk_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'techtlk'),
        'description' => esc_html__("Default slug is: services-categorie (Note: Don't use same slug for service & taxonomy).",'techtlk'),
        'type'    => 'text',
        'setting' => 'rstheme_service_cat_taxonomy_slug',
    ));
    //End Service

}
