<?php
function techtlk_breadcrumb_style_panel($techtlk_customizer, $priority)
{
    $techtlk_customizer->add_section('techtlk_breadcrumb_style_setting', array(
        'title' => esc_html__('Breadcrumb Settings', 'techtlk'),
        'priority' => $priority,
        'panel' => 'techtlk_options_panel',
    ));

    //Start Hide
	$techtlk_customizer->add_setting( 'techtlk_page_hide_banner', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_page_hide_banner',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Banner','techtlk'),
				'description' => esc_html__('You can show or hide ','techtlk'),
				'section' => 'techtlk_breadcrumb_style_setting'
			)
		)
	);
	//End Hide

    //Start separator
    $techtlk_customizer->add_setting(
        'breadcrumb_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'breadcrumb_hr_0',
            array(
                'settings' => 'breadcrumb_hr_0',
                'section' => 'techtlk_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Hide
	$techtlk_customizer->add_setting( 'techtlk_page_hide_breadcrumb', 
	array(
		'default'    => 0,
		) 
	);
	$techtlk_customizer->add_control(
		new techtlk_Customize_Switch_Control(
			$techtlk_customizer,
			'techtlk_page_hide_breadcrumb',
			array(
				'type' => 'switch',
				'label' => esc_html__('Show Breadcrumb','techtlk'),
				'description' => esc_html__('You want to show breadcrumb click ON','techtlk'),
				'section' => 'techtlk_breadcrumb_style_setting'
			)
		)
	);
	//End Hide

    //Start separator
    $techtlk_customizer->add_setting(
        'breadcrumb_hr_110',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'breadcrumb_hr_110',
            array(
                'settings' => 'breadcrumb_hr_110',
                'section' => 'techtlk_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $techtlk_customizer->add_setting(
        'techtlk_breadcrumb_bg_color'
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_breadcrumb_bg_color',
            array(
                'label' => esc_html__('Backgroud Color', 'techtlk'),
                'description' => esc_html__('Pick color', 'techtlk'),
                'section' => 'techtlk_breadcrumb_style_setting',
                'settings' => 'techtlk_breadcrumb_bg_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $techtlk_customizer->add_setting(
        'breadcrumb_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'breadcrumb_hr_1',
            array(
                'settings' => 'breadcrumb_hr_1',
                'section' => 'techtlk_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start default Page Banner
	$techtlk_customizer->add_setting(
		'techtlk_page_banner', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$techtlk_customizer->add_control(
		new WP_Customize_Image_Control(
		$techtlk_customizer,
		'techtlk_page_banner',
			array(
			'label'      => esc_html__( 'Page Banner', 'techtlk' ),
			'section'    => 'techtlk_breadcrumb_style_setting',
			'settings'   => 'techtlk_page_banner',
			)
		)   
	);
	//End default Page Banner

    //Start separator
    $techtlk_customizer->add_setting(
        'breadcrumb_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'breadcrumb_hr_2',
            array(
                'settings' => 'breadcrumb_hr_2',
                'section' => 'techtlk_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Blog Page Custom Title
	$techtlk_customizer->add_setting(
		'techtlk_page_custom_title',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('techtlk_page_custom_title', array(
        'section'	=> 'techtlk_breadcrumb_style_setting',
        'label'		=> esc_html__( 'Page Custom Title', 'techtlk' ),
        'description' => esc_html__( 'Enter Page Title Here', 'techtlk' ),
        'type'		=> 'text',
        'setting'	=> 'techtlk_page_custom_title'
    ));
	//End Blog Page Custom Title

    //Start separator
    $techtlk_customizer->add_setting(
        'breadcrumb_hr_3',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'breadcrumb_hr_3',
            array(
                'settings' => 'breadcrumb_hr_3',
                'section' => 'techtlk_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Blog Page Custom Description
	$techtlk_customizer->add_setting(
		'techtlk_page_custom_description',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_page_custom_description', array(
        'section'	=> 'techtlk_breadcrumb_style_setting',
        'label'		=> esc_html__( 'Page Banner Description', 'techtlk' ),
        'description' => esc_html__( 'Enter Page Description Here', 'techtlk' ),
        'type'		=> 'textarea',
        'setting'	=> 'techtlk_page_custom_description'
    ));
	//End Blog Page Custom Description

}
