<?php
if( !function_exists( 'techtlk_customizer_register' ) ){
	function techtlk_customizer_register( $techtlk_customizer ){
	/*-----------------------------
	Theme Options
	-----------------------------*/
	$techtlk_customizer->add_panel( 
		'techtlk_options_panel',
		array(
			'title'      => esc_html__( 'Techtlk Options', 'techtlk' ),
			'description'=> esc_html__( 'General options of Techtlk', 'techtlk'),
			'priority'=> 20,
		)
	);

	/**
	 * General setting panel
	 * 
	 * @since 1.0.0
	 */
	
	techtlk_general_panel( $techtlk_customizer, 0 );
	//End General Setting


	 /**
	 * Start Mobile Menu Logo Style setting
	 * @since 1.0.0
	 */
	techtlk_offcanvas_sidebar_panel( $techtlk_customizer, 81 );
	//End Mobile Menu Logo Style setting

	 /**
	 * Start Preloader Style setting
	 * @since 1.0.0
	 */
	techtlk_preloader_panel( $techtlk_customizer, 82 );
	//End Preloader Style setting

	/**
	 * Start Scroll Up Style setting
	 * @since 1.0.0
	 */
	techtlk_scroll_up_panel( $techtlk_customizer, 83 );
	//End Scroll Up Style setting

	/**
	 * Start GSAP Animation setting
	 * @since 1.0.0
	 */
	techtlk_gsap_animation_panel( $techtlk_customizer, 83 );
	//End GSAP Animation setting
	
	/**
	 * Smooth Scrolling setting
	 * @since 1.0.0
	 */
	techtlk_smooth_scrolling_panel( $techtlk_customizer, 84 );
	//End Smooth Scrolling setting

	 /**
	 * Start Style setting
	 * @since 1.0.0
	 */
	techtlk_style_panel( $techtlk_customizer, 61 );
	

	/**
	 * Start Typography setting
	 * @since 1.0.0
	 */
	techtlk_typography_panel( $techtlk_customizer, 81 );
	//End Typography setting

	 /**
	 * Start Blog setting
	 * @since 1.0.0
	 */

	$techtlk_blog_panel = new PE_WP_Customize_Panel( $techtlk_customizer, 'techtlk_blog_setting', array(
		'title' => esc_html__( 'Blog Settings', 'techtlk' ),
		'panel' => 'techtlk_options_panel',
		'priority' => 100,
		)
	);
	$techtlk_customizer->add_panel( $techtlk_blog_panel );

	techtlk_blog_page_style_panel( $techtlk_customizer, 101 );
	techtlk_blog_single_style_panel( $techtlk_customizer, 102 );
	
	//End Blog setting
	 
	/**
	 * Start Team setting
	 * @since 1.0.0
	 */
	techtlk_team_panel( $techtlk_customizer, 121 );
	//End Team setting
 
	/**
	 * Start woocommerce settings
	 * @since 1.0.0
	 */
	techtlk_woocommerce_panel( $techtlk_customizer, 210 );
	//End woocommerce settings

	techtlk_custom_fonts_panel( $techtlk_customizer, 200 );
	

	/**
	 * Start 404 Page Setting
	 * @since 1.0.0
	 */
	techtlk_404_panel( $techtlk_customizer, 241 );
	//End 404 Page Setting
		
 	}
}
add_action( 'customize_register', 'techtlk_customizer_register' );