<?php
function techtlk_typography_panel( $techtlk_customizer, $priority ){
    $techtlk_customizer->add_section( 'techtlk_typography_setting' , array(
        'title'      => esc_html__( 'Typography Settings', 'techtlk' ),
        'priority'   => $priority,
        'panel'		 => 'techtlk_options_panel'
    ) );

	$rs_custom_fonts = get_terms([
		'taxonomy'   => 'rs_custom_fonts',
		'hide_empty' => false,
	]);


	$rs_custom_font_key = [];
	$rs_custom_font_val = [];
	if( is_array( $rs_custom_fonts ) ){
		foreach( $rs_custom_fonts as $rs_custom_font ){
			array_push( $rs_custom_font_key, $rs_custom_font->name );
			array_push( $rs_custom_font_val, $rs_custom_font->name );
		}
	}

	
	$font_choices_custom = array_combine( array_map(function($el) use ($rs_custom_font_val) {
		return $rs_custom_font_val[$el];
	}, array_keys($rs_custom_font_key)), array_values($rs_custom_font_key));


	if( is_array( $rs_custom_fonts ) && !empty( $rs_custom_fonts ) ){
		array_unshift( $font_choices_custom, esc_html__( 'Custom Font', 'techtlk') );
	}
	

	$font_choices_google = [
		'google'              => esc_html__( 'Google Fonts', 'techtlk'),
		'Space Grotesk'     => esc_html__( 'Space Grotesk', 'techtlk'),
		'Open Sans'           => esc_html__( 'Open Sans', 'techtlk'),
		'Oswald'              => esc_html__( 'Oswald', 'techtlk'),
		'Playfair Display'    => esc_html__( 'Playfair Display', 'techtlk'),
		'Montserrat'          => esc_html__( 'Montserrat', 'techtlk'),
		'Nunito Sans'         => esc_html__( 'Nunito Sans', 'techtlk'),
		'Inter'               => esc_html__( 'Inter', 'techtlk'),
		'Rajdhani'              => esc_html__( 'Rajdhani', 'techtlk'),
		'Comfortaa'           => esc_html__( 'Comfortaa', 'techtlk'),
		'Raleway'             => esc_html__( 'Raleway', 'techtlk'),
		'Droid Sans'          => esc_html__( 'Droid Sans', 'techtlk'),
		'Lato'                => esc_html__( 'Lato', 'techtlk'),
		'Arvo'                => esc_html__( 'Arvo', 'techtlk'),
		'Lora'                => esc_html__( 'Lora', 'techtlk'),
		'Poppins'             => esc_html__( 'Poppins', 'techtlk'),
		'Merriweather'        => esc_html__( 'Merriweather', 'techtlk'),
		'Oxygen'              => esc_html__( 'Oxygen', 'techtlk'),
		'PT Serif'            => esc_html__( 'PT Serif', 'techtlk'),
		'PT Sans'             => esc_html__( 'PT Sans', 'techtlk'),
		'PT Sans Narrow'      => esc_html__( 'PT Sans Narrow', 'techtlk'),
		'Public Sans'         => esc_html__( 'Public Sans', 'techtlk'),
		'Cabin'               => esc_html__( 'Cabin', 'techtlk'),
		'Fjalla One'          => esc_html__( 'Fjalla One', 'techtlk'),
		'Familjen Grotesk'    => esc_html__( 'Familjen Grotesk', 'techtlk'),
		'Francois One'        => esc_html__( 'Francois One', 'techtlk'),
		'Rubik'        		  => esc_html__( 'Rubik', 'techtlk'),
		'Josefin Sans'        => esc_html__( 'Josefin Sans', 'techtlk'),
		'Libre Baskerville'   => esc_html__( 'Libre Baskerville', 'techtlk'),
		'Arimo'               => esc_html__( 'Arimo', 'techtlk'),
		'Ubuntu'              => esc_html__( 'Ubuntu', 'techtlk'),
		'Bitter'              => esc_html__( 'Bitter', 'techtlk'),
		'Yantramanav'         => esc_html__( 'Yantramanav', 'techtlk'),
		'Droid Serif'         => esc_html__( 'Droid Serif', 'techtlk'),
		'Roboto'              => esc_html__( 'Roboto', 'techtlk'),
		'Open Sans Condensed' => esc_html__( 'Open Sans Condensed', 'techtlk'),
		'Roboto Condensed'    => esc_html__( 'Roboto Condensed', 'techtlk'),
		'Roboto Slab'         => esc_html__( 'Roboto Slab', 'techtlk'),
		'Yanone Kaffeesatz'   => esc_html__( 'Yanone Kaffeesatz', 'techtlk'),
		'Rokkitt'             => esc_html__( 'Rokkitt', 'techtlk'),
		'Saira Condensed'     => esc_html__( 'Saira Condensed', 'techtlk'),
		'Oxanium'             => esc_html__( 'Oxanium', 'techtlk'),
		'Source Code Pro'     => esc_html__( 'Source Code Pro', 'techtlk'),
		'Rozha One'     => esc_html__( 'Rozha One', 'techtlk'),
	]; 

	$font_choices = array_merge( $font_choices_custom, $font_choices_google );

	$font_weight = [
		'300' => esc_html__('300', 'techtlk' ),
		'400' => esc_html__('400', 'techtlk' ),
		'500' => esc_html__('500', 'techtlk' ),
		'600' => esc_html__('600', 'techtlk' ),
		'700' => esc_html__('700', 'techtlk' ),
		'800' => esc_html__('800', 'techtlk' ),
		'900' => esc_html__('900', 'techtlk' ),
	];

	//Start
	$techtlk_customizer->add_setting(
		'ty_header_0',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_header_0', 
			array(
				'label'			=> esc_html__( 'Header Typography', 'techtlk' ),
				'settings'		=> 'ty_header_0',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_header_01', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_header_01', 
			array(
				'settings'		=> 'separator_header_01',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting( 'techtlk_header_font');
	$techtlk_customizer->add_control( 'techtlk_header_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your desired font for the header.', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_header_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_header_font_size', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'techtlk' ),
		'description'	=> esc_html__( 'Header font size (15px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_header_font_size'
	));
	//End

	//Start
	$techtlk_customizer->add_setting( 'header_techtlk_fonts_info', array(
			'default' => '400'
		)
	);
	$techtlk_customizer->add_control( 'header_techtlk_fonts_info', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'techtlk' ),
			'description' => __( 'Select Header font Weight', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'ty_body_0',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_body_0', 
			array(
				'label'			=> esc_html__( 'Body Typography', 'techtlk' ),
				'settings'		=> 'ty_body_0',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_body_01', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_body_01', 
			array(
				'settings'		=> 'separator_body_01',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting( 'techtlk_body_font', array(
		'techtlk_body_font',
		array(
			'transport'		=> 'refresh',
		)
	) );
	$techtlk_customizer->add_control( 'techtlk_body_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __( 'Select your desired font for the body.', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_body_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_body_font_size', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'techtlk' ),
		'description'	=> esc_html__( 'Body font size (15px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_body_font_size'
	));
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_fonts_info', array(
			'default' => '400'
		)
	);
	$techtlk_customizer->add_control( 'techtlk_fonts_info', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'techtlk' ),
			'description' => __( 'Select Body font Weight', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_1', 
			array(
				'settings'		=> 'separator_ty_1',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_0',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_0', 
			array(
				'label'			=> esc_html__( 'Heading Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_0',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_heading_font', array(
		'default' => esc_html__( 'Nunito Sans', 'techtlk' )
	) );
	$techtlk_customizer->add_control( 'techtlk_heading_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'All Heading Font', 'techtlk' ),
			'description' => __( 'Select your desired font for the heading.', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_1',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_1', 
			array(
				'label'			=> esc_html__( 'H1 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_1',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h1_font');
	$techtlk_customizer->add_control( 'techtlk_h1_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	 //Start
	 $techtlk_customizer->add_setting(
		'techtlk_h1_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h1_font_size', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'techtlk' ),
        'description'	=> esc_html__( 'Global H1 font size (55px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h1_font_size'
    ));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h1_font_weight',
	);
	$techtlk_customizer->add_control( 'techtlk_h1_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'techtlk' ),
			'description' => __( 'Select h1 font weight', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h1_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h1_line_height', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
        'description'	=> esc_html__( 'Global H1 font line height (30px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h1_line_height'
    ));

 	$techtlk_customizer->add_setting (
        'techtlk_style_h1_color',
    );
    $techtlk_customizer->add_control(
        new WP_Customize_Color_Control(
            $techtlk_customizer,
            'techtlk_style_h1_color',
            array(
                'label'       => esc_html__('H1 Color','techtlk'),
                'description' => esc_html__('Select Color','techtlk'),
                'section'     => 'techtlk_typography_setting',
                'settings'    => 'techtlk_style_h1_color',
            )
        )
    );
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_2', 
			array(
				'settings'		=> 'separator_ty_2',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_2',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_2', 
			array(
				'label'			=> esc_html__( 'H2 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_2',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h2_font');
	$techtlk_customizer->add_control( 'techtlk_h2_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h2_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h2_font_size', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'techtlk' ),
        'description'	=> esc_html__( 'Global H2 font size (55px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h2_font_size'
    ));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h2_font_weight',
		array(
			'transport'		=> 'refresh',
		)
	);
	$techtlk_customizer->add_control( 'techtlk_h2_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'techtlk' ),
			'description' => __( 'Select h2 font weight', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h2_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h2_line_height', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
        'description'	=> esc_html__( 'Global H2 font line height (30px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h2_line_height'
    ));

	$techtlk_customizer->add_setting (
       'techtlk_style_h2_color',
   	);
   	$techtlk_customizer->add_control(
       new WP_Customize_Color_Control(
           $techtlk_customizer,
           'techtlk_style_h2_color',
           array(
               'label'       => esc_html__('H2 Color','techtlk'),
               'description' => esc_html__('Select Color','techtlk'),
               'section'     => 'techtlk_typography_setting',
               'settings'    => 'techtlk_style_h2_color',
           )
       )
   	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_3', 
			array(
				'settings'		=> 'separator_ty_3',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_3',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_3', 
			array(
				'label'			=> esc_html__( 'H3 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_3',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h3_font');
	$techtlk_customizer->add_control( 'techtlk_h3_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h3_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h3_font_size', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'techtlk' ),
        'description'	=> esc_html__( 'Global H3 font size (55px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h3_font_size'
    ));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h3_font_weight',
	);
	$techtlk_customizer->add_control( 'techtlk_h3_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'techtlk' ),
			'description' => __( 'Select h3 font weight', 'techtlk' ),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h3_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $techtlk_customizer->add_control('techtlk_h3_line_height', array(
        'section'		=> 'techtlk_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
        'description'	=> esc_html__( 'Global H3 font line height (30px)', 'techtlk' ),
        'type'			=> 'text',
        'setting'	    => 'techtlk_h3_line_height'
    ));

	$techtlk_customizer->add_setting (
       'techtlk_style_h3_color',
   	);
   	$techtlk_customizer->add_control(
       new WP_Customize_Color_Control(
           $techtlk_customizer,
           'techtlk_style_h3_color',
           array(
               'label'       => esc_html__('H3 Color','techtlk'),
               'description' => esc_html__('Select Color','techtlk'),
               'section'     => 'techtlk_typography_setting',
               'settings'    => 'techtlk_style_h3_color',
           )
       )
   	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_4', 
			array(
				'settings'		=> 'separator_ty_4',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_4',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_4', 
			array(
				'label'			=> esc_html__( 'H4 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_4',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h4_font');
	$techtlk_customizer->add_control( 'techtlk_h4_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h4_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_h4_font_size', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'techtlk' ),
		'description'	=> esc_html__( 'Global H4 font size (55px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_h4_font_size'
	));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h4_font_weight',
	);
	$techtlk_customizer->add_control( 'techtlk_h4_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'techtlk' ),
		'description' => __( 'Select h4 font weight', 'techtlk' ),
		'section'     => 'techtlk_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h4_line_height',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_h4_line_height', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
		'description'	=> esc_html__( 'Global H4 font line height (30px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_h4_line_height'
	));

	$techtlk_customizer->add_setting (
       'techtlk_style_h4_color',
   	);
   	$techtlk_customizer->add_control(
       new WP_Customize_Color_Control(
           $techtlk_customizer,
           'techtlk_style_h4_color',
           array(
               'label'       => esc_html__('H4 Color','techtlk'),
               'description' => esc_html__('Select Color','techtlk'),
               'section'     => 'techtlk_typography_setting',
               'settings'    => 'techtlk_style_h4_color',
           )
       )
   	);
	//End

	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_5', 
			array(
				'settings'		=> 'separator_ty_5',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator	

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_5',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_5', 
			array(
				'label'			=> esc_html__( 'H5 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_5',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h5_font');
	$techtlk_customizer->add_control( 'techtlk_h5_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h5_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_h5_font_size', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'techtlk' ),
		'description'	=> esc_html__( 'Global H5 font size (32px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_h5_font_size'
	));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h5_font_weight',
	);
	$techtlk_customizer->add_control( 'techtlk_h5_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'techtlk' ),
		'description' => __( 'Select h5 font weight', 'techtlk' ),
		'section'     => 'techtlk_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h5_line_height',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_h5_line_height', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
		'description'	=> esc_html__( 'Global H5 font line height (30px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_h5_line_height'
	));

	$techtlk_customizer->add_setting (
       'techtlk_style_h5_color',
   	);
   	$techtlk_customizer->add_control(
       new WP_Customize_Color_Control(
           $techtlk_customizer,
           'techtlk_style_h5_color',
           array(
               'label'       => esc_html__('H5 Color','techtlk'),
               'description' => esc_html__('Select Color','techtlk'),
               'section'     => 'techtlk_typography_setting',
               'settings'    => 'techtlk_style_h5_color',
           )
       )
   	);
	//End
	
	//Start separator
	$techtlk_customizer->add_setting(
		'separator_ty_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$techtlk_customizer->add_control(
		new techtlk_Separator_Control(
			$techtlk_customizer, 
			'separator_ty_6', 
			array(
				'settings'		=> 'separator_ty_6',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$techtlk_customizer->add_setting(
		'ty_heading_6',
	);
	$techtlk_customizer->add_control(
		new techtlk_Heading_Control(
			$techtlk_customizer, 
			'ty_heading_6', 
			array(
				'label'			=> esc_html__( 'H6 Typography', 'techtlk' ),
				'settings'		=> 'ty_heading_6',
				'section'  		=> 'techtlk_typography_setting',
			)
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting( 'techtlk_h6_font');
	$techtlk_customizer->add_control( 'techtlk_h6_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'techtlk' ),
			'description' => __('Select your heading font family', 'techtlk'),
			'section'     => 'techtlk_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h6_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$techtlk_customizer->add_control('techtlk_h6_font_size', array(
		'section'		=> 'techtlk_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'techtlk' ),
		'description'	=> esc_html__( 'Global H6 font size (25px)', 'techtlk' ),
		'type'			=> 'text',
		'setting'	    => 'techtlk_h6_font_size'
	));
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h6_font_weight',
	);
	$techtlk_customizer->add_control( 'techtlk_h6_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'techtlk' ),
		'description' => __( 'Select h6 font weight', 'techtlk' ),
		'section'     => 'techtlk_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$techtlk_customizer->add_setting(
		'techtlk_h6_line_height',
		array(
			'transport'		=> 'refresh',
		)
	);
	$techtlk_customizer->add_control('techtlk_h6_line_height', array(
	'section'		=> 'techtlk_typography_setting',
	'label'			=> esc_html__( 'Font Line Height', 'techtlk' ),
	'description'	=> esc_html__( 'Global H6 font line height (30px)', 'techtlk' ),
	'type'			=> 'text',
	'setting'	    => 'techtlk_h6_line_height'
	));

	$techtlk_customizer->add_setting (
       'techtlk_style_h6_color',
   	);
   	$techtlk_customizer->add_control(
       	new WP_Customize_Color_Control(
           $techtlk_customizer,
           'techtlk_style_h6_color',
           	array(
               'label'       => esc_html__('H6 Color','techtlk'),
               'description' => esc_html__('Select Color','techtlk'),
               'section'     => 'techtlk_typography_setting',
               'settings'    => 'techtlk_style_h6_color',
           	)
       	)
   	);
	//End
}