<?php
function techtlk_woocommerce_panel($techtlk_customizer, $priority)
{
    $techtlk_customizer->add_section('techtlk_shop_setting', array(
        'title'    => esc_html__('Woocommerce Settings', 'techtlk'),
        'priority' => $priority,
        'panel'    => 'techtlk_options_panel',
    ));

    //Start
    $techtlk_customizer->add_setting( 'techtlk_woo_product_overlay', array(
        'default'           => 'enable',
        'transport'         => 'refresh',
    ) );
    $techtlk_customizer->add_control( 'techtlk_woo_product_overlay', array(
        'label'   => esc_html__( 'Product Card Overlay', 'techtlk' ),
        'section' => 'techtlk_shop_setting',
        'type'    => 'select',
        'choices' => array(
            'enable'  => esc_html__( 'Enable', 'techtlk' ),
            ''    => esc_html__( 'Disable', 'techtlk' ),
        ),
    ) );
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        'woocommerce_hr_101',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'woocommerce_hr_101',
            array(
                'settings' => 'woocommerce_hr_101',
                'section' => 'techtlk_shop_setting',
            )
        )
    );
    //End separator

    //Start
    $techtlk_customizer->add_setting( 'techtlk_woo_product_type', array(
        'default'           => 'default_style',
        'transport'         => 'postMessage',
    ) );
    $techtlk_customizer->add_control( 'techtlk_woo_product_type', array(
        'label'   => esc_html__( 'Product Style', 'techtlk' ),
        'section' => 'techtlk_shop_setting',
        'type'    => 'select',
        'choices' => array(
            'default_style'  => esc_html__( 'Default Style', 'techtlk' ),
            'catalog_style'    => esc_html__( 'Catalog Without Price Style', 'techtlk' ),
            'catalog_price_style'    => esc_html__( 'Catalog With Price Style', 'techtlk' ),
        ),
    ) );
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        'woocommerce_hr_01',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'woocommerce_hr_01',
            array(
                'settings' => 'woocommerce_hr_01',
                'section' => 'techtlk_shop_setting',
            )
        )
    );
    //End separator
    
    //Start
    $techtlk_customizer->add_setting( 'techtlk_shop_page_sidebar_setting', array(
        'default'           => 'shop_no_sidebar',
        'transport'         => 'postMessage',
    ) );
    $techtlk_customizer->add_control( 'techtlk_shop_page_sidebar_setting', array(
        'label'   => esc_html__( 'Sidebar Setting', 'techtlk' ),
        'section' => 'techtlk_shop_setting',
        'type'    => 'select',
        'choices' => array(
            'shop_no_sidebar'    => esc_html__( 'Full Wide', 'techtlk' ),
            'shop_left_sidebar'  => esc_html__( 'Left Sidebar', 'techtlk' ),
            'shop_right_sidebar' => esc_html__( 'Right Sidebar', 'techtlk' ),
        ),
    ) );
    //End

    //Start separator
    $techtlk_customizer->add_setting(
        'woocommerce_hr_02',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'woocommerce_hr_02',
            array(
                'settings' => 'woocommerce_hr_02',
                'section' => 'techtlk_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $techtlk_customizer->add_setting(
		'wc_num_product',
		array(
			'default' => esc_html__( '9', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('wc_num_product', array(
        'section'	    => 'techtlk_shop_setting',
        'label'		     => esc_html__( 'Number of Products', 'techtlk' ),
        'description' => esc_html__( 'Show number of products per page', 'techtlk' ),
        'type'		      => 'text',
        'setting'	    => 'wc_num_product'
    ));
	//End

    //Start separator
    $techtlk_customizer->add_setting(
        'woocommerce_hr_03',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'woocommerce_hr_03',
            array(
                'settings' => 'woocommerce_hr_03',
                'section' => 'techtlk_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $techtlk_customizer->add_setting(
		'wc_num_product_per_row',
		array(
			'default' => esc_html__( '3', 'techtlk' ),
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('wc_num_product_per_row', array(
        'section'	    => 'techtlk_shop_setting',
        'label'		     => esc_html__( 'Number of Row', 'techtlk' ),
        'description' => esc_html__( 'Show number of prodcts per row', 'techtlk' ),
        'type'		      => 'text',
        'setting'	    => 'wc_num_product_per_row'
    ));
	//End

    //Start separator
    $techtlk_customizer->add_setting(
        'woocommerce_hr_04',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $techtlk_customizer->add_control(
        new techtlk_Separator_Control(
            $techtlk_customizer,
            'woocommerce_hr_04',
            array(
                'settings' => 'woocommerce_hr_04',
                'section' => 'techtlk_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $techtlk_customizer->add_setting(
		'wc_btn_txt',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $techtlk_customizer->add_control('wc_btn_txt', array(
        'section'	    => 'techtlk_shop_setting',
        'label'		     => esc_html__( 'Button Text', 'techtlk' ),
        'description' => esc_html__( 'Default: "Add to cart", you can change it here.', 'techtlk' ),
        'type'		      => 'text',
        'setting'	    => 'wc_btn_txt'
    ));
	//End
}