<?php
/**
 * @author  rs-theme
 */
function techtlk_body_classes( $classes ) {
  // Adds a class of hfeed to non-singular pages.
  if ( ! is_singular() ) {
    $classes[] = 'hfeed';
  }

  return $classes;
}
add_filter( 'body_class', 'techtlk_body_classes' );

/*
Smooth Scroll Class 
*/
function techtlk_smooth_scroll_class( $classes ) {
  $scrollSmoother = !empty(get_theme_mod('rs_smooth_scroll_enable_disable'));
  if ( $scrollSmoother ) {
      $classes[] = 'rs-smoother-yes';
  }
  return $classes;
}

add_filter( 'body_class', 'techtlk_smooth_scroll_class' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function techtlk_pingback_header() {
  if ( is_singular() && pings_open() ) {
    echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
  }
}

add_action( 'wp_head', 'techtlk_pingback_header' );

/**  kses_allowed_html */

function techtlk_prefix_kses_allowed_html($tags, $context) {
  switch($context) {
    case 'techtlk': 
      $tags = array( 
        'a' => array('href' => array()),
        'b' => array()
      );
      return $tags;
    default: 
      return $tags;
  }
}

add_filter( 'wp_kses_allowed_html', 'techtlk_prefix_kses_allowed_html', 10, 2);

function techtlk_get_postTitleArray($postType = 'post' ) {
    $post_type_query  = new WP_Query(
        array (
            'post_type'      => $postType,
            'posts_per_page' => -1
        )
    );
    // we need the array of posts
    $posts_array      = $post_type_query->posts;
    // the key equals the ID, the value is the post_title
    if ( is_array($posts_array) ) {
        $post_title_array = wp_list_pluck($posts_array, 'post_title', 'ID' );
    }else {
      $post_title_array['default'] = esc_html__( 'Default', 'techtlk' );
    }
    return $post_title_array;
}

function techtlk_studio_fonts_url() {
    $font_url = '';    
    $techtlk_body_font = get_theme_mod('techtlk_body_font', 'Space Grotesk, sans-serif');
    $techtlk_header_font = get_theme_mod('techtlk_header_font', 'Space Grotesk, sans-serif');
    $techtlk_heading_font = get_theme_mod('techtlk_heading_font', 'Space Grotesk, sans-serif');
    $techtlk_h1_font = get_theme_mod('techtlk_h1_font', 'Space Grotesk, sans-serif');
    $techtlk_h2_font = get_theme_mod('techtlk_h2_font', 'Space Grotesk, sans-serif');
    $techtlk_h3_font = get_theme_mod('techtlk_h3_font', 'Space Grotesk, sans-serif');
    $techtlk_h4_font = get_theme_mod('techtlk_h4_font', 'Space Grotesk, sans-serif');
    $techtlk_h5_font = get_theme_mod('techtlk_h5_font', 'Space Grotesk, sans-serif');
    $techtlk_h6_font = get_theme_mod('techtlk_h6_font', 'Space Grotesk, sans-serif');

    $font_families = array();

    if ( $techtlk_body_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_body_font;
    }

    if ( $techtlk_header_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_header_font;
    }

    if ( $techtlk_heading_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_heading_font;
    }

    if ( $techtlk_h1_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h1_font;
    }

    if ( $techtlk_h2_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h2_font;
    }

    if ( $techtlk_h3_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h3_font;
    }

    if ( $techtlk_h4_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h4_font;
    }

    if ( $techtlk_h5_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h5_font;
    }

    if ( $techtlk_h6_font !== 'Space Grotesk, sans-serif' ) {
        $font_families[] = $techtlk_h6_font;
    }

    if ( ! empty( $font_families ) ) {
        $font_url = add_query_arg( 'family', implode( '|', $font_families ) . ':400,500,600,700&display=swap', "//fonts.googleapis.com/css" );
    } else {
        $font_url = add_query_arg( 'family', 'Space+Grotesk:400,500,600,700&display=swap', "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

/*
Enqueue scripts and styles.
*/

function techtlk_studio_scripts() {
    wp_enqueue_style( 'studio-fonts', techtlk_studio_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'techtlk_studio_scripts' );

//Favicon Icon
function techtlk_site_icon() {
    if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) {          
    if(!empty(get_theme_mod('techtlk_favicon')))
    {?>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url(get_theme_mod('techtlk_favicon')); ?>"> 
  <?php 
    }
  }
}
add_filter('wp_head', 'techtlk_site_icon');

//excerpt for specific section
function techtlk_wpex_get_excerpt( $args = array() ) {
  // Defaults
  $defaults = array(
    'post'            => '',
    'length'          => 48,
    'readmore'        => false,
    'readmore_text'   => esc_html__( 'read more', 'techtlk' ),
    'readmore_after'  => '',
    'custom_excerpts' => true,
    'disable_more'    => false,
  );
  // Apply filters
  $defaults = apply_filters( 'techtlk_wpex_get_excerpt_defaults', $defaults );
  // Parse args
  $args = wp_parse_args( $args, $defaults );
  // Apply filters to args
  $args = apply_filters( 'techtlk_wpex_get_excerpt_args', $defaults );
  // Extract
  extract( $args );
  // Get global post data
  if ( ! $post ) {
    global $post;
  }

  // Get post ID
  $post_id = $post->ID;

  // Check for custom excerpt
  if ( $custom_excerpts && has_excerpt( $post_id ) ) {
    $output = $post->post_excerpt;
  }
  // No custom excerpt...so lets generate one
  else {
    // Readmore link
    $readmore_link = '<a href="' . get_permalink( $post_id ) . '" class="readmore">' . $readmore_text . $readmore_after . '</a>';
    // Check for more tag and return content if it exists
    if ( ! $disable_more && strpos( $post->post_content, '<!--more-->' ) ) {
      $output = apply_filters( 'the_content', get_the_content( $readmore_text . $readmore_after ) );
    }
    // No more tag defined so generate excerpt using wp_trim_words
    else {
      // Generate excerpt
      $output = wp_trim_words( strip_shortcodes( $post->post_content ), $length );
      // Add readmore to excerpt if enabled
      if ( $readmore ) {
        $output .= apply_filters( 'techtlk_wpex_readmore_link', $readmore_link );
      }

    }

  }
  // Apply filters and echo
  return apply_filters( 'techtlk_wpex_get_excerpt', $output );
}


//Demo content file include here

function techtlk_import_files() {
  return array(
    array(
        'import_file_name'           => 'Techtlk Main Demo',
        'categories'                 => array( 'Main Demo' ),
        'import_file_url'            => 'https://rstheme.com/products/demo-data/techtlk/techtlk-content.xml',
        'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/techtlk/techtlk-widgets.wie',      
        'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/techtlk/techtlk-customizer.dat',  
        'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/techtlk/screen.png'),        
        'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'techtlk' ),
        'preview_url'                => 'https://techtlk.rstheme.com/demo',
    ),
    array(
        'import_file_name'           => 'Techtlk RTL Demo',
        'categories'                 => array( 'RTL Demo' ),
        'import_file_url'            => 'https://rstheme.com/products/demo-data/techtlk/rtl/techtlk-content.xml',
        'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/techtlk/rtl/techtlk-widgets.wie',      
        'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/techtlk/rtl/techtlk-customizer.dat',  
        'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/techtlk/rtl/screen.png'),       
        'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'techtlk' ),
        'preview_url'                => 'https://techtlk.rstheme.com/rtl',

    ),
    
  );
}

add_filter( 'pt-ocdi/import_files', 'techtlk_import_files' );


function techtlk_set_import_id(){
    if(isset( $_GET['import'] )) {
        $import_demo_id =(int) $_GET['import'];
        unset($_COOKIE['import_id']);
        if(!isset($_COOKIE['import_id'])) {
            setcookie('import_id', $import_demo_id, time()+3600); 
        }  
    }
}  

add_action( 'init', 'techtlk_set_import_id');


function techtlk_after_import_setup() {

    // Assign menus to their locations.
    $main_menu       = get_term_by( 'name', 'Main Menu', 'nav_menu' ); 
    $mobile_menu     = get_term_by( 'name', 'Responsive Menu', 'nav_menu' ); 
    $single_menu     = get_term_by( 'name', 'Onepage Menu', 'nav_menu' ); 

    set_theme_mod( 'nav_menu_locations', array(
                'menu-1' => $main_menu->term_id,        
                'menu-2' => $mobile_menu->term_id,        
                'menu-3' => $single_menu->term_id        
            )
    );

      // Assign front page and posts page (blog page).
      $front_page_id = get_page_by_title( 'Home' );
      $blog_page_id  = get_page_by_title( 'Blog' );

      update_option( 'show_on_front', 'page' );
      update_option( 'page_on_front', $front_page_id->ID );
      update_option( 'page_for_posts', $blog_page_id->ID ); 

    if(class_exists('RevSlider'))
    {
        if($selected==0) {
            $slider = new RevSlider();
            ob_start();
            $slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/slider-1.zip");
            $slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/ai.zip");
            ob_get_clean();
        }

        if($selected==1){
            $slider = new RevSlider();
            ob_start();
            $slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/Ai-Technology--Rtl.zip");
            $slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/rtl/Software-Company--Rtl.zip");
            ob_get_clean();
        }

  
    }

    if(isset($_COOKIE['import_id'])) {
        
        $selected= (int)$_COOKIE['import_id'];

        if($selected==0){
            $import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/main/elementor-kit.zip';
            $import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
            $import_settings['referrer'] = 'remote';
            $import_export_module->import_kit( $import_kit_zip, $import_settings );    
        }

        if($selected==1) {      
            $import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/rtl/elementor-kit.zip';
            $import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
            $import_settings['referrer'] = 'remote';
            $import_export_module->import_kit( $import_kit_zip, $import_settings );    
        }

    }

    unset($_COOKIE['import_id']);

}
add_action( 'pt-ocdi/after_import', 'techtlk_after_import_setup' );


// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
// Disables the block editor from managing widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );

//disable elementor default style 
update_option('elementor_disable_color_schemes', 'yes');
update_option('elementor_disable_typography_schemes', 'yes');

//added elementor support for custom post type
function techtlk_check_in_elementor_wp_custom_post_type() {
  add_post_type_support( 'teams', 'elementor' );
  add_post_type_support( 'services', 'elementor' );
  add_post_type_support( 'careers', 'elementor' );
  add_post_type_support( 'testimonials', 'elementor' );
  add_post_type_support( 'events', 'elementor' );
  add_post_type_support( 'portfolios', 'elementor' );
  add_post_type_support( 'elementor-rshf', 'elementor' );
}
add_action( 'init', 'techtlk_check_in_elementor_wp_custom_post_type' );