<?php
/**
 * @author  rs-theme
 * @since   1.0
 * @version 1.0 
 */

function techtlk_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'techtlk' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'This is sidebar area for blog post and single post.', 'techtlk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Offcanvas Sidebar', 'techtlk' ),
		'id'            => 'rs-offcanvas-sidebar',
		'description'   => esc_html__( 'This is sidebar area for offcanvas.', 'techtlk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Mobile Offcanvas Sidebar', 'techtlk' ),
		'id'            => 'rs-mobile-offcanvas-sidebar',
		'description'   => esc_html__( 'This is sidebar area for mobile offcanvas.', 'techtlk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Services Sidebar', 'techtlk' ),
		'id'            => 'rs-services-sidebar',
		'description'   => esc_html__( 'This is sidebar area for services.', 'techtlk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Projects Sidebar', 'techtlk' ),
		'id'            => 'rs-projects-sidebars',
		'description'   => esc_html__( 'This is sidebar area for projects.', 'techtlk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	if ( class_exists( 'WooCommerce' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar Shop', 'techtlk' ),
			'id'            => 'sidebar_shop',
			'description'   => esc_html__( 'Sidebar Shop', 'techtlk' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );
	}		
}
add_action( 'widgets_init', 'techtlk_widgets_init' );