<?php 
get_header();
$post_id      = get_the_id();
$author_id    = get_post_field ('post_author', $post_id);
$display_name = get_the_author_meta( 'display_name' , $author_id );
?>
    <div class="container"> 
        <div id="content">
            <?php
                //checking page layout
                $page_layout = get_theme_mod( 'techtlk_blog_single_sidebar_setting' );
                $col_side    = '';
                $col_letf    = '';
                if($page_layout == '2left'){
                    $col_side = '8';
                    $col_letf = 'left-sidebar';
                }
                else if($page_layout == '2right'){
                    $col_side = '8';
                }
                else{
                	$col_side = '12';
            	}
                $techtlk_blog_single_hide_author = get_theme_mod( 'techtlk_blog_single_hide_author' );
                $techtlk_blog_single_hide_comment = get_theme_mod( 'techtlk_blog_single_hide_comment' );
                $techtlk_blog_single_hide_published = get_theme_mod( 'techtlk_blog_single_hide_published' );
                $techtlk_blog_single_hide_categiry = get_theme_mod( 'techtlk_blog_single_hide_categiry' );
                $techtlk_blog_single_feature_img_in_col = get_theme_mod( 'techtlk_blog_single_feature_img_in_col' ) ? get_theme_mod( 'techtlk_blog_single_feature_img_in_col' ) : '';
                $heading_tag = get_theme_mod( 'techtlk_blog_single_heading_tag_setting' ) ? get_theme_mod( 'techtlk_blog_single_heading_tag_setting' ) : 'h1';
            ?>
            
          <!-- Blog Detail Start -->
            <div class="rs-blog-details">
                <?php if (empty($techtlk_blog_single_feature_img_in_col)) { ?>
                    <article id="out-col-post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <?php if ((did_action('elementor/loaded') && (function_exists('rshfe_plugin_activation') || function_exists('hfe_plugin_activation')))) { ?>
                            <div class="rs-blog-single-meta"> 
                                <<?php echo esc_html( $heading_tag ); ?> class="page-title">
                                    <?php the_title(); ?>
                                </<?php echo esc_html( $heading_tag ); ?>>
                                <?php if( !($techtlk_blog_single_hide_author === '1' && $techtlk_blog_single_hide_comment === '1' && $techtlk_blog_single_hide_published === '1' && $techtlk_blog_single_hide_categiry === '1')){ ?>
                                    <ul class="bs-meta-area">
                                        <?php if( $techtlk_blog_single_hide_author !== '1' ){ ?>
                                            <li class="author">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 22H18V20C18 18.3431 16.6569 17 15 17H9C7.34315 17 6 18.3431 6 20V22H4V20C4 17.2386 6.23858 15 9 15H15C17.7614 15 20 17.2386 20 20V22ZM12 13C8.68629 13 6 10.3137 6 7C6 3.68629 8.68629 1 12 1C15.3137 1 18 3.68629 18 7C18 10.3137 15.3137 13 12 13ZM12 11C14.2091 11 16 9.20914 16 7C16 4.79086 14.2091 3 12 3C9.79086 3 8 4.79086 8 7C8 9.20914 9.79086 11 12 11Z"></path></svg>
                                                <?php 
                                                    echo esc_html($display_name);
                                                ?>
                                            </li>
                                        <?php } ?>

                                        <?php if( $techtlk_blog_single_hide_published !== '1' ){ ?>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M9 1V3H15V1H17V3H21C21.5523 3 22 3.44772 22 4V20C22 20.5523 21.5523 21 21 21H3C2.44772 21 2 20.5523 2 20V4C2 3.44772 2.44772 3 3 3H7V1H9ZM20 11H4V19H20V11ZM7 5H4V9H20V5H17V7H15V5H9V7H7V5Z"></path></svg>
                                                <?php echo get_the_date(); ?>
                                            </li>
                                        <?php } ?>
                                        <?php if( $techtlk_blog_single_hide_categiry !== '1' ){ ?>
                                            <li>                                                               
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21 8V20.9932C21 21.5501 20.5552 22 20.0066 22H3.9934C3.44495 22 3 21.556 3 21.0082V2.9918C3 2.45531 3.4487 2 4.00221 2H14.9968L21 8ZM19 9H14V4H5V20H19V9ZM8 7H11V9H8V7ZM8 11H16V13H8V11ZM8 15H16V17H8V15Z"></path></svg>
                                                <?php
                                                    $seperator = ', ';
                                                    $after = '';
                                                    $before = '';
                                                    echo '<span class="tag-line">';
                                                        the_category(', '); 
                                                    echo '</span>';
                                                ?>
                                            </li>
                                        <?php } ?>

                                        <?php if( $techtlk_blog_single_hide_comment !== '1' ){ ?>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M5.76282 17H20V5H4V18.3851L5.76282 17ZM6.45455 19L2 22.5V4C2 3.44772 2.44772 3 3 3H21C21.5523 3 22 3.44772 22 4V18C22 18.5523 21.5523 19 21 19H6.45455Z"></path></svg>
                                                <?php echo get_comments_number( '0', '1', '%' ); ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>     
                            </div>
                        <?php } ?>

                        <?php if(has_post_thumbnail()){ ?>
                            <div class="bs-img">
                                <?php the_post_thumbnail(); ?>
                            </div>
                        <?php } ?>
                        <div class="clear-fix"></div>           
                    </article> 
                <?php } ?>
                <div class="row padding-<?php echo esc_attr( $col_letf) ?>">
                    <div class="col-lg-<?php echo esc_attr( $col_side). ' ' .esc_attr( $col_letf) ?>">
                        <?php while ( have_posts() ) : the_post(); ?>    
                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <?php if(has_post_thumbnail() && !empty($techtlk_blog_single_feature_img_in_col)){ ?>
                                    <div class="bs-img">
                                        <?php the_post_thumbnail(); ?>
                                    </div>
                                    <?php if ((did_action('elementor/loaded') && (function_exists('rshfe_plugin_activation') || function_exists('hfe_plugin_activation')))) { ?>
                                        <div class="rs-blog-single-meta inside-col"> 
                                            <<?php echo esc_html( $heading_tag ); ?> class="page-title">
                                                <?php the_title(); ?>
                                            </<?php echo esc_html( $heading_tag ); ?>>
                                            <?php if( !($techtlk_blog_single_hide_author === '1' && $techtlk_blog_single_hide_comment === '1' && $techtlk_blog_single_hide_published === '1' && $techtlk_blog_single_hide_categiry === '1')){ ?>
                                                <ul class="bs-meta-area">
                                                    <?php if( $techtlk_blog_single_hide_author !== '1' ){ ?>
                                                        <li class="author">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 22H18V20C18 18.3431 16.6569 17 15 17H9C7.34315 17 6 18.3431 6 20V22H4V20C4 17.2386 6.23858 15 9 15H15C17.7614 15 20 17.2386 20 20V22ZM12 13C8.68629 13 6 10.3137 6 7C6 3.68629 8.68629 1 12 1C15.3137 1 18 3.68629 18 7C18 10.3137 15.3137 13 12 13ZM12 11C14.2091 11 16 9.20914 16 7C16 4.79086 14.2091 3 12 3C9.79086 3 8 4.79086 8 7C8 9.20914 9.79086 11 12 11Z"></path></svg>
                                                            <?php 
                                                                echo esc_html($display_name);
                                                            ?>
                                                        </li>
                                                    <?php } ?>

                                                    <?php if( $techtlk_blog_single_hide_published !== '1' ){ ?>
                                                        <li>
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M9 1V3H15V1H17V3H21C21.5523 3 22 3.44772 22 4V20C22 20.5523 21.5523 21 21 21H3C2.44772 21 2 20.5523 2 20V4C2 3.44772 2.44772 3 3 3H7V1H9ZM20 11H4V19H20V11ZM7 5H4V9H20V5H17V7H15V5H9V7H7V5Z"></path></svg>
                                                            <?php echo get_the_date(); ?>
                                                        </li>
                                                    <?php } ?>
                                                    <?php if( $techtlk_blog_single_hide_categiry !== '1' ){ ?>
                                                        <li>                                                               
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M21 8V20.9932C21 21.5501 20.5552 22 20.0066 22H3.9934C3.44495 22 3 21.556 3 21.0082V2.9918C3 2.45531 3.4487 2 4.00221 2H14.9968L21 8ZM19 9H14V4H5V20H19V9ZM8 7H11V9H8V7ZM8 11H16V13H8V11ZM8 15H16V17H8V15Z"></path></svg>
                                                            <?php
                                                                $seperator = ', ';
                                                                $after = '';
                                                                $before = '';
                                                                echo '<span class="tag-line">';
                                                                    the_category(', '); 
                                                                echo '</span>';
                                                            ?>
                                                        </li>
                                                    <?php } ?>

                                                    <?php if( $techtlk_blog_single_hide_comment !== '1' ){ ?>
                                                        <li>
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M5.76282 17H20V5H4V18.3851L5.76282 17ZM6.45455 19L2 22.5V4C2 3.44772 2.44772 3 3 3H21C21.5523 3 22 3.44772 22 4V18C22 18.5523 21.5523 19 21 19H6.45455Z"></path></svg>
                                                            <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            <?php } ?>     
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                                <?php
                                  get_template_part( 'template-parts/post/content', get_post_format() );         
                                ?>
                                <div class="clear-fix"></div>           
                            </article> 
                        
                        <?php       
                        $author_meta = get_the_author_meta('description'); 
                        if( !empty($author_meta) ){
                        ?>
                            <div class="author-block">
                              <div class="author-img"> <?php echo get_avatar(get_the_author_meta( 'ID' ), 260);?> </div>
                              <div class="author-desc">
                                <h3 class="author-title">
                                  <?php the_author();?>
                                </h3>
                                <p>
                                  <?php   
                                    echo wpautop( get_the_author_meta( 'description' ) );
                                  ?>
                                </p>
                                <a href="<?php echo esc_url(get_the_author_meta('user_url'))?>" target="_blank">
                                  <?php echo esc_url(get_the_author_meta( 'user_url'))?></a> 
                                </div>
                            </div>
                            <!-- .author-block -->
                        <?php }
                                  
                        ?>
                        <?php 
                        $blog_author = '';
                        if($blog_author == ""){
                            if ( comments_open() || get_comments_number() ) :
                                comments_template();
                            endif;
                        }
                        endwhile; // End of the loop.
                        ?>
                    </div>
                  <?php
                    if( $page_layout == '2left' || $page_layout == '2right'):
                        get_sidebar('single');
                    endif; ?>
                </div>
            </div>
          <!-- Blog Detail End --> 
        </div>
    </div>
<!-- .container -->
<?php
get_footer();